/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import fish.payara.maven.plugins.micro.Option;
import fish.payara.maven.plugins.micro.processor.MicroFetchProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.toolchain.Toolchain;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="start")
public class StartMojo
extends BasePayaraMojo {
    String ERROR_MESSAGE = "Errors occurred while executing payara-micro.";
    @Parameter(property="javaPath")
    private String javaPath;
    @Parameter(property="payaraVersion", defaultValue="5.2020.5")
    private String payaraVersion;
    @Parameter(property="payaraMicroAbsolutePath")
    private String payaraMicroAbsolutePath;
    @Parameter(property="daemon", defaultValue="false")
    private boolean daemon;
    @Parameter(property="immediateExit", defaultValue="false")
    private boolean immediateExit;
    @Parameter(property="artifactItem")
    private ArtifactItem artifactItem;
    @Parameter(property="useUberJar", defaultValue="false")
    private boolean useUberJar;
    @Parameter(property="deployWar", defaultValue="false")
    private boolean deployWar;
    @Parameter(property="exploded", defaultValue="false")
    private boolean exploded;
    @Parameter(property="debug", defaultValue="false")
    private String debug;
    @Parameter(property="contextRoot")
    private String contextRoot;
    @Parameter(property="netbeans.deploy.clientUrlPart")
    private String clientUrlPart;
    @Deprecated
    @Parameter(property="copySystemProperties", defaultValue="false")
    private boolean copySystemProperties;
    @Parameter(property="commandLineOptions")
    private List<Option> commandLineOptions;
    @Parameter(property="javaCommandLineOptions")
    private List<Option> javaCommandLineOptions;
    @Parameter(property="classpathArtifactItems")
    private List<ArtifactItem> classpathArtifactItems;
    private Process microProcess;
    private Thread microProcessorThread;
    private final ThreadGroup threadGroup = new ThreadGroup("PayaraMicroThread");
    private Toolchain toolchain;

    StartMojo() {
    }

    public void execute() throws MojoExecutionException {
        if (this.copySystemProperties) {
            this.getLog().warn((CharSequence)"copySystemProperties is deprecated. System properties of the regarding maven execution will be passed to the payara-micro automatically.");
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Start mojo execution is skipped");
            return;
        }
        this.toolchain = this.getToolchain();
        String path = this.decideOnWhichMicroToUse();
        this.microProcessorThread = new Thread(this.threadGroup, () -> {
            String execArgs;
            ArrayList<String> actualArgs = new ArrayList<String>();
            this.getLog().info((CharSequence)("Starting payara-micro from path: " + path));
            int indice = 0;
            actualArgs.add(indice++, this.evaluateJavaPath());
            if (this.debug != null && !this.debug.equalsIgnoreCase("false")) {
                if (Boolean.parseBoolean(this.debug)) {
                    actualArgs.add(indice++, "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
                } else {
                    actualArgs.add(indice++, this.debug);
                }
            }
            if (this.javaCommandLineOptions != null) {
                for (Option option : this.javaCommandLineOptions) {
                    if (option.getKey() != null && option.getValue() != null) {
                        String systemProperty = String.format("%s=%s", option.getKey(), option.getValue());
                        actualArgs.add(indice++, systemProperty);
                        continue;
                    }
                    if (option.getValue() == null) continue;
                    actualArgs.add(indice++, option.getValue());
                }
            }
            if ((execArgs = this.mavenSession.getRequest().getUserProperties().getProperty("exec.args")) != null && !execArgs.trim().isEmpty()) {
                for (String execArg : execArgs.split("\\s+")) {
                    actualArgs.add(indice++, execArg);
                }
            }
            actualArgs.add(indice++, "-Dgav=" + this.getProjectGAV());
            if (this.classpathArtifactItems != null && this.classpathArtifactItems.size() > 0) {
                actualArgs.add(indice++, "-cp");
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ArtifactItem artifactItem : this.classpathArtifactItems) {
                    DefaultArtifact artifact = new DefaultArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getVersion(), null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
                    arrayList.add(this.findLocalPathOfArtifact(artifact));
                }
                arrayList.add(path);
                actualArgs.add(indice++, StringUtils.join(arrayList, (String)File.pathSeparator));
                actualArgs.add(indice++, "fish.payara.micro.PayaraMicro");
            } else {
                actualArgs.add(indice++, "-jar");
                actualArgs.add(indice++, path);
            }
            if (this.deployWar && "war".equalsIgnoreCase(this.mavenProject.getPackaging())) {
                if (this.useUberJar) {
                    this.getLog().warn((CharSequence)"useUberJar and deployWar are both set to true! You'll probably have your application tried to deploy twice: 1. as uber jar 2. as a separate war");
                }
                actualArgs.add(indice++, "--deploy");
                if (this.exploded) {
                    actualArgs.add(indice++, this.evaluateProjectArtifactAbsolutePath(""));
                } else {
                    actualArgs.add(indice++, this.evaluateProjectArtifactAbsolutePath("." + this.mavenProject.getPackaging()));
                }
            }
            if (this.clientUrlPart != null && !this.clientUrlPart.trim().isEmpty()) {
                actualArgs.add(indice++, "--contextroot");
                actualArgs.add(indice++, this.clientUrlPart.trim());
            } else if (this.contextRoot != null) {
                actualArgs.add(indice++, "--contextroot");
                actualArgs.add(indice++, this.contextRoot);
            }
            if (this.commandLineOptions != null) {
                for (Option option : this.commandLineOptions) {
                    if (option.getKey() != null) {
                        actualArgs.add(indice++, option.getKey());
                    }
                    if (option.getValue() == null) continue;
                    actualArgs.add(indice++, option.getValue());
                }
            }
            try {
                this.getLog().debug((CharSequence)("Starting Payara Micro with the these arguments: " + actualArgs));
                Runtime runtime = Runtime.getRuntime();
                this.microProcess = runtime.exec(actualArgs.toArray(new String[actualArgs.size()]));
                if (this.daemon) {
                    this.redirectStream(this.microProcess.getInputStream(), System.out);
                    this.redirectStream(this.microProcess.getErrorStream(), System.err);
                } else {
                    this.redirectStreamToGivenOutputStream(this.microProcess.getInputStream(), System.out);
                    this.redirectStreamToGivenOutputStream(this.microProcess.getErrorStream(), System.err);
                }
                int exitCode = this.microProcess.waitFor();
                if (exitCode != 0) {
                    throw new MojoFailureException(this.ERROR_MESSAGE);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new RuntimeException(this.ERROR_MESSAGE, exception);
            }
            finally {
                if (!this.daemon) {
                    this.closeMicroProcess();
                }
            }
        });
        Thread shutdownHook = new Thread(this.threadGroup, () -> {
            if (this.microProcess != null && this.microProcess.isAlive()) {
                try {
                    this.microProcess.destroy();
                    this.microProcess.waitFor(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.microProcess.destroyForcibly();
                }
            }
        });
        if (this.daemon) {
            this.microProcessorThread.setDaemon(true);
            this.microProcessorThread.start();
            if (!this.immediateExit) {
                try {
                    this.microProcessorThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            this.microProcessorThread.run();
        }
    }

    private String evaluateJavaPath() {
        String javaToUse = "java";
        if (StringUtils.isNotEmpty((String)this.javaPath)) {
            javaToUse = this.javaPath;
        } else if (this.toolchain != null) {
            javaToUse = this.toolchain.findTool("java");
        }
        return javaToUse;
    }

    private String decideOnWhichMicroToUse() throws MojoExecutionException {
        if (this.useUberJar) {
            String path = this.evaluateProjectArtifactAbsolutePath("-" + this.uberJarClassifier + "." + "jar");
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                throw new MojoExecutionException("\"useUberJar\" option was set to \"true\" but detected path " + path + " does not exist. You need to execute the \"bundle\" goal before using this option.");
            }
            return path;
        }
        if (this.payaraMicroAbsolutePath != null) {
            return this.payaraMicroAbsolutePath;
        }
        if (this.artifactItem.getGroupId() != null) {
            DefaultArtifact artifact = new DefaultArtifact(this.artifactItem.getGroupId(), this.artifactItem.getArtifactId(), this.artifactItem.getVersion(), null, this.artifactItem.getType(), this.artifactItem.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
            return this.findLocalPathOfArtifact(artifact);
        }
        if (this.payaraVersion != null) {
            MojoExecutor.ExecutionEnvironment environment = this.getEnvironment();
            MicroFetchProcessor microFetchProcessor = new MicroFetchProcessor();
            microFetchProcessor.set(this.payaraVersion).handle(environment);
            DefaultArtifact artifact = new DefaultArtifact("fish.payara.extras", "payara-micro", this.payaraVersion, null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
            return this.findLocalPathOfArtifact(artifact);
        }
        throw new MojoExecutionException("Could not determine Payara Micro path. Please set it by defining either \"useUberJar\", \"payaraMicroAbsolutePath\" or \"artifactItem\" configuration options.");
    }

    private String findLocalPathOfArtifact(DefaultArtifact artifact) {
        Artifact payaraMicroArtifact = this.mavenSession.getLocalRepository().find((Artifact)artifact);
        return payaraMicroArtifact.getFile().getAbsolutePath();
    }

    private String evaluateProjectArtifactAbsolutePath(String extension) {
        String projectJarAbsolutePath = this.mavenProject.getBuild().getDirectory() + File.separator;
        projectJarAbsolutePath = projectJarAbsolutePath + this.evaluateExecutorName(extension);
        return projectJarAbsolutePath;
    }

    private String evaluateExecutorName(String extension) {
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifactId() + '-' + this.mavenProject.getVersion() + extension;
    }

    void closeMicroProcess() {
        if (this.microProcess != null) {
            try {
                this.microProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.microProcess.destroy();
                this.getLog().info((CharSequence)"Terminated payara-micro.");
            }
        }
    }

    Process getMicroProcess() {
        return this.microProcess;
    }

    private void redirectStream(InputStream inputStream, PrintStream printStream) {
        Thread thread = new Thread(this.threadGroup, () -> {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    printStream.println(line);
                    if (this.immediateExit || !sb.toString().contains("ready in")) continue;
                    this.microProcessorThread.interrupt();
                    br.close();
                    break;
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)this.ERROR_MESSAGE, (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void redirectStreamToGivenOutputStream(InputStream inputStream, OutputStream outputStream) {
        Thread thread = new Thread(this.threadGroup, () -> {
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error occurred while reading stream", (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }
}

