/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.InvokerLoggerImpl;
import fish.payara.maven.plugins.micro.ReloadMojo;
import fish.payara.maven.plugins.micro.Source;
import fish.payara.maven.plugins.micro.StartMojo;
import fish.payara.maven.plugins.micro.WebDriverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class AutoDeployHandler
implements Runnable {
    private final StartMojo start;
    private final MavenProject project;
    private final File webappDirectory;
    private final Log log;
    private final ExecutorService executorService;
    private WatchService watchService;
    private Future<?> buildReloadTask;
    private final AtomicBoolean cleanPending = new AtomicBoolean(false);
    private final List<Source> sourceUpdatedPending = new CopyOnWriteArrayList<Source>();
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final Path buildPath;
    private static final String RELOADING = "Reloading";

    public AutoDeployHandler(StartMojo start, File webappDirectory) {
        this.start = start;
        this.project = start.getEnvironment().getMavenProject();
        this.webappDirectory = webappDirectory;
        this.log = start.getLog();
        this.executorService = Executors.newSingleThreadExecutor();
        this.buildPath = this.project.getBasedir().toPath().resolve("target");
    }

    public void stop() {
        this.stopRequested.set(true);
    }

    public boolean isAlive() {
        return !this.stopRequested.get();
    }

    @Override
    public void run() {
        block12: {
            try {
                Path rootPath = this.project.getBasedir().toPath();
                this.watchService = FileSystems.getDefault().newWatchService();
                rootPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.registerAllDirectories(rootPath);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (this.buildReloadTask != null && !this.buildReloadTask.isDone()) {
                            this.buildReloadTask.cancel(true);
                        }
                        this.executorService.shutdown();
                    }
                    catch (Exception ex) {
                        this.log.error((Throwable)ex);
                    }
                }));
                while (this.isAlive()) {
                    WatchKey key = this.watchService.poll(60L, TimeUnit.SECONDS);
                    if (key == null) continue;
                    ArrayList filteredEvents = new ArrayList();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed = (Path)event.context();
                        Path fullPath = ((Path)key.watchable()).resolve(changed);
                        if (fullPath.startsWith(this.buildPath)) continue;
                        filteredEvents.add(event);
                    }
                    if (!filteredEvents.isEmpty()) {
                        if (this.buildReloadTask != null && !this.buildReloadTask.isDone()) {
                            this.buildReloadTask.cancel(true);
                        }
                        boolean fileDeletedOrRenamed = false;
                        boolean resourceModified = false;
                        boolean testClassesModified = false;
                        boolean rebootRequired = false;
                        for (WatchEvent watchEvent : filteredEvents) {
                            WatchEvent.Kind kind = watchEvent.kind();
                            Path changed = (Path)watchEvent.context();
                            Path fullPath = ((Path)key.watchable()).resolve(changed);
                            this.log.debug((CharSequence)("Source modified: " + changed + " - " + kind));
                            Path projectRoot = Paths.get(this.project.getBasedir().toURI());
                            Path sourceRoot = projectRoot.resolve("src");
                            Path mainDirectory = sourceRoot.resolve("main");
                            Path javaDirectory = mainDirectory.resolve("java");
                            Path resourcesDirectory = mainDirectory.resolve("resources");
                            Path testDirectory = sourceRoot.resolve("test");
                            this.sourceUpdatedPending.add(new Source(fullPath, kind, fullPath.startsWith(javaDirectory)));
                            if (fullPath.startsWith(resourcesDirectory)) {
                                resourceModified = true;
                            }
                            if (fullPath.startsWith(testDirectory)) {
                                testClassesModified = true;
                            }
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(fullPath, LinkOption.NOFOLLOW_LINKS)) {
                                this.register(fullPath);
                            }
                            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                fileDeletedOrRenamed = true;
                                this.cleanPending.set(true);
                            }
                            if (!this.start.getRebootOnChange().contains(changed.toString())) continue;
                            rebootRequired = true;
                            fileDeletedOrRenamed = true;
                            this.cleanPending.set(true);
                            break;
                        }
                        this.log.debug((CharSequence)("sourceUpdatedPending: " + this.sourceUpdatedPending));
                        if (!this.sourceUpdatedPending.isEmpty()) {
                            WebDriverFactory.updateTitle("Building", this.project, this.start.getDriver(), this.log);
                            this.log.info((CharSequence)("Auto-build started for " + this.project.getName()));
                            List<String> goalsList = this.updateGoalsList(fileDeletedOrRenamed, resourceModified, testClassesModified);
                            this.log.info((CharSequence)("goalsList: " + goalsList));
                            this.executeBuildReloadTask(goalsList, rebootRequired);
                        }
                    }
                    key.reset();
                }
            }
            catch (Exception ex) {
                this.log.error((Throwable)ex);
                if (!this.hasInotifyLimitReachedException(ex)) break block12;
                this.log.error((CharSequence)"Error starting WatchService. User limit of inotify instances reached or too many open files. Please increase the max_user_watches configuration.");
            }
        }
    }

    private boolean hasInotifyLimitReachedException(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException && ex.getMessage().contains("User limit of inotify instances reached")) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }

    private void registerAllDirectories(Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this::register);
    }

    private void register(Path path) {
        boolean isChild = path.startsWith(this.buildPath) && (path.equals(this.buildPath) || !this.buildPath.relativize(path).equals(path));
        try {
            if (!isChild) {
                this.log.debug((CharSequence)("register watch service for " + path));
                path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }
        catch (IOException ex) {
            this.log.error((CharSequence)"Error registering directories", (Throwable)ex);
        }
    }

    private List<String> updateGoalsList(boolean fileDeletedOrRenamed, boolean resourceModified, boolean testClassesModified) {
        boolean onlyJavaFilesUpdated = this.sourceUpdatedPending.stream().allMatch(k -> k.path.toString().endsWith(".java") && k.kind == StandardWatchEventKinds.ENTRY_MODIFY && k.javaClass);
        ArrayList<String> goalsList = new ArrayList<String>();
        if (fileDeletedOrRenamed || this.cleanPending.get() || this.sourceUpdatedPending.size() > 1) {
            goalsList.add(0, "clean");
            goalsList.add("resources:resources");
            resourceModified = true;
        } else if (resourceModified) {
            goalsList.add("resources:resources");
        }
        goalsList.add("org.apache.maven.plugins:maven-compiler-plugin:3.12.1:compile");
        if (onlyJavaFilesUpdated) {
            goalsList.add("-Dmaven.compiler.useIncrementalCompilation=false");
        }
        if (resourceModified || !onlyJavaFilesUpdated) {
            goalsList.add("war:exploded");
        } else {
            Path outputDirectory = Paths.get(this.webappDirectory.toPath().toString(), "WEB-INF", "classes");
            goalsList.add("-Dmaven.compiler.outputDirectory=\"" + outputDirectory.toString() + "\"");
        }
        if (!testClassesModified) {
            goalsList.add("-Dmaven.test.skip=true");
        } else {
            goalsList.add("-DskipTests");
        }
        return goalsList;
    }

    private void executeBuildReloadTask(List<String> goalsList, boolean rebootRequired) {
        this.buildReloadTask = this.executorService.submit(() -> {
            block14: {
                if (((String)goalsList.get(0)).equals("clean")) {
                    this.deleteBuildDir(this.project.getBuild().getDirectory());
                    goalsList.remove(0);
                }
                DefaultInvocationRequest request = new DefaultInvocationRequest();
                request.setPomFile(new File(this.project.getBasedir(), "pom.xml"));
                request.setGoals(goalsList);
                this.log.debug((CharSequence)("Maven goals: " + goalsList));
                System.setProperty("maven.multiModuleProjectDirectory", this.project.getBasedir().toString());
                DefaultInvoker invoker = new DefaultInvoker();
                invoker.setLogger((InvokerLogger)new InvokerLoggerImpl(this.log));
                invoker.setInputStream(InputStream.nullInputStream());
                try {
                    InvocationResult result = invoker.execute((InvocationRequest)request);
                    if (result.getExitCode() != 0) {
                        if (!this.buildReloadTask.isCancelled()) {
                            this.log.info((CharSequence)("Auto-build failed with exit code: " + result.getExitCode()));
                            WebDriverFactory.updateTitle("Build failed", this.project, this.start.getDriver(), this.log);
                        }
                        break block14;
                    }
                    this.log.info((CharSequence)("Auto-build successful for " + this.project.getName()));
                    this.cleanPending.set(false);
                    this.sourceUpdatedPending.clear();
                    if (rebootRequired) {
                        if (this.start.getMicroProcess().isAlive()) {
                            WebDriverFactory.updateTitle("Restarting", this.project, this.start.getDriver(), this.log);
                            this.start.getMicroProcess().destroy();
                        }
                    } else {
                        WebDriverFactory.updateTitle(RELOADING, this.project, this.start.getDriver(), this.log);
                        ReloadMojo reloadMojo = new ReloadMojo(this.project, this.log);
                        reloadMojo.setDevMode(true);
                        if (this.start.contextRoot != null) {
                            reloadMojo.setContextRoot(this.start.contextRoot);
                        }
                        reloadMojo.setKeepState(this.start.keepState);
                        if (this.start.hotDeploy) {
                            Path rootPath = this.project.getBasedir().toPath();
                            ArrayList<String> sourcesChanged = new ArrayList<String>();
                            reloadMojo.setHotDeploy(this.start.hotDeploy);
                            for (Source source : this.sourceUpdatedPending) {
                                String extension = source.path.toString().substring(source.path.toString().lastIndexOf(46) + 1);
                                if (extension.equals("xml") || extension.equals("properties")) {
                                    reloadMojo.setMetadataChanged(true);
                                }
                                Path relativePath = rootPath.relativize(source.path);
                                sourcesChanged.add(relativePath.toString().replace(File.separator, "/"));
                            }
                            this.log.debug((CharSequence)("SourcesChanged: " + sourcesChanged));
                            reloadMojo.setSourcesChanged(String.join((CharSequence)", ", sourcesChanged));
                        }
                        try {
                            reloadMojo.execute();
                        }
                        catch (MojoExecutionException ex) {
                            this.log.error((CharSequence)"Error invoking Reload", (Throwable)ex);
                        }
                    }
                    this.cleanPending.set(false);
                    this.sourceUpdatedPending.clear();
                }
                catch (MavenInvocationException ex) {
                    this.log.error((CharSequence)"Error invoking Maven", (Throwable)ex);
                }
            }
        });
    }

    public void deleteBuildDir(String filePath) {
        try {
            Path fileToDelete = Paths.get(filePath, new String[0]);
            Files.walkFileTree(fileToDelete, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new DeleteFileVisitor());
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
        }
    }

    class DeleteFileVisitor
    extends SimpleFileVisitor<Path> {
        DeleteFileVisitor() {
        }

        private boolean hasJarExtension(Path file) {
            return file.getFileName().toString().toLowerCase().endsWith(".jar");
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                if (this.hasJarExtension(path)) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        AutoDeployHandler.this.log.error((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            try {
                Files.delete(file);
            }
            catch (NoSuchFileException e) {
                AutoDeployHandler.this.log.debug((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
            }
            catch (IOException e) {
                AutoDeployHandler.this.log.error((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            try {
                Files.delete(dir);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
            }
            catch (IOException e) {
                AutoDeployHandler.this.log.error((CharSequence)"Error occurred while deleting the directory: ", (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

