/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogUtils {
    private static final String WARNING_LEVEL = "WARNING";
    private static final String SEVERE_LEVEL = "SEVERE";
    private static final String LOG_REGEX = "\\[([^\\[\\]]*)\\].*(\\[.*(INFO|WARNING|SEVERE).*\\]).*\\[levelValue\\: \\d+\\](.*)";
    private static final String WHITE_COLOR_CODE = "\u001b[97m[";
    private static final String YELLOW_COLOR_CODE = "\u001b[93m[";
    private static final String RED_COLOR_CODE = "\u001b[91m[";
    private static final String RESET_COLOR_CODE = "]\u001b[0m ";

    public static String trimLog(String line) {
        Pattern pattern = Pattern.compile(LOG_REGEX);
        Matcher matcher = pattern.matcher(line);
        boolean find = matcher.find();
        if (find) {
            String timeStamp = matcher.group(1).trim();
            String level = matcher.group(3).trim();
            String content = matcher.group(4).trim();
            switch (level) {
                case "WARNING": {
                    return LogUtils.warning(LogUtils.getTimestamp(timeStamp) + " ", content);
                }
                case "SEVERE": {
                    return LogUtils.severe(LogUtils.getTimestamp(timeStamp) + " ", content);
                }
            }
            return LogUtils.getTimestamp(timeStamp) + " " + content;
        }
        return line;
    }

    public static String highlight(String text) {
        int leadingSpaces;
        for (leadingSpaces = 0; leadingSpaces < text.length() && Character.isWhitespace(text.charAt(leadingSpaces)); ++leadingSpaces) {
        }
        String highlightedText = "\u001b[44m\u001b[97m" + text.substring(leadingSpaces) + "\u001b[0m";
        return " ".repeat(leadingSpaces) + highlightedText;
    }

    private static String warning(String timeStamp, String line) {
        return timeStamp + YELLOW_COLOR_CODE + WARNING_LEVEL + RESET_COLOR_CODE + line;
    }

    private static String severe(String timeStamp, String line) {
        return timeStamp + RED_COLOR_CODE + SEVERE_LEVEL + RESET_COLOR_CODE + line;
    }

    private static String getTimestamp(String timestampString) {
        int timeStartIndex = timestampString.indexOf(84) + 1;
        int offsetSignIndex = timestampString.indexOf(43, timeStartIndex);
        if (offsetSignIndex == -1) {
            offsetSignIndex = timestampString.indexOf(45, timeStartIndex);
        }
        String timeString = timestampString.substring(timeStartIndex, offsetSignIndex);
        return WHITE_COLOR_CODE + timeString + RESET_COLOR_CODE;
    }
}

