/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.AutoDeployHandler;
import fish.payara.maven.plugins.Source;
import fish.payara.maven.plugins.StartTask;
import fish.payara.maven.plugins.WebDriverFactory;
import fish.payara.maven.plugins.micro.ReloadMojo;
import fish.payara.maven.plugins.micro.StartMojo;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.openqa.selenium.WebDriver;

public class MicroAutoDeployHandler
extends AutoDeployHandler {
    private final StartMojo start;

    public MicroAutoDeployHandler(StartMojo start, File webappDirectory) {
        super((StartTask)start, webappDirectory);
        this.start = start;
    }

    public void reload(boolean rebootRequired) {
        if (rebootRequired) {
            if (this.start.getMicroProcess().isAlive()) {
                WebDriverFactory.updateTitle((String)"Restarting", (MavenProject)this.project, (WebDriver)this.start.getDriver(), (Log)this.log);
                this.start.getMicroProcess().destroy();
            }
        } else {
            WebDriverFactory.updateTitle((String)"Reloading", (MavenProject)this.project, (WebDriver)this.start.getDriver(), (Log)this.log);
            ReloadMojo reloadMojo = new ReloadMojo(this.project, this.log);
            reloadMojo.setDevMode(true);
            if (this.start.contextRoot != null) {
                reloadMojo.setContextRoot(this.start.contextRoot);
            }
            reloadMojo.setKeepState(this.start.keepState);
            if (this.start.hotDeploy) {
                Path rootPath = this.project.getBasedir().toPath();
                ArrayList<String> sourcesChanged = new ArrayList<String>();
                reloadMojo.setHotDeploy(this.start.hotDeploy);
                for (Source source : this.sourceUpdatedPending) {
                    String extension = source.getPath().toString().substring(source.getPath().toString().lastIndexOf(46) + 1);
                    if (extension.equals("xml") || extension.equals("properties")) {
                        reloadMojo.setMetadataChanged(true);
                    }
                    Path relativePath = rootPath.relativize(source.getPath());
                    sourcesChanged.add(relativePath.toString().replace(File.separator, "/"));
                }
                this.log.debug((CharSequence)("SourcesChanged: " + sourcesChanged));
                reloadMojo.setSourcesChanged(String.join((CharSequence)", ", sourcesChanged));
            }
            try {
                reloadMojo.execute();
            }
            catch (MojoExecutionException ex) {
                this.log.error((CharSequence)"Error invoking Reload", (Throwable)ex);
            }
        }
    }
}

