/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="reload")
public class ReloadMojo
extends BasePayaraMojo {
    private static final String RELOAD_FILE = ".reload";
    @Parameter(property="hotDeploy")
    private boolean hotDeploy;
    @Parameter(property="sourcesChanged")
    private String sourcesChanged;
    @Parameter(property="metadataChanged")
    private boolean metadataChanged;
    @Parameter(property="keepState", defaultValue="false")
    protected boolean keepState;
    @Parameter(property="devMode", defaultValue="false")
    protected boolean devMode;
    @Parameter(property="contextRoot")
    protected String contextRoot;

    public ReloadMojo(MavenProject mavenProject, Log log) {
        this.mavenProject = mavenProject;
        this.setLog(log);
    }

    public void execute() throws MojoExecutionException {
        block22: {
            if (this.skip) {
                this.getLog().info((CharSequence)"Reload mojo execution is skipped");
                return;
            }
            Build build = this.mavenProject.getBuild();
            String finalName = StringUtils.isNotEmpty((String)build.getFinalName()) ? build.getFinalName() : this.mavenProject.getArtifact().getArtifactId() + '-' + this.mavenProject.getVersion();
            String explodedDirPath = build.getDirectory() + File.separator + finalName;
            File explodedDir = new File(explodedDirPath);
            if (!explodedDir.exists()) {
                throw new MojoExecutionException(String.format("explodedDir[%s] not found", explodedDirPath));
            }
            File reloadFile = new File(explodedDir, RELOAD_FILE);
            this.getLog().info((CharSequence)("Reloading " + explodedDir));
            if (this.hotDeploy || this.keepState || this.devMode) {
                Properties props = new Properties();
                if (this.devMode) {
                    props.setProperty("devMode", Boolean.TRUE.toString());
                }
                if (this.contextRoot != null) {
                    props.setProperty("contextroot", this.contextRoot);
                }
                if (this.keepState) {
                    props.setProperty("keepState", Boolean.TRUE.toString());
                }
                if (this.hotDeploy) {
                    props.setProperty("hotdeploy", Boolean.TRUE.toString());
                    if (this.metadataChanged) {
                        props.setProperty("metadatachanged", Boolean.TRUE.toString());
                    }
                    if (this.sourcesChanged != null && !this.sourcesChanged.isEmpty()) {
                        props.setProperty("sourceschanged", this.sourcesChanged);
                    }
                }
                try (FileOutputStream outputStrem = new FileOutputStream(reloadFile);){
                    props.store(outputStrem, null);
                    break block22;
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Unable to save .reload file " + ex.toString());
                }
            }
            if (reloadFile.exists()) {
                try {
                    PrintWriter pw = new PrintWriter(reloadFile);
                    pw.close();
                }
                catch (FileNotFoundException ex) {
                    throw new MojoExecutionException("Unable to find .reload file " + ex.toString());
                }
                reloadFile.setLastModified(System.currentTimeMillis());
            } else {
                try {
                    reloadFile.createNewFile();
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Unable to create .reload file " + ex.toString());
                }
            }
        }
    }

    public boolean isHotDeploy() {
        return this.hotDeploy;
    }

    public void setHotDeploy(boolean hotDeploy) {
        this.hotDeploy = hotDeploy;
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getSourcesChanged() {
        return this.sourcesChanged;
    }

    public void setSourcesChanged(String sourcesChanged) {
        this.sourcesChanged = sourcesChanged;
    }

    public boolean isMetadataChanged() {
        return this.metadataChanged;
    }

    public void setMetadataChanged(boolean metadataChanged) {
        this.metadataChanged = metadataChanged;
    }
}

