/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.AutoDeployHandler;
import fish.payara.maven.plugins.PropertiesUtils;
import fish.payara.maven.plugins.StartTask;
import fish.payara.maven.plugins.WebDriverFactory;
import fish.payara.maven.plugins.micro.BasePayaraMojo;
import fish.payara.maven.plugins.micro.LogUtils;
import fish.payara.maven.plugins.micro.MicroAutoDeployHandler;
import fish.payara.maven.plugins.micro.Option;
import fish.payara.maven.plugins.micro.processor.MicroFetchProcessor;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.openqa.selenium.WebDriver;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="start")
public class StartMojo
extends BasePayaraMojo
implements StartTask {
    private static final String ERROR_MESSAGE = "Errors occurred while executing payara-micro.";
    private static final String PRE_BOOT = "--prebootcommandfile";
    private static final String POST_BOOT = "--postbootcommandfile";
    private static final String POST_DEPLOY = "--postdeploycommandfile";
    @Parameter(property="javaPath")
    private String javaPath;
    @Parameter(property="payaraVersion", defaultValue="6.2024.3")
    private String payaraVersion;
    @Parameter(property="payaraMicroAbsolutePath")
    private String payaraMicroAbsolutePath;
    @Parameter(property="daemon", defaultValue="false")
    private boolean daemon;
    @Parameter(property="immediateExit", defaultValue="false")
    private boolean immediateExit;
    @Parameter(property="artifactItem")
    private ArtifactItem artifactItem;
    @Parameter(property="useUberJar", defaultValue="false")
    private boolean useUberJar;
    @Parameter(property="deployWar", defaultValue="false")
    protected boolean deployWar;
    @Parameter(property="exploded", defaultValue="false")
    protected boolean exploded;
    @Parameter(property="autoDeploy")
    protected Boolean autoDeploy;
    @Parameter(property="keepState")
    protected Boolean keepState;
    @Parameter(property="liveReload")
    protected Boolean liveReload;
    @Parameter(property="browser")
    protected String browser;
    @Parameter(property="trimLog")
    protected Boolean trimLog;
    @Parameter(property="debug", defaultValue="false")
    protected String debug;
    @Parameter(property="contextRoot")
    protected String contextRoot;
    @Parameter(property="hotDeploy")
    protected boolean hotDeploy;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    protected File webappDirectory;
    @Parameter(property="netbeans.deploy.clientUrlPart")
    private String clientUrlPart;
    @Deprecated
    @Parameter(property="copySystemProperties", defaultValue="false")
    private boolean copySystemProperties;
    @Parameter(property="commandLineOptions")
    protected List<Option> commandLineOptions;
    @Parameter(property="javaCommandLineOptions")
    private List<Option> javaCommandLineOptions;
    @Parameter(property="classpathArtifactItems")
    private List<ArtifactItem> classpathArtifactItems;
    private Process microProcess;
    private Thread microProcessorThread;
    private final ThreadGroup threadGroup;
    private Toolchain toolchain;
    private AutoDeployHandler autoDeployHandler;
    private final List<String> rebootOnChange = new ArrayList<String>();
    private WebDriver driver;
    private String payaraMicroURL;
    private String hostIp;
    private String hostPort;
    private final Map<String, String> contextRoots = new HashMap<String, String>();

    StartMojo() {
        this.threadGroup = new ThreadGroup("PayaraMicroThread");
    }

    public void execute() throws MojoExecutionException {
        if (this.trimLog == null) {
            this.trimLog = false;
        }
        if (this.autoDeploy == null) {
            this.autoDeploy = false;
        }
        if (this.liveReload == null) {
            this.liveReload = false;
        }
        if (this.keepState == null) {
            this.keepState = false;
        }
        if (this.autoDeploy.booleanValue() && this.autoDeployHandler == null) {
            this.autoDeployHandler = new MicroAutoDeployHandler(this, this.webappDirectory);
            Thread devModeThread = new Thread((Runnable)this.autoDeployHandler);
            devModeThread.setDaemon(true);
            devModeThread.start();
        } else {
            this.autoDeployHandler = null;
        }
        if (this.copySystemProperties) {
            this.getLog().warn((CharSequence)"copySystemProperties is deprecated. System properties of the regarding maven execution will be passed to the payara-micro automatically.");
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Start mojo execution is skipped");
            return;
        }
        this.toolchain = this.getToolchain();
        String path = this.decideOnWhichMicroToUse();
        this.microProcessorThread = new Thread(this.threadGroup, () -> {
            String execArgs;
            ArrayList<String> actualArgs = new ArrayList<String>();
            this.getLog().info((CharSequence)("Starting payara-micro from path: " + path));
            int indice = 0;
            actualArgs.add(indice++, this.evaluateJavaPath());
            if (this.debug != null && !this.debug.equalsIgnoreCase("false")) {
                if (Boolean.parseBoolean(this.debug)) {
                    actualArgs.add(indice++, "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
                } else {
                    actualArgs.add(indice++, this.debug);
                }
            }
            if (this.javaCommandLineOptions != null) {
                for (Option option : this.javaCommandLineOptions) {
                    if (option.getKey() != null && option.getValue() != null) {
                        String systemProperty = String.format("%s=%s", option.getKey(), option.getValue());
                        actualArgs.add(indice++, systemProperty);
                        continue;
                    }
                    if (option.getValue() == null) continue;
                    actualArgs.add(indice++, option.getValue());
                }
            }
            if ((execArgs = this.mavenSession.getRequest().getUserProperties().getProperty("exec.args")) != null && !execArgs.trim().isEmpty()) {
                for (String execArg : execArgs.split("\\s+")) {
                    actualArgs.add(indice++, execArg);
                }
            }
            actualArgs.add(indice++, "-Dgav=" + this.getProjectGAV());
            if (this.classpathArtifactItems != null && !this.classpathArtifactItems.isEmpty()) {
                actualArgs.add(indice++, "-cp");
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ArtifactItem classpathArtifactItem : this.classpathArtifactItems) {
                    DefaultArtifact artifact = new DefaultArtifact(classpathArtifactItem.getGroupId(), classpathArtifactItem.getArtifactId(), classpathArtifactItem.getVersion(), null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
                    arrayList.add(this.findLocalPathOfArtifact(artifact));
                }
                arrayList.add(path);
                actualArgs.add(indice++, StringUtils.join(arrayList, (String)File.pathSeparator));
                actualArgs.add(indice++, "fish.payara.micro.PayaraMicro");
            } else {
                actualArgs.add(indice++, "-jar");
                actualArgs.add(indice++, path);
            }
            if (this.deployWar && "war".equalsIgnoreCase(this.mavenProject.getPackaging())) {
                if (this.useUberJar) {
                    this.getLog().warn((CharSequence)"useUberJar and deployWar are both set to true! You'll probably have your application tried to deploy twice: 1. as uber jar 2. as a separate war");
                }
                actualArgs.add(indice++, "--deploy");
                if (this.exploded) {
                    actualArgs.add(indice++, this.evaluateProjectArtifactAbsolutePath(""));
                } else {
                    actualArgs.add(indice++, this.evaluateProjectArtifactAbsolutePath("." + this.mavenProject.getPackaging()));
                }
            }
            if (this.clientUrlPart != null && !this.clientUrlPart.trim().isEmpty()) {
                actualArgs.add(indice++, "--contextroot");
                actualArgs.add(indice++, this.clientUrlPart.trim());
            } else if (this.contextRoot != null) {
                actualArgs.add(indice++, "--contextroot");
                actualArgs.add(indice++, this.contextRoot);
            }
            if (this.hotDeploy) {
                actualArgs.add(indice++, "--hotdeploy");
            }
            if (this.commandLineOptions != null) {
                for (Option option : this.commandLineOptions) {
                    if (option.getKey() != null) {
                        Path bootpath;
                        actualArgs.add(indice++, option.getKey());
                        if (this.autoDeploy.booleanValue() && option.getValue() != null && !option.getValue().isEmpty() && (option.getKey().equals(PRE_BOOT) || option.getKey().equals(POST_BOOT) || option.getKey().equals(POST_DEPLOY)) && Files.exists(bootpath = Paths.get(option.getValue(), new String[0]), new LinkOption[0])) {
                            this.rebootOnChange.add(bootpath.getFileName().toString());
                        }
                    }
                    if (option.getValue() == null) continue;
                    actualArgs.add(indice++, option.getValue());
                }
            }
            try {
                this.getLog().info((CharSequence)("Starting Payara Micro with the these arguments: " + actualArgs));
                Runtime runtime = Runtime.getRuntime();
                this.microProcess = runtime.exec(actualArgs.toArray(new String[0]));
                if (this.daemon) {
                    this.redirectStream(this.microProcess.getInputStream(), System.out);
                    this.redirectStream(this.microProcess.getErrorStream(), System.err);
                } else {
                    this.redirectStreamToGivenOutputStream(this.microProcess.getInputStream(), System.out);
                    this.redirectStreamToGivenOutputStream(this.microProcess.getErrorStream(), System.err);
                }
                int exitCode = this.microProcess.waitFor();
                if (exitCode != 0 && !this.autoDeploy.booleanValue()) {
                    throw new MojoFailureException(ERROR_MESSAGE);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new RuntimeException(ERROR_MESSAGE, exception);
            }
            finally {
                if (!this.daemon) {
                    this.closeMicroProcess();
                }
            }
        });
        if (this.daemon) {
            this.microProcessorThread.setDaemon(true);
            this.microProcessorThread.start();
            if (!this.immediateExit) {
                try {
                    this.microProcessorThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Runtime.getRuntime().addShutdownHook(this.getShutdownHook());
            this.microProcessorThread.run();
            if (this.autoDeploy.booleanValue()) {
                while (this.autoDeployHandler.isAlive()) {
                    this.microProcessorThread.run();
                }
            }
        }
    }

    private Thread getShutdownHook() {
        return new Thread(this.threadGroup, () -> {
            if (this.microProcess != null && this.microProcess.isAlive()) {
                try {
                    this.microProcess.destroy();
                    this.microProcess.waitFor(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.microProcess.destroyForcibly();
                }
            }
            if (this.autoDeployHandler != null) {
                this.autoDeployHandler.stop();
            }
            if (this.driver != null) {
                try {
                    PropertiesUtils.saveProperties((String)this.payaraMicroURL, (String)this.driver.getCurrentUrl());
                }
                catch (Throwable t) {
                    this.getLog().debug(t);
                }
                finally {
                    try {
                        this.driver.quit();
                    }
                    catch (Throwable t) {
                        this.getLog().debug(t);
                    }
                }
            }
        });
    }

    private String evaluateJavaPath() {
        String javaToUse = "java";
        if (StringUtils.isNotEmpty((String)this.javaPath)) {
            javaToUse = this.javaPath;
        } else if (this.toolchain != null) {
            javaToUse = this.toolchain.findTool("java");
        }
        return javaToUse;
    }

    private String decideOnWhichMicroToUse() throws MojoExecutionException {
        if (this.useUberJar) {
            String path = this.evaluateProjectArtifactAbsolutePath("-" + this.uberJarClassifier + "." + "jar");
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                throw new MojoExecutionException("\"useUberJar\" option was set to \"true\" but detected path " + path + " does not exist. You need to execute the \"bundle\" goal before using this option.");
            }
            return path;
        }
        if (this.payaraMicroAbsolutePath != null) {
            return this.payaraMicroAbsolutePath;
        }
        if (this.artifactItem.getGroupId() != null) {
            DefaultArtifact artifact = new DefaultArtifact(this.artifactItem.getGroupId(), this.artifactItem.getArtifactId(), this.artifactItem.getVersion(), null, this.artifactItem.getType(), this.artifactItem.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
            return this.findLocalPathOfArtifact(artifact);
        }
        if (this.payaraVersion != null) {
            MojoExecutor.ExecutionEnvironment environment = this.getEnvironment();
            MicroFetchProcessor microFetchProcessor = new MicroFetchProcessor();
            microFetchProcessor.set(this.payaraVersion).handle(environment);
            DefaultArtifact artifact = new DefaultArtifact("fish.payara.extras", "payara-micro", this.payaraVersion, null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
            return this.findLocalPathOfArtifact(artifact);
        }
        throw new MojoExecutionException("Could not determine Payara Micro path. Please set it by defining either \"useUberJar\", \"payaraMicroAbsolutePath\" or \"artifactItem\" configuration options.");
    }

    private String findLocalPathOfArtifact(DefaultArtifact artifact) {
        Artifact payaraMicroArtifact = this.mavenSession.getLocalRepository().find((Artifact)artifact);
        return payaraMicroArtifact.getFile().getAbsolutePath();
    }

    protected String getBaseDir() {
        return this.mavenProject.getBuild().getDirectory();
    }

    private String evaluateProjectArtifactAbsolutePath(String extension) {
        String projectJarAbsolutePath = this.getBaseDir() + File.separator;
        projectJarAbsolutePath = projectJarAbsolutePath + this.evaluateExecutorName(extension);
        return projectJarAbsolutePath;
    }

    private String evaluateExecutorName(String extension) {
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifactId() + '-' + this.mavenProject.getVersion() + extension;
    }

    void closeMicroProcess() {
        if (this.microProcess != null) {
            try {
                this.microProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.microProcess.destroy();
                this.getLog().info((CharSequence)"Terminated payara-micro.");
            }
        }
    }

    Process getMicroProcess() {
        return this.microProcess;
    }

    private void redirectStream(InputStream inputStream, PrintStream printStream) {
        Thread thread = new Thread(this.threadGroup, () -> {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    printStream.println(line);
                    if (this.immediateExit || !sb.toString().contains("ready in")) continue;
                    this.microProcessorThread.interrupt();
                    br.close();
                    break;
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void redirectStreamToGivenOutputStream(InputStream inputStream, OutputStream outputStream) {
        Thread thread = new Thread(this.threadGroup, () -> {
            try {
                if (this.liveReload.booleanValue() && outputStream instanceof PrintStream) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                    PrintStream printStream = (PrintStream)outputStream;
                    while ((line = br.readLine()) != null) {
                        printStream.println(this.trimLog != false ? LogUtils.trimLog(line) : line);
                        if (this.hostIp == null && line.endsWith(" \"Instance Configuration\": {")) {
                            this.parseInstanceConfig(br, printStream);
                            continue;
                        }
                        if (this.payaraMicroURL == null && line.contains("Payara Micro URLs:")) {
                            this.parseMicroUrl(br, printStream);
                            continue;
                        }
                        if (line.contains("Exception while loading the app")) {
                            WebDriverFactory.updateTitle((String)"Failed reloading", (MavenProject)this.getEnvironment().getMavenProject(), (WebDriver)this.driver, (Log)this.getLog());
                            continue;
                        }
                        if (this.payaraMicroURL != null && this.payaraMicroURL.isEmpty() && this.driver == null && line.contains("Loading application")) {
                            this.parseContextRoot(line);
                            continue;
                        }
                        if (this.payaraMicroURL != null && this.payaraMicroURL.isEmpty() && this.driver == null && line.contains("was successfully deployed")) {
                            String appName = this.parseDeployedApp(line);
                            if (this.contextRoot == null) {
                                this.contextRoot = this.contextRoots.get(appName);
                            }
                            this.openApp();
                            continue;
                        }
                        if (this.payaraMicroURL != null && !this.payaraMicroURL.isEmpty() && this.driver != null && line.contains("was successfully deployed")) {
                            try {
                                this.driver.navigate().refresh();
                            }
                            catch (Exception ex) {
                                this.getLog().debug((CharSequence)"Error in refreshing with WebDriver", (Throwable)ex);
                            }
                            continue;
                        }
                        if (!this.autoDeploy.booleanValue() || !line.contains("User limit of inotify instances reached")) continue;
                        this.getLog().error((CharSequence)"Error starting WatchService. User limit of inotify instances reached or too many open files. Please increase the max_user_watches configuration.");
                    }
                } else {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error occurred while reading stream", (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void openApp() {
        try {
            this.driver = WebDriverFactory.createWebDriver((String)this.browser, (Log)this.getLog());
            String url = PropertiesUtils.getProperty((String)this.payaraMicroURL, (String)this.payaraMicroURL);
            if ((url == null || url.isEmpty()) && this.hostIp != null && this.hostPort != null) {
                url = "http://" + this.hostIp + ":" + this.hostPort;
                if (this.contextRoot != null) {
                    url = url + this.contextRoot;
                }
                this.payaraMicroURL = url;
            }
            this.driver.get(url);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Error in running WebDriver", (Throwable)ex);
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(this.payaraMicroURL));
                }
            }
            catch (IOException | URISyntaxException e) {
                this.getLog().error((CharSequence)"Error in running Desktop browse", (Throwable)e);
            }
            finally {
                this.driver = null;
            }
        }
    }

    private void parseInstanceConfig(BufferedReader br, PrintStream printStream) throws IOException {
        Pattern portRegex;
        Matcher portMatcher;
        String hostIpLine = br.readLine();
        String hostPortLine = br.readLine();
        printStream.println(LogUtils.highlight(hostIpLine));
        printStream.println(LogUtils.highlight(hostPortLine));
        Pattern ipRegex = Pattern.compile("\"Host\": \"([^\"]+)\"");
        Matcher ipMatcher = ipRegex.matcher(hostIpLine);
        if (ipMatcher.find()) {
            this.hostIp = ipMatcher.group(1);
        }
        if ((portMatcher = (portRegex = Pattern.compile("\"Http Port\\(s\\)\": \"([^\"]+)\"")).matcher(hostPortLine)).find()) {
            this.hostPort = portMatcher.group(1);
        }
    }

    private void parseMicroUrl(BufferedReader br, PrintStream printStream) throws IOException {
        String line = br.readLine();
        if (line != null) {
            this.payaraMicroURL = line.trim();
            printStream.println(LogUtils.highlight(this.payaraMicroURL));
            if (!this.payaraMicroURL.isEmpty()) {
                this.openApp();
            }
        }
    }

    private void parseContextRoot(String line) {
        Pattern appLoadingPattern = Pattern.compile("Loading application \\[([^\\]]+)\\] at \\[([^\\]]+)\\]");
        Matcher appLoadingMatcher = appLoadingPattern.matcher(line);
        if (appLoadingMatcher.find()) {
            String applicationName = appLoadingMatcher.group(1);
            String appContextRoot = appLoadingMatcher.group(2);
            this.contextRoots.put(applicationName, appContextRoot);
        }
    }

    private String parseDeployedApp(String line) {
        Pattern deploymentPatternO = Pattern.compile("([^ ]+) was successfully deployed in ([^ ]+) milliseconds.");
        Matcher deploymentMatcher = deploymentPatternO.matcher(line);
        if (deploymentMatcher.find()) {
            String applicationName = deploymentMatcher.group(1);
            return applicationName;
        }
        return null;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public MavenProject getProject() {
        return this.getEnvironment().getMavenProject();
    }

    public List<String> getRebootOnChange() {
        return this.rebootOnChange;
    }

    public boolean isLocal() {
        return this.exploded;
    }
}

