/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server;

import fish.payara.maven.plugins.AutoDeployHandler;
import fish.payara.maven.plugins.LogUtils;
import fish.payara.maven.plugins.PropertiesUtils;
import fish.payara.maven.plugins.StartTask;
import fish.payara.maven.plugins.WebDriverFactory;
import fish.payara.maven.plugins.server.Option;
import fish.payara.maven.plugins.server.ServerAutoDeployHandler;
import fish.payara.maven.plugins.server.ServerFetchProcessor;
import fish.payara.maven.plugins.server.ServerMojo;
import fish.payara.maven.plugins.server.manager.InstanceManager;
import fish.payara.maven.plugins.server.manager.LocalInstanceManager;
import fish.payara.maven.plugins.server.manager.PayaraServerInstance;
import fish.payara.maven.plugins.server.manager.PayaraServerLocalInstance;
import fish.payara.maven.plugins.server.manager.PayaraServerRemoteInstance;
import fish.payara.maven.plugins.server.manager.RemoteInstanceManager;
import fish.payara.maven.plugins.server.response.JsonResponse;
import fish.payara.maven.plugins.server.response.Response;
import fish.payara.maven.plugins.server.utils.TempDirectoryResolver;
import fish.payara.tools.ai.JMXFetchSpecificMBean;
import fish.payara.tools.ai.MarkdownToCmdHighlighter;
import fish.payara.tools.ai.PayaraAIAgent;
import fish.payara.tools.ai.lang.PreferencesManager;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriver;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="start")
public class StartMojo
extends ServerMojo
implements StartTask {
    private static final String ERROR_MESSAGE = "Errors occurred while executing payara-server.";
    private static final String REMOTE_INSTANCE_NOT_RUNNING_MESSAGE = "The remote Payara server instance is not running.";
    @Parameter(property="payara.daemon", defaultValue="${env.PAYARA_DAEMON}")
    private boolean daemon;
    @Parameter(property="payara.immediate.exit", defaultValue="${env.PAYARA_IMMEDIATE_EXIT}")
    private boolean immediateExit;
    @Parameter(property="payara.auto.deploy", defaultValue="${env.PAYARA_AUTO_DEPLOY}")
    protected Boolean autoDeploy;
    @Parameter(property="payara.keep.state", defaultValue="${env.PAYARA_KEEP_STATE}")
    protected Boolean keepState;
    @Parameter(property="payara.live.reload", defaultValue="${env.PAYARA_LIVE_RELOAD}")
    protected Boolean liveReload;
    @Parameter(property="payara.browser", defaultValue="${env.PAYARA_BROWSER}")
    protected String browser;
    @Parameter(property="payara.trim.log", defaultValue="${env.PAYARA_TRIM_LOG}")
    protected Boolean trimLog;
    @Parameter(property="payara.hot.deploy", defaultValue="${env.PAYARA_HOT_DEPLOY}")
    protected boolean hotDeploy;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    protected File webappDirectory;
    @Parameter(property="payara.debug", defaultValue="${env.PAYARA_DEBUG}")
    protected String debug;
    @Parameter(property="payara.debug.port", defaultValue="${env.PAYARA_DEBUG_PORT}")
    protected String debugPort;
    @Parameter(property="payara.ai.agent", defaultValue="${env.PAYARA_AI_AGENT}")
    protected Boolean aiAgent;
    @Parameter
    private List<Option> commandLineOptions;
    @Parameter(property="payara.commandLineOptions", defaultValue="${env.PAYARA_COMMANDLINE_OPTIONS}")
    private List<String> commandLineOptionsString;
    @Parameter
    private List<Option> javaCommandLineOptions;
    @Parameter(property="payara.javaCommandLineOptions", defaultValue="${env.PAYARA_JAVA_COMMANDLINE_OPTIONS}")
    private List<String> javaCommandLineOptionsString;
    @Parameter(property="payara.http.connection.timeout", defaultValue="${env.PAYARA_HTTP_CONNECTION_TIMEOUT}")
    public Integer httpConnectionTimeout;
    @Parameter(property="payara.http.read.timeout", defaultValue="${env.PAYARA_HTTP_READ_TIMEOUT}")
    public Integer httpReadTimeout;
    private Process serverProcess;
    private Thread serverProcessorThread;
    private final ThreadGroup threadGroup = new ThreadGroup("PayaraServerThread");
    private AutoDeployHandler autoDeployHandler;
    private WebDriver driver;
    private String applicationURL;
    private InstanceManager serverManager;
    private String appPath;
    private String projectName;
    private PayaraServerInstance instance;
    private PayaraAIAgent payaraAIAgent;
    private boolean monitoringEnabled;

    StartMojo() {
        if (this.debug == null || this.debug.isEmpty()) {
            this.debug = "false";
        }
        if (this.payaraServerVersion == null) {
            this.payaraServerVersion = "6.2025.6";
        }
        if (this.httpConnectionTimeout == null) {
            this.httpConnectionTimeout = 3000;
        }
        if (this.httpReadTimeout == null) {
            this.httpReadTimeout = 3000;
        }
    }

    public void execute() throws MojoExecutionException {
        String[] parts;
        Option option;
        if (this.trimLog == null) {
            this.trimLog = false;
        }
        if (this.autoDeploy == null) {
            this.autoDeploy = false;
        }
        if (this.liveReload == null) {
            this.liveReload = false;
        }
        if (this.keepState == null) {
            this.keepState = false;
        }
        if (this.aiAgent == null) {
            this.aiAgent = false;
        }
        if (this.autoDeploy.booleanValue() && this.autoDeployHandler == null) {
            this.autoDeployHandler = new ServerAutoDeployHandler(this, this.webappDirectory);
            Thread devModeThread = new Thread((Runnable)this.autoDeployHandler);
            devModeThread.setDaemon(true);
            devModeThread.start();
        } else {
            this.autoDeployHandler = null;
        }
        PreferencesManager pm = PreferencesManager.getInstance();
        if (this.aiAgent.booleanValue() && (pm.getApiKey() != null || pm.getProviderLocation() != null)) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.payaraAIAgent = new PayaraAIAgent();
                }
                catch (Exception ex) {
                    this.getLog().error((Throwable)ex);
                }
            });
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Start mojo execution is skipped");
            return;
        }
        if (this.commandLineOptionsString != null && !this.commandLineOptionsString.isEmpty()) {
            if (this.commandLineOptions == null) {
                this.commandLineOptions = new ArrayList<Option>();
            }
            for (String optStr : this.commandLineOptionsString) {
                option = new Option();
                if (optStr.contains("=")) {
                    parts = optStr.split("=", 2);
                    option.setKey(parts[0]);
                    option.setValue(parts[1]);
                } else {
                    option.setKey(optStr);
                    option.setValue(null);
                }
                this.commandLineOptions.add(option);
            }
        }
        if (this.javaCommandLineOptionsString != null && !this.javaCommandLineOptionsString.isEmpty()) {
            if (this.javaCommandLineOptions == null) {
                this.javaCommandLineOptions = new ArrayList<Option>();
            }
            for (String optStr : this.javaCommandLineOptionsString) {
                option = new Option();
                if (optStr.contains("=")) {
                    parts = optStr.split("=", 2);
                    option.setKey(parts[0]);
                    option.setValue(parts[1]);
                } else {
                    option.setKey(optStr);
                    option.setValue(null);
                }
                this.javaCommandLineOptions.add(option);
            }
        }
        this.serverProcessorThread = new Thread(this.threadGroup, () -> {
            if (this.remote) {
                this.instance = new PayaraServerRemoteInstance(this.hostName);
                this.instance.setAdminUser(this.adminUser);
                this.instance.setAdminPassword(this.getAdminPassword());
                if (this.adminPort != null) {
                    this.instance.setAdminPort(Integer.parseInt(this.adminPort));
                }
                if (this.httpPort != null) {
                    this.instance.setHttpPort(Integer.parseInt(this.httpPort));
                }
                if (this.httpsPort != null) {
                    this.instance.setHttpsPort(Integer.parseInt(this.httpsPort));
                }
                this.instance.setHttpConnectionTimeout(this.httpConnectionTimeout);
                this.instance.setHttpReadTimeout(this.httpReadTimeout);
                if (this.protocol != null) {
                    this.instance.setProtocol(this.protocol);
                }
                this.serverManager = new RemoteInstanceManager((PayaraServerRemoteInstance)this.instance, this.getLog());
                if (!this.serverManager.isServerAlreadyRunning()) throw new RuntimeException(REMOTE_INSTANCE_NOT_RUNNING_MESSAGE);
                Thread logThread = this.streamRemoteServerLog();
                this.appPath = this.evaluateProjectArtifactAbsolutePath("." + this.mavenProject.getPackaging());
                this.projectName = this.mavenProject.getName().replaceAll("\\s+", "");
                this.deployApplication();
                this.openApp();
                try {
                    logThread.join();
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return;
            }
            try {
                String path = this.decideOnWhichServerToUse();
                this.instance = new PayaraServerLocalInstance(this.javaHome, path, this.domainName);
                this.instance.setAdminUser(this.adminUser);
                this.instance.setAdminPassword(this.getAdminPassword());
                if (this.adminPort != null) {
                    this.instance.setAdminPort(Integer.parseInt(this.adminPort));
                }
                if (this.httpPort != null) {
                    this.instance.setHttpPort(Integer.parseInt(this.httpPort));
                }
                if (this.httpsPort != null) {
                    this.instance.setHttpsPort(Integer.parseInt(this.httpsPort));
                }
                this.instance.setHttpConnectionTimeout(this.httpConnectionTimeout);
                this.instance.setHttpReadTimeout(this.httpReadTimeout);
                if (this.protocol != null) {
                    this.instance.setProtocol(this.protocol);
                }
                this.serverManager = new LocalInstanceManager((PayaraServerLocalInstance)this.instance, this.getLog());
                if (!this.serverManager.isServerAlreadyRunning()) {
                    ProcessBuilder processBuilder = ((LocalInstanceManager)this.serverManager).startServer(this.debug, this.debugPort, this.javaCommandLineOptions, this.commandLineOptions);
                    this.getLog().info((CharSequence)("Starting Payara Server [" + path + "] with the these arguments: " + processBuilder.command()));
                    this.serverProcess = processBuilder.start();
                    if (this.daemon) {
                        this.redirectStream(this.serverProcess.getInputStream(), System.out);
                        this.redirectStream(this.serverProcess.getErrorStream(), System.err);
                    } else {
                        this.redirectStreamToGivenOutputStream(this.serverProcess.getInputStream(), System.out);
                        this.redirectStreamToGivenOutputStream(this.serverProcess.getErrorStream(), System.err);
                    }
                    this.serverManager.connectWithServer();
                } else {
                    this.streamLocalServerLog((PayaraServerLocalInstance)this.instance);
                }
                this.appPath = this.exploded ? this.evaluateProjectArtifactAbsolutePath("") : this.evaluateProjectArtifactAbsolutePath("." + this.mavenProject.getPackaging());
                this.projectName = this.mavenProject.getName().replaceAll("\\s+", "");
                this.deployApplication();
                this.openApp();
                this.watchAsadminCommand();
                int exitCode = this.serverProcess.waitFor();
                if (exitCode == 0) return;
                throw new MojoFailureException(ERROR_MESSAGE);
            }
            catch (InterruptedException path) {
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(ERROR_MESSAGE, e);
            }
            finally {
                if (!this.daemon) {
                    this.closeServerProcess();
                }
            }
        });
        if (this.daemon) {
            this.serverProcessorThread.setDaemon(true);
            this.serverProcessorThread.start();
            if (!this.immediateExit) {
                try {
                    this.serverProcessorThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Runtime.getRuntime().addShutdownHook(this.killServerProcess());
            this.serverProcessorThread.run();
            if (this.autoDeploy.booleanValue()) {
                while (this.autoDeployHandler.isAlive()) {
                    this.serverProcessorThread.run();
                }
            }
        }
    }

    public void deployApplication() {
        this.serverManager.undeployApplication(this.projectName, this.instanceName);
        URI appUri = this.serverManager.deployApplication(this.projectName, this.appPath, this.instanceName, this.contextRoot, this.exploded, this.hotDeploy);
        if (appUri != null) {
            this.applicationURL = appUri.toString();
        }
    }

    private Thread killServerProcess() {
        return new Thread(this.threadGroup, () -> {
            if (this.serverProcess != null && this.serverProcess.isAlive()) {
                try {
                    this.serverManager.undeployApplication(this.projectName, this.instanceName);
                    this.serverProcess.destroy();
                    this.serverProcess.waitFor(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.serverProcess.destroyForcibly();
                }
            }
            if (this.autoDeployHandler != null) {
                this.autoDeployHandler.stop();
            }
            if (this.driver != null) {
                try {
                    PropertiesUtils.saveProperties((String)this.applicationURL, (String)this.driver.getCurrentUrl());
                }
                catch (Throwable t) {
                    this.getLog().debug(t);
                }
                finally {
                    try {
                        this.driver.quit();
                    }
                    catch (Throwable t) {
                        this.getLog().debug(t);
                    }
                }
            }
        });
    }

    private String decideOnWhichServerToUse() throws MojoExecutionException {
        if (this.payaraServerPath != null) {
            return this.payaraServerPath;
        }
        if (this.artifactItem != null && this.artifactItem.getGroupId() != null && this.artifactItem.getArtifactId() != null) {
            DefaultArtifact artifact = new DefaultArtifact(this.artifactItem.getGroupId(), this.artifactItem.getArtifactId(), this.artifactItem.getVersion(), null, this.artifactItem.getType(), this.artifactItem.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("zip"));
            File targetDir = TempDirectoryResolver.resolvePayaraTempDir(this.payaraServerVersion);
            File extractedDir = new File(targetDir + File.separator + "payara" + this.artifactItem.getVersion().charAt(0));
            if (!extractedDir.exists()) {
                try {
                    this.getLog().info((CharSequence)("Extracting Payara Server to " + targetDir));
                    this.extractZipFile(this.findLocalPathOfArtifact(artifact), targetDir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to extract Payara Server zip file", (Exception)e);
                }
            }
            return extractedDir.getAbsolutePath();
        }
        if (this.payaraServerVersion != null) {
            File extractedDir;
            MojoExecutor.ExecutionEnvironment environment = this.getEnvironment();
            ServerFetchProcessor serverFetchProcessor = new ServerFetchProcessor();
            serverFetchProcessor.set(this.payaraServerVersion).handle(environment);
            DefaultArtifact artifact = new DefaultArtifact("fish.payara.distributions", "payara", this.payaraServerVersion, null, "zip", null, (ArtifactHandler)new DefaultArtifactHandler("zip"));
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            File targetDir = new File(tmpDir, "payara-server-" + this.payaraServerVersion);
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            if (!(extractedDir = new File(targetDir + File.separator + "payara" + this.payaraServerVersion.charAt(0))).exists()) {
                try {
                    this.getLog().info((CharSequence)("Extracting the Payara Server to " + targetDir));
                    this.extractZipFile(this.findLocalPathOfArtifact(artifact), targetDir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to extract Payara Server zip file", (Exception)e);
                }
            }
            return extractedDir.getAbsolutePath();
        }
        throw new MojoExecutionException("Could not determine Payara Server path. Please set it by defining either \"payaraServerPath\" or \"artifactItem\" configuration options.");
    }

    private String findLocalPathOfArtifact(DefaultArtifact artifact) {
        Artifact payaraServerArtifact = this.mavenSession.getLocalRepository().find((Artifact)artifact);
        return payaraServerArtifact.getFile().getAbsolutePath();
    }

    private void extractZipFile(String zipFilePath, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                File dirEntry = new File(destDir, entry.getName());
                if (!entry.isDirectory()) {
                    this.extractFile(zipIn, dirEntry);
                } else {
                    dirEntry.mkdirs();
                }
                zipIn.closeEntry();
            }
        }
    }

    private void extractFile(ZipInputStream zipIn, File filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = zipIn.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
    }

    protected String getBaseDir() {
        return this.mavenProject.getBuild().getDirectory();
    }

    private String evaluateProjectArtifactAbsolutePath(String extension) {
        String projectJarAbsolutePath = this.getBaseDir() + File.separator;
        projectJarAbsolutePath = projectJarAbsolutePath + this.evaluateExecutorName(extension);
        return projectJarAbsolutePath;
    }

    private String evaluateExecutorName(String extension) {
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifactId() + "-" + this.mavenProject.getVersion() + extension;
    }

    void closeServerProcess() {
        if (this.serverProcess != null) {
            try {
                this.serverProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.serverProcess.destroy();
                this.getLog().info((CharSequence)"Terminated payara-server.");
            }
        }
    }

    Process getServerProcess() {
        return this.serverProcess;
    }

    private void watchAsadminCommand() {
        Thread thread = new Thread(this.threadGroup, () -> {
            try (Scanner scanner = new Scanner(System.in);){
                String userQuery = null;
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Thread.currentThread().interrupt()));
                while (!Thread.currentThread().isInterrupted() && !"exit".equals(userQuery)) {
                    block22: {
                        try {
                            if (scanner.hasNextLine()) {
                                userQuery = scanner.nextLine();
                                break block22;
                            }
                            Thread.currentThread().interrupt();
                        }
                        catch (NoSuchElementException nsee) {}
                        break;
                    }
                    try {
                        String finalRes;
                        String response;
                        if (userQuery.startsWith("asadmin")) {
                            if (!(this.serverManager instanceof LocalInstanceManager)) continue;
                            String repsonse = ((LocalInstanceManager)this.serverManager).runAsadminCommand(userQuery.substring(8));
                            this.getLog().info((CharSequence)repsonse);
                            continue;
                        }
                        if (userQuery.equals("deploy")) {
                            this.deployApplication();
                            continue;
                        }
                        if (userQuery.equals("undeploy")) {
                            this.serverManager.undeployApplication(this.projectName, this.instanceName);
                            continue;
                        }
                        if (userQuery.equals("exit")) {
                            Thread.currentThread().interrupt();
                            this.getLog().info((CharSequence)"watchAsadminCommand exit");
                            this.killServerProcess().start();
                            break;
                        }
                        if (userQuery.trim().isEmpty()) continue;
                        if (this.payaraAIAgent == null) {
                            this.getLog().error((CharSequence)"Payara AI Agent not initialized.");
                        }
                        if (this.payaraAIAgent.isAsAdminCommand(response = this.payaraAIAgent.query(userQuery, this.projectName).trim())) {
                            this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)response));
                            if (!this.payaraAIAgent.isReadonlyCommand(response) || !(this.serverManager instanceof LocalInstanceManager)) continue;
                            String cmdresponse = ((LocalInstanceManager)this.serverManager).runAsadminCommand(this.payaraAIAgent.getAsAdminCommand(response));
                            String string = this.payaraAIAgent.processAsadmin(userQuery, response + " \n" + cmdresponse);
                            this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)string));
                            continue;
                        }
                        if (this.payaraAIAgent.isRestEndpoint(response)) {
                            this.enableMonitoring();
                            this.callEndpoint(userQuery, response);
                            continue;
                        }
                        if (this.payaraAIAgent.isJmxMbean(response)) {
                            StringBuilder sb = new StringBuilder();
                            for (String mbean : this.payaraAIAgent.getJmxMbean(response)) {
                                sb.append(mbean).append('\n');
                                String res = JMXFetchSpecificMBean.execute((String)mbean);
                                sb.append(res).append("\n=================\n");
                            }
                            String string = this.payaraAIAgent.processJmxMbeansData(userQuery, sb.toString());
                            this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)string));
                            continue;
                        }
                        if (this.payaraAIAgent.isServerLog(response) && this.instance instanceof PayaraServerLocalInstance) {
                            finalRes = this.payaraAIAgent.processServerLogData(userQuery, ((PayaraServerLocalInstance)this.instance).readServerLog());
                            this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)finalRes));
                            continue;
                        }
                        if (this.payaraAIAgent.isDomainXml(response)) {
                            finalRes = this.payaraAIAgent.processServerLogData(userQuery, ((PayaraServerLocalInstance)this.instance).readDomainXml());
                            this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)finalRes));
                            continue;
                        }
                        this.getLog().info((CharSequence)response);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(StartMojo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void callEndpoint(String userQuery, String response) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String endpoint : this.payaraAIAgent.getRestEndpoint(response)) {
            endpoint = endpoint.replace("${appname}", this.projectName);
            sb.append(endpoint).append('\n');
            Response res = this.serverManager.runEndpoint(endpoint);
            if (res == null) continue;
            String endpointResponse = ((JsonResponse)res).getJsonBody().getJSONObject("extraProperties").toString();
            sb.append(endpointResponse).append("\n=================\n");
        }
        String finalRes = this.payaraAIAgent.processMonitoringData(userQuery, sb.toString());
        this.callChildEndpoint(userQuery, finalRes);
    }

    private void callChildEndpoint(String userQuery, String response) throws IOException {
        try {
            if (response.startsWith("```json")) {
                response = response.substring(7, response.length() - 3);
            } else if (response.startsWith("```")) {
                response = response.substring(3, response.length() - 3);
            }
            StringBuilder sb = new StringBuilder();
            JSONObject jsonObject = new JSONObject(response);
            if (jsonObject.has("response")) {
                this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)jsonObject.getString("response")));
            }
            if (jsonObject.has("childResource") && jsonObject.getJSONArray("childResource").length() > 0) {
                for (int i = 0; i < jsonObject.getJSONArray("childResource").length(); ++i) {
                    String endpoint = jsonObject.getJSONArray("childResource").getString(i);
                    endpoint = endpoint.replace("${appname}", this.projectName);
                    sb.append(endpoint).append('\n');
                    Response res = this.serverManager.runEndpoint(endpoint);
                    if (res == null) continue;
                    String endpointResponse = ((JsonResponse)res).getJsonBody().getJSONObject("extraProperties").toString();
                    sb.append(endpointResponse).append("\n=================\n");
                }
                String finalRes = this.payaraAIAgent.processMonitoringData(userQuery, sb.toString());
                this.callChildEndpoint(userQuery, finalRes);
            }
        }
        catch (JSONException e) {
            this.getLog().info((CharSequence)MarkdownToCmdHighlighter.convertMdToAnsi((String)response));
        }
    }

    private void enableMonitoring() throws Exception {
        if (!this.monitoringEnabled) {
            ArrayList<String> enableMonitoring = new ArrayList<String>(List.of("set-monitoring-level --level=HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH:HIGH --module=jvm:transactionService:connectorService:jmsService:security:webContainer:jersey:webServicesContainer:jpa:jdbcConnectionPool:threadPool:ejbContainer:orb:connectorConnectionPool:deployment:httpService --target=server-config", "set-monitoring-service-configuration --mbeanEnabled=true --monitoringEnabled=true --dtraceEnabled=false --target=server-config"));
            for (String command : enableMonitoring) {
                String response = ((LocalInstanceManager)this.serverManager).runAsadminCommand(command);
                this.getLog().info((CharSequence)response);
            }
            this.monitoringEnabled = true;
        }
    }

    private Thread streamRemoteServerLog() {
        Thread thread = new Thread(this.threadGroup, () -> {
            try {
                while (true) {
                    String log;
                    if ((log = ((RemoteInstanceManager)this.serverManager).fetchLogs(this.instanceName)) != null && !log.isEmpty()) {
                        System.out.println(log);
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        thread.setDaemon(false);
        thread.start();
        return thread;
    }

    private void streamLocalServerLog(PayaraServerLocalInstance instance) {
        Thread thread = new Thread(this.threadGroup, () -> {
            File logFile = new File(instance.getServerLog());
            if (logFile.exists()) {
                try {
                    RandomAccessFile raf = new RandomAccessFile(logFile, "r");
                    try {
                        raf.seek(raf.length());
                        while (true) {
                            String line;
                            if ((line = raf.readLine()) != null) {
                                System.out.println(line);
                                continue;
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Error occurred while streaming server.log", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.getLog().warn((CharSequence)("Log file does not exist: " + logFile.getAbsolutePath()));
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void redirectStream(InputStream inputStream, PrintStream printStream) {
        Thread thread = new Thread(this.threadGroup, () -> {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    printStream.println(line);
                    if (this.immediateExit || !sb.toString().contains("ready in")) continue;
                    this.serverProcessorThread.interrupt();
                    br.close();
                    break;
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void redirectStreamToGivenOutputStream(InputStream inputStream, OutputStream outputStream) {
        Thread thread = new Thread(this.threadGroup, () -> {
            try {
                if (this.liveReload.booleanValue() && outputStream instanceof PrintStream) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                    PrintStream printStream = (PrintStream)outputStream;
                    while ((line = br.readLine()) != null) {
                        printStream.println(this.trimLog != false ? LogUtils.trimLog((String)line) : line);
                        if (line.contains("Exception while loading the app")) {
                            WebDriverFactory.updateTitle((String)"Failed reloading", (MavenProject)this.getEnvironment().getMavenProject(), (WebDriver)this.driver, (Log)this.getLog());
                            continue;
                        }
                        if (this.applicationURL != null && !this.applicationURL.isEmpty() && this.driver != null && line.contains("was successfully deployed")) {
                            try {
                                this.driver.navigate().refresh();
                            }
                            catch (Exception ex) {
                                this.getLog().debug((CharSequence)"Error in refreshing with WebDriver", (Throwable)ex);
                            }
                            continue;
                        }
                        if (!this.autoDeploy.booleanValue() || !line.contains("User limit of inotify instances reached")) continue;
                        this.getLog().error((CharSequence)"Error starting WatchService. User limit of inotify instances reached or too many open files. Please increase the max_user_watches configuration.");
                    }
                } else {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error occurred while reading stream", (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void openApp() {
        try {
            this.driver = WebDriverFactory.createWebDriver((String)this.browser, (Log)this.getLog());
            Object url = PropertiesUtils.getProperty((String)this.applicationURL, (String)this.applicationURL);
            if (url == null || ((String)url).isEmpty()) {
                url = this.instance.getProtocol() + "://" + this.instance.getHost() + ":" + (this.instance.getProtocol().equals("http") ? this.instance.getHttpPort() : this.instance.getHttpsPort());
                if (this.contextRoot != null) {
                    url = (String)url + "/" + this.contextRoot;
                }
                this.applicationURL = url;
            }
            this.driver.get((String)url);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Error in running WebDriver", (Throwable)ex);
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(this.applicationURL));
                }
            }
            catch (IOException | URISyntaxException e) {
                this.getLog().error((CharSequence)"Error in running Desktop browse", (Throwable)e);
            }
            finally {
                this.driver = null;
            }
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public MavenProject getProject() {
        return this.getEnvironment().getMavenProject();
    }

    public List<String> getRebootOnChange() {
        return Collections.EMPTY_LIST;
    }

    public boolean isLocal() {
        return this.exploded;
    }
}

