/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.manager;

import fish.payara.maven.plugins.server.Command;
import fish.payara.maven.plugins.server.manager.PayaraServerInstance;
import fish.payara.maven.plugins.server.response.JsonResponse;
import fish.payara.maven.plugins.server.response.PlainResponse;
import fish.payara.maven.plugins.server.response.Response;
import fish.payara.maven.plugins.server.utils.ServerUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class InstanceManager<X extends PayaraServerInstance> {
    protected Log log;
    protected X payaraServer;
    private static final String HTTP_GET_METHOD = "GET";
    private static final String HTTP_POST_METHOD = "POST";
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_STREAM = "application/octet-stream";
    private static final String CONTENT_TYPE_ZIP = "application/zip";
    public static final String CONTENT_TYPE_PLAIN_TEXT = "text/plain";
    public static final String CONTENT_TYPE_HTML_TEXT = "text/html";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final int MAX_RETRIES = 100;
    public static final int HTTP_RETRY_DELAY = 3000;
    private static final String DEPLOY_COMMAND = "deploy";
    private static final String UNDEPLOY_COMMAND = "undeploy";
    private static final String GET_COMMAND = "get";
    protected static final String VIEW_LOG_COMMAND = "view-log";
    protected static final String LOCATIONS_COMMAND = "__locations";
    protected static final String ASADMIN_PATH = "/__asadmin/";
    protected static final String MANAGEMENT_PATH = "/management/domain/";
    protected static final String VERSION_COMMAND = "version";
    static final char PARAM_SEPARATOR = '&';
    static final char PARAM_ASSIGN_VALUE = '=';
    private static final String DEFAULT_PARAM = "DEFAULT";
    private static final String TARGET_PARAM = "target";
    private static final String NAME_PARAM = "name";
    private static final String PATTERN_PARAM = "pattern";
    private static final String START_PARAM = "start";
    private static final String INSTANCE_NAME_PARAM = "instanceName";
    private static final String CTXROOT_PARAM = "contextroot";
    private static final String FORCE_PARAM = "force";
    private static final String PROPERTIES_PARAM = "properties";
    private static final String LIBRARIES_PARAM = "libraries";
    private static final String HOT_DEPLOY_PARAM = "hotDeploy";
    private static final boolean FORCE_VALUE = true;

    public InstanceManager(X payaraServer, Log log) {
        this.payaraServer = payaraServer;
        this.log = log;
    }

    public void connectWithServer() throws MojoExecutionException {
        boolean pingSuccess = false;
        for (int i = 0; i < 100; ++i) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            try {
                if (!this.pingServer()) continue;
                pingSuccess = true;
                break;
            }
            catch (Exception e) {
                if (i != 99) continue;
                throw new MojoExecutionException("Failed to ping Payara Server after 100 attempts.", e);
            }
        }
        if (!pingSuccess) {
            this.log.error((CharSequence)"Error pinging the server");
        }
    }

    public boolean pingServer() throws Exception {
        Command command = new Command(MANAGEMENT_PATH, VERSION_COMMAND, null);
        Response response = this.invokeServer((PayaraServerInstance)this.payaraServer, command);
        return response != null && response.isExitCodeSuccess();
    }

    public boolean isServerAlreadyRunning() {
        Command command = new Command(ASADMIN_PATH, LOCATIONS_COMMAND, null);
        try {
            Response serverRunning = this.invokeServer((PayaraServerInstance)this.payaraServer, command);
            if (serverRunning != null && serverRunning.isExitCodeSuccess()) {
                this.log.info((CharSequence)("Server already running on " + serverRunning.toString()));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public List<String> getAsAdminEndpoints(String name) {
        return List.of("/__asadmin/__locations", "/__asadmin/get?pattern=applications.application." + name + ".context-root");
    }

    public URI deployApplication(String name, String appPath, String instanceName, String contextRoot, boolean exploded, boolean hotDeploy) {
        Command command = new Command(ASADMIN_PATH, DEPLOY_COMMAND, name);
        command.setPath(appPath);
        command.setContextRoot(contextRoot);
        command.setInstanceName(instanceName);
        command.setQuery(InstanceManager.query(command));
        command.setDirDeploy(exploded);
        command.setHotDeploy(hotDeploy);
        try {
            Response deploy = this.invokeServer((PayaraServerInstance)this.payaraServer, command);
            if (deploy != null && deploy.isExitCodeSuccess()) {
                Response response = this.getApplicationInfo(name);
                if (response != null && response.isExitCodeSuccess()) {
                    URI app = new URI(((PayaraServerInstance)this.payaraServer).getProtocol(), null, ((PayaraServerInstance)this.payaraServer).getHost(), ((PayaraServerInstance)this.payaraServer).getProtocol().equals("http") ? ((PayaraServerInstance)this.payaraServer).getHttpPort() : ((PayaraServerInstance)this.payaraServer).getHttpsPort(), this.getContextRoot(((JsonResponse)response).getJsonBody()), null, null);
                    this.log.info((CharSequence)(name + " application deployed successfully : " + app.toString()));
                    return app;
                }
                this.log.info((CharSequence)(name + " application deployed successfully."));
            } else if (deploy != null) {
                if (deploy.getCode() == 302) {
                    this.log.error((CharSequence)("Failed to deploy application. " + deploy.toString()));
                } else {
                    this.log.error((CharSequence)("Failed to deploy application. " + deploy.getHeaderFields()));
                }
            } else {
                this.log.error((CharSequence)"Failed to deploy application. ");
            }
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("Error deploying the application: " + ex.getMessage()));
        }
        return null;
    }

    public Response getApplicationInfo(String name) throws Exception {
        Command command = new Command(ASADMIN_PATH, GET_COMMAND, "applications.application." + name + ".context-root");
        command.setQuery(InstanceManager.query(command));
        return this.invokeServer((PayaraServerInstance)this.payaraServer, command);
    }

    public String getContextRoot(JSONObject body) {
        String nameValue;
        String[] parts;
        JSONArray resultArray = body.getJSONArray("result");
        if (resultArray.length() > 0 && (parts = (nameValue = resultArray.getJSONObject(0).getString(NAME_PARAM)).split("context-root=")).length > 1) {
            return parts[1];
        }
        return null;
    }

    public void undeployApplication(String name, String instanceName) {
        Command command = new Command(ASADMIN_PATH, UNDEPLOY_COMMAND, name);
        command.setQuery(InstanceManager.query(command));
        command.setInstanceName(instanceName);
        try {
            this.invokeServer((PayaraServerInstance)this.payaraServer, command);
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("Error undeploying the application: " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response invokeServer(PayaraServerInstance instance, Command command) throws Exception {
        boolean httpSucceeded = false;
        String commandUrl = this.constructCommandUrl(instance, command);
        int retries = 1;
        Response response = null;
        try {
            URL urlToConnectTo = new URL(commandUrl);
            while (!httpSucceeded) {
                if (retries-- <= 0) return response;
                URLConnection hconn = null;
                try {
                    URLConnection conn = InstanceManager.openURLConnection(urlToConnectTo);
                    if (conn instanceof HttpURLConnection) {
                        hconn = (HttpURLConnection)conn;
                        response = this.handleHTTPConnection(instance, command, conn, urlToConnectTo);
                        httpSucceeded = true;
                    }
                }
                catch (RuntimeException | ConnectException | ProtocolException ex) {
                    Response response2 = response;
                    return response2;
                }
                catch (IOException ex) {
                    if (retries <= 0) {
                        Response response3 = response;
                        return response3;
                    }
                }
                finally {
                    if (null != hconn) {
                        if (hconn.getInputStream() != null) {
                            try {
                                hconn.getInputStream().close();
                            }
                            catch (IOException iOException) {}
                        }
                        ((HttpURLConnection)hconn).disconnect();
                    }
                }
                if (httpSucceeded || retries <= 0) continue;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    this.log.info((CharSequence)"sleepInterrupted", (Throwable)ie);
                }
            }
            return response;
        }
        catch (MalformedURLException ex) {
            this.log.warn((Throwable)ex);
        }
        return response;
    }

    private static URLConnection openURLConnection(URL urlToConnectTo) throws IOException {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(urlToConnectTo.getHost());
        }
        catch (UnknownHostException ex) {
            addr = null;
        }
        if (addr != null && addr.isLoopbackAddress()) {
            return urlToConnectTo.openConnection(Proxy.NO_PROXY);
        }
        return urlToConnectTo.openConnection();
    }

    private Response handleHTTPConnection(PayaraServerInstance instance, Command command, URLConnection conn, URL urlToConnectTo) throws IOException {
        String location;
        StringBuilder response;
        HttpURLConnection hconn = (HttpURLConnection)conn;
        if (conn instanceof HttpsURLConnection) {
            this.handleSecureConnection((HttpsURLConnection)conn);
        }
        this.prepareHttpConnection(instance, command, hconn);
        hconn.connect();
        this.handleSend(command, hconn);
        int respCode = hconn.getResponseCode();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(hconn.getInputStream()));){
            String inputLine;
            response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append('\n').append(inputLine);
            }
        }
        if (respCode == 302 && (location = hconn.getHeaderField("Location")).startsWith("https://") && hconn.getURL().toString().startsWith("http://")) {
            URL secureUrl = new URL(location);
            URLConnection newConn = secureUrl.openConnection();
            instance.setProtocol("https");
            return this.handleHTTPConnection(instance, command, newConn, secureUrl);
        }
        if (command.getContentType().equals(CONTENT_TYPE_PLAIN_TEXT)) {
            return new PlainResponse(response.toString(), respCode, hconn.getHeaderFields());
        }
        return new JsonResponse(response.toString(), respCode, hconn.getHeaderFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSend(Command command, HttpURLConnection hconn) throws IOException {
        InputStream istream = this.getInputStream(command);
        if (istream != null) {
            ZipOutputStream ostream = null;
            try {
                int n;
                File file = new File(command.getPath());
                ostream = new ZipOutputStream(new BufferedOutputStream(hconn.getOutputStream(), 0x100000));
                ZipEntry e = new ZipEntry(file.getName());
                e.setExtra(this.getExtraProperties(file));
                ostream.putNextEntry(e);
                byte[] buffer = new byte[0x100000];
                while ((n = istream.read(buffer)) >= 0) {
                    ostream.write(buffer, 0, n);
                }
                ostream.closeEntry();
                ostream.flush();
            }
            finally {
                try {
                    istream.close();
                }
                catch (IOException ex) {
                    this.log.error((Throwable)ex);
                }
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (IOException ex) {
                        this.log.error((Throwable)ex);
                    }
                }
            }
        }
    }

    private byte[] getExtraProperties(File file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Properties props = new Properties();
        props.setProperty("data-request-type", "file-xfer");
        props.setProperty("last-modified", Long.toString(file.lastModified()));
        props.put("data-request-name", DEFAULT_PARAM);
        props.put("data-request-is-recursive", "true");
        props.put(CONTENT_TYPE_HEADER, CONTENT_TYPE_STREAM);
        props.list(new PrintStream(baos));
        return baos.toByteArray();
    }

    private InputStream getInputStream(Command command) {
        if (command.isDirDeploy()) {
            return null;
        }
        if (command.getPath() != null) {
            File file = new File(command.getPath());
            if (!file.exists() || !file.canRead()) {
                this.log.error((CharSequence)("File not found or cannot be read: " + command.getPath()));
                return null;
            }
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                this.log.error((CharSequence)("Exception while opening file: " + fnfe.getMessage()));
                return null;
            }
        }
        return null;
    }

    private void prepareHttpConnection(PayaraServerInstance server, Command command, HttpURLConnection conn) throws IllegalStateException {
        String contentType;
        conn.setAllowUserInteraction(false);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(server.getHttpConnectionTimeout());
        String adminUser = server.getAdminUser();
        String adminPassword = server.getAdminPassword();
        try {
            conn.setRequestMethod(command.isDirDeploy() || command.getPath() == null ? HTTP_GET_METHOD : HTTP_POST_METHOD);
        }
        catch (ProtocolException pe) {
            throw new IllegalStateException(pe);
        }
        conn.setDoOutput(!command.isDirDeploy());
        String string = contentType = command.isDirDeploy() || command.getPath() == null ? null : CONTENT_TYPE_ZIP;
        if (contentType != null && contentType.length() > 0) {
            conn.setRequestProperty(CONTENT_TYPE_HEADER, contentType);
            conn.setChunkedStreamingMode(0);
        }
        conn.setRequestProperty("Accept", command.getContentType());
        if (adminPassword != null && adminPassword.length() > 0) {
            String authString = ServerUtils.basicAuthCredentials(adminUser, adminPassword);
            conn.setRequestProperty("Authorization", "Basic " + authString);
        }
    }

    private void handleSecureConnection(HttpsURLConnection conn) {
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, tm, null);
            conn.setSSLSocketFactory(context.getSocketFactory());
            conn.setHostnameVerifier((string, ssls) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            this.log.error((CharSequence)conn.getURL().toString(), (Throwable)ex);
        }
    }

    private String constructCommandUrl(PayaraServerInstance server, Command command) throws IllegalStateException {
        URI uri;
        if (command.getCommand().startsWith("http")) {
            return command.getCommand();
        }
        try {
            uri = new URI(server.getProtocol(), null, server.getHost(), server.getAdminPort(), command.getRootPath() + command.getCommand(), command.getQuery(), null);
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException(use);
        }
        return uri.toASCIIString().replace("+", "%2b");
    }

    protected static String query(Command command) {
        StringBuilder sb = new StringBuilder();
        switch (command.getCommand()) {
            case "deploy": {
                sb.append(DEFAULT_PARAM).append('=').append(command.getPath());
                sb.append('&');
                sb.append(FORCE_PARAM).append('=').append(true);
                if (command.getValue() != null && command.getValue().length() > 0) {
                    sb.append('&');
                    sb.append(NAME_PARAM).append('=').append(command.getValue());
                }
                if (command.getInstanceName() != null) {
                    sb.append('&');
                    sb.append(TARGET_PARAM).append('=').append(command.getInstanceName());
                }
                if (command.getContextRoot() != null && command.getContextRoot().length() > 0) {
                    sb.append('&');
                    sb.append(CTXROOT_PARAM).append('=').append(command.getContextRoot());
                }
                if (!command.isHotDeploy()) break;
                sb.append('&');
                sb.append(HOT_DEPLOY_PARAM);
                sb.append('=').append(command.isHotDeploy());
                break;
            }
            case "undeploy": {
                sb.append(DEFAULT_PARAM).append('=').append(command.getValue());
                break;
            }
            case "get": {
                sb.append(PATTERN_PARAM).append('=').append(command.getValue());
                break;
            }
            case "view-log": {
                sb.append(START_PARAM).append('=').append(command.getValue());
                if (command.getInstanceName() == null) break;
                sb.append(INSTANCE_NAME_PARAM).append('=').append(command.getInstanceName());
                break;
            }
        }
        return sb.toString();
    }

    public Response runEndpoint(String endpoint) {
        Command command = new Command("", endpoint, null);
        Response serverRunning = null;
        try {
            serverRunning = this.invokeServer((PayaraServerInstance)this.payaraServer, command);
            if (serverRunning != null && serverRunning.isExitCodeSuccess()) {
                return serverRunning;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverRunning;
    }
}

