/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.manager;

import fish.payara.maven.plugins.server.Command;
import fish.payara.maven.plugins.server.Option;
import fish.payara.maven.plugins.server.manager.InstanceManager;
import fish.payara.maven.plugins.server.manager.PayaraServerLocalInstance;
import fish.payara.maven.plugins.server.parser.JDKVersion;
import fish.payara.maven.plugins.server.parser.JvmConfigReader;
import fish.payara.maven.plugins.server.parser.JvmOption;
import fish.payara.maven.plugins.server.response.Response;
import fish.payara.maven.plugins.server.utils.JavaUtils;
import fish.payara.maven.plugins.server.utils.ServerUtils;
import fish.payara.maven.plugins.server.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class LocalInstanceManager
extends InstanceManager<PayaraServerLocalInstance> {
    private static final String ERROR_JAVA_HOME_NOT_FOUND = "Java home path not found.";
    private static final String ERROR_JAVA_VERSION_NOT_FOUND = "Java version not found.";
    private static final String ERROR_BOOTSTRAP_JAR_NOT_FOUND = "No bootstrap jar exists.";
    private static final String ERROR_JAVA_VM_EXECUTABLE_NOT_FOUND = "Java VM executable for %s was not found.";

    public LocalInstanceManager(PayaraServerLocalInstance payaraServer, Log log) {
        super(payaraServer, log);
    }

    public ProcessBuilder startServer(String debug, String debugPort, List<Option> javaCommandLineOptions, List<Option> commandLineOptions) throws Exception {
        JvmConfigReader jvmConfigReader = new JvmConfigReader(((PayaraServerLocalInstance)this.payaraServer).getDomainXml(), "server");
        String javaHome = ((PayaraServerLocalInstance)this.payaraServer).getJDKHome();
        if (javaHome == null) {
            throw new Exception(ERROR_JAVA_HOME_NOT_FOUND);
        }
        JDKVersion javaVersion = JDKVersion.getJDKVersion(javaHome);
        if (javaVersion == null) {
            throw new Exception(ERROR_JAVA_VERSION_NOT_FOUND);
        }
        ArrayList<Object> options = new ArrayList<Object>();
        if (javaCommandLineOptions != null) {
            for (Option option : javaCommandLineOptions) {
                if (option.getKey() != null && option.getValue() != null) {
                    String systemProperty = String.format("%s=%s", option.getKey(), option.getValue());
                    options.add(systemProperty);
                    continue;
                }
                if (option.getValue() == null) continue;
                options.add(option.getValue());
            }
        }
        String javaConfigOptions = String.join((CharSequence)" ", options).trim();
        options = new ArrayList();
        if (commandLineOptions != null) {
            for (Option option : commandLineOptions) {
                if (option.getKey() != null && option.getValue() != null) {
                    String systemProperty = String.format("%s=%s", option.getKey(), option.getValue());
                    options.add(systemProperty);
                    continue;
                }
                if (option.getValue() == null) continue;
                options.add(option.getValue());
            }
        }
        String string = String.join((CharSequence)" ", options).trim();
        ArrayList<String> optList = new ArrayList<String>();
        for (JvmOption jvmOption : jvmConfigReader.getJvmOptions()) {
            if (!JDKVersion.isCorrectJDK(javaVersion, jvmOption.getVendor(), jvmOption.getMinVersion(), jvmOption.getMaxVersion())) continue;
            optList.add(jvmOption.getOption());
        }
        Map<String, String> propMap = jvmConfigReader.getPropMap();
        this.addJavaAgent((PayaraServerLocalInstance)this.payaraServer, jvmConfigReader);
        Object bootstrapJar = Paths.get(((PayaraServerLocalInstance)this.payaraServer).getServerModules(), "glassfish.jar").toString();
        if (!Files.exists(Paths.get((String)bootstrapJar, new String[0]), new LinkOption[0])) {
            throw new Exception(ERROR_BOOTSTRAP_JAR_NOT_FOUND);
        }
        if (((String)bootstrapJar).contains(" ")) {
            bootstrapJar = "\"" + (String)bootstrapJar + "\"";
        }
        String classPath = "";
        Map<String, String> varMap = this.varMap((PayaraServerLocalInstance)this.payaraServer, javaHome);
        String debugOpt = propMap.get("debug-options");
        if (debug != null && !debug.equalsIgnoreCase(Boolean.FALSE.toString()) && debugOpt != null) {
            if (Boolean.parseBoolean(debug)) {
                if (this.isValidPort(debugPort)) {
                    debugOpt = debugOpt.replaceAll("address=\\d+", "address=" + debugPort);
                }
                optList.add(debugOpt);
            } else {
                optList.add(debug);
            }
        }
        Object javaOpts = this.appendOptions(optList, varMap);
        javaOpts = (String)javaOpts + this.appendVarMap(varMap);
        String payaraArgs = this.appendPayaraArgs(this.getPayaraArgs((PayaraServerLocalInstance)this.payaraServer));
        String javaVmExe = JavaUtils.javaVmExecutableFullPath(javaHome);
        if (!Files.exists(Paths.get(javaVmExe, new String[0]), new LinkOption[0])) {
            throw new Exception(String.format(ERROR_JAVA_VM_EXECUTABLE_NOT_FOUND, ((PayaraServerLocalInstance)this.payaraServer).getPath()));
        }
        String allArgs = String.join((CharSequence)" ", new CharSequence[]{javaVmExe, javaOpts, javaConfigOptions, "-jar", bootstrapJar, "--classpath", classPath, payaraArgs, string});
        List<String> args = JavaUtils.parseParameters(allArgs);
        this.log.info((CharSequence)("Starting Payara Server with arguments: " + String.join((CharSequence)" ", args)));
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.directory(new File(((PayaraServerLocalInstance)this.payaraServer).getPath()));
        return processBuilder;
    }

    private boolean isValidPort(String portStr) {
        if (portStr == null || portStr.trim().isEmpty()) {
            return false;
        }
        try {
            int port = Integer.parseInt(portStr.trim());
            return port >= 0 && port <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void addJavaAgent(PayaraServerLocalInstance payaraServer, JvmConfigReader jvmConfigReader) throws Exception {
        List<JvmOption> optList = jvmConfigReader.getJvmOptions();
        String serverHome = payaraServer.getServerHome();
        File monitor = Paths.get(serverHome, "lib", "monitor").toFile();
        File btrace = Paths.get(monitor.getPath(), "btrace-agent.jar").toFile();
        File flight = Paths.get(monitor.getPath(), "flashlight-agent.jar").toFile();
        if (jvmConfigReader.isMonitoringEnabled()) {
            if (btrace.exists()) {
                optList.add(new JvmOption("-javaagent:" + StringUtils.quote(btrace.getPath()) + "=unsafe=true,noServer=true"));
            } else if (flight.exists()) {
                optList.add(new JvmOption("-javaagent:" + StringUtils.quote(flight.getPath())));
            }
        }
    }

    private Map<String, String> varMap(PayaraServerLocalInstance payaraServer, String javaHome) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("com.sun.aas.installRoot", payaraServer.getServerHome());
        varMap.put("com.sun.aas.instanceRoot", payaraServer.getDomainPath());
        varMap.put("com.sun.aas.javaRoot", javaHome);
        varMap.put(JavaUtils.PATH_SEPARATOR, File.pathSeparator);
        return varMap;
    }

    /*
     * WARNING - void declaration
     */
    private String appendOptions(List<String> optList, Map<String, String> varMap) {
        StringBuilder argumentBuf = new StringBuilder();
        ArrayList<void> moduleOptions = new ArrayList<void>();
        HashMap<String, String> keyValueArgs = new HashMap<String, String>();
        ArrayList<String> keyOrder = new ArrayList<String>();
        for (String string : optList) {
            void var8_8;
            String name;
            String string2 = StringUtils.doSub(string.trim(), varMap);
            int splitIndex = string2.indexOf(61);
            String value = null;
            if (splitIndex != -1 && !string2.startsWith("-agentpath:")) {
                name = string2.substring(0, splitIndex);
                value = StringUtils.quote(string2.substring(splitIndex + 1));
            } else if (string2.startsWith("-Xbootclasspath")) {
                splitIndex = string2.indexOf(58);
                name = string2.substring(0, splitIndex);
                value = StringUtils.quote(string2.substring(splitIndex + 1));
                String string3 = name + ":" + value;
            } else {
                name = string2;
            }
            if (var8_8.startsWith("--add-") || var8_8.startsWith("-Xbootclasspath")) {
                moduleOptions.add(var8_8);
                continue;
            }
            if (!keyValueArgs.containsKey(name)) {
                keyOrder.add(name);
            }
            keyValueArgs.put(name, value);
        }
        argumentBuf.append(String.join((CharSequence)" ", moduleOptions));
        for (String string : keyOrder) {
            argumentBuf.append(" ").append(string);
            if (keyValueArgs.get(string) == null) continue;
            argumentBuf.append("=").append((String)keyValueArgs.get(string));
        }
        return argumentBuf.toString();
    }

    private String appendVarMap(Map<String, String> varMap) {
        StringBuilder javaOpts = new StringBuilder();
        varMap.forEach((key, value) -> javaOpts.append(" ").append(JavaUtils.systemProperty(key, value)));
        return javaOpts.toString();
    }

    private List<String> getPayaraArgs(PayaraServerLocalInstance payaraServer) {
        ArrayList<String> payaraArgs = new ArrayList<String>();
        payaraArgs.add(ServerUtils.cmdLineArgument("--domain", payaraServer.getDomainName()));
        payaraArgs.add(ServerUtils.cmdLineArgument("--domaindir", StringUtils.quote(payaraServer.getDomainPath())));
        return payaraArgs;
    }

    private String appendPayaraArgs(List<String> payaraArgsList) {
        return String.join((CharSequence)" ", payaraArgsList).trim();
    }

    @Override
    public boolean isServerAlreadyRunning() {
        Command command = new Command("/__asadmin/", "__locations", null);
        try {
            Response serverRunning = this.invokeServer(this.payaraServer, command);
            if (serverRunning != null && serverRunning.isExitCodeSuccess() && serverRunning.toString().equals(((PayaraServerLocalInstance)this.payaraServer).getDomainPath())) {
                this.log.info((CharSequence)("Server already running on " + serverRunning.toString()));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String runAsadminCommand(String command) throws Exception {
        String line;
        BufferedReader reader;
        String javaHome = ((PayaraServerLocalInstance)this.payaraServer).getJDKHome();
        if (javaHome == null) {
            throw new Exception(ERROR_JAVA_HOME_NOT_FOUND);
        }
        String javaVmExe = JavaUtils.javaVmExecutableFullPath(javaHome);
        if (!Files.exists(Paths.get(javaVmExe, new String[0]), new LinkOption[0])) {
            throw new Exception(String.format(ERROR_JAVA_VM_EXECUTABLE_NOT_FOUND, ((PayaraServerLocalInstance)this.payaraServer).getPath()));
        }
        String asadminPath = Paths.get(((PayaraServerLocalInstance)this.payaraServer).getServerHome(), "bin", "asadmin").toString();
        if (!Files.exists(Paths.get(asadminPath, new String[0]), new LinkOption[0])) {
            throw new Exception("asadmin executable not found at " + asadminPath);
        }
        ArrayList<String> commandList = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            commandList.add("cmd.exe");
            commandList.add("/c");
        } else {
            commandList.add("/bin/sh");
            commandList.add("-c");
        }
        commandList.add(asadminPath);
        commandList.addAll(Arrays.asList(command.split("\\s+")));
        ProcessBuilder processBuilder = new ProcessBuilder(commandList);
        processBuilder.directory(Paths.get(((PayaraServerLocalInstance)this.payaraServer).getServerHome(), "bin").toFile());
        Process process = processBuilder.start();
        StringBuilder sb = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error reading process output", (Throwable)e);
        }
        try {
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error reading process error output", (Throwable)e);
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            this.log.error((CharSequence)("asadmin command failed with exit code " + exitCode));
        }
        return sb.toString();
    }
}

