/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.manager;

import fish.payara.maven.plugins.server.manager.PayaraServerInstance;
import fish.payara.maven.plugins.server.parser.JDKVersion;
import fish.payara.maven.plugins.server.parser.PortReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PayaraServerLocalInstance
extends PayaraServerInstance {
    public static final String GLASSFISH_DIR = "glassfish";
    public static final String MODULES_DIR = "modules";
    public static final String DOMAINS_DIR = "domains";
    public static final String CONFIG_DIR = "config";
    public static final String LOGS_DIR = "logs";
    public static final String SERVER_LOG = "server.log";
    public static final String DOMAIN_XML = "domain.xml";
    public static final String HTTPS = "https";
    public static final String HTTP = "http";
    public static final String HTTPS_PREFIX = "https://";
    public static final String HTTP_PREFIX = "http://";
    public static final String LOCATION_HEADER = "Location";
    public static final String LOCALHOST = "localhost";
    private PortReader portReader;
    private Process logStream;
    private final String path;
    private final String domainName;
    private String jdkHome;

    public PayaraServerLocalInstance(String jdkHome, String path, String domainName) {
        this.jdkHome = jdkHome;
        this.path = path;
        this.domainName = domainName;
    }

    public String getId() {
        return this.getDomainPath();
    }

    public String getPath() {
        return this.path;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getServerRoot() {
        return this.getPath();
    }

    public String getServerHome() {
        return Paths.get(this.getServerRoot(), GLASSFISH_DIR).toString();
    }

    public String getServerModules() {
        return Paths.get(this.getServerHome(), MODULES_DIR).toString();
    }

    public String getDomainsFolder() {
        return Paths.get(this.getServerHome(), DOMAINS_DIR).toString();
    }

    public String getDomainPath() {
        return Paths.get(this.getDomainsFolder(), this.getDomainName()).toString();
    }

    public String getDomainXml() {
        return Paths.get(this.getDomainPath(), CONFIG_DIR, DOMAIN_XML).toString();
    }

    public String getServerLog() {
        return Paths.get(this.getDomainPath(), LOGS_DIR, SERVER_LOG).toString();
    }

    public String readServerLog() throws IOException {
        return this.readServerLog(5000);
    }

    public String readServerLog(int maxLength) throws IOException {
        String logContent = this.readFileWithReplacement(this.getServerLog());
        return logContent.length() > maxLength ? logContent.substring(0, maxLength) : logContent;
    }

    public String readDomainXml() throws IOException {
        return this.readFileWithReplacement(this.getDomainXml());
    }

    private String readFileWithReplacement(String filePath) throws IOException {
        byte[] raw = Files.readAllBytes(Paths.get(filePath, new String[0]));
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer decoded = decoder.decode(ByteBuffer.wrap(raw));
        return decoded.toString();
    }

    public String getJDKHome() {
        if (this.jdkHome != null) {
            return this.jdkHome;
        }
        return JDKVersion.getDefaultJDKHome();
    }

    public void setJdkHome(String jdkHome) {
        this.jdkHome = jdkHome;
    }

    @Override
    public String getProtocol() {
        if (this.protocol == null) {
            return HTTP;
        }
        return this.protocol;
    }

    @Override
    public String getHost() {
        return this.host == null ? LOCALHOST : this.host;
    }

    @Override
    public int getHttpPort() {
        if (this.httpPort > 0) {
            return this.httpPort;
        }
        if (this.portReader == null) {
            this.portReader = this.createPortReader();
        }
        return this.portReader.getHttpPort();
    }

    @Override
    public int getHttpsPort() {
        if (this.httpsPort > 0) {
            return this.httpsPort;
        }
        if (this.portReader == null) {
            this.portReader = this.createPortReader();
        }
        return this.portReader.getHttpsPort();
    }

    @Override
    public int getAdminPort() {
        if (this.adminPort > 0) {
            return this.adminPort;
        }
        if (this.portReader == null) {
            this.portReader = this.createPortReader();
        }
        return this.portReader.getAdminPort();
    }

    private PortReader createPortReader() {
        return new PortReader(this.getDomainXml(), "server");
    }

    public void disconnectOutput() {
        if (this.logStream != null) {
            this.logStream.destroy();
        }
    }
}

