/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.manager;

import fish.payara.maven.plugins.server.Command;
import fish.payara.maven.plugins.server.manager.InstanceManager;
import fish.payara.maven.plugins.server.manager.PayaraServerRemoteInstance;
import fish.payara.maven.plugins.server.response.Response;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class RemoteInstanceManager
extends InstanceManager<PayaraServerRemoteInstance> {
    private String appendPreviousStart;
    private String appendnextStart;
    private static final String APPEND_NEXT_HEADER = "X-Text-Append-Next";

    public RemoteInstanceManager(PayaraServerRemoteInstance payaraServer, Log log) {
        super(payaraServer, log);
    }

    public String fetchLogs(String instanceName) {
        Command command = new Command("/management/domain/", "view-log", "0");
        command.setContentType("text/plain");
        command.setInstanceName(instanceName);
        if (this.appendnextStart == null) {
            command.setQuery(RemoteInstanceManager.query(command));
        } else {
            command.setQuery(this.appendnextStart);
        }
        try {
            String headerValue;
            int questionMarkIndex;
            Response logResponse = this.invokeServer(this.payaraServer, command);
            List<String> headerValues = logResponse.getHeaderFields().get(APPEND_NEXT_HEADER);
            if (headerValues != null && !headerValues.isEmpty() && (questionMarkIndex = (headerValue = headerValues.get(0)).indexOf(63)) != -1 && questionMarkIndex < headerValue.length() - 1) {
                this.appendPreviousStart = this.appendnextStart;
                this.appendnextStart = headerValue.substring(questionMarkIndex + 1);
            }
            return this.appendPreviousStart == null || this.appendnextStart.equals(this.appendPreviousStart) ? "" : logResponse.toString();
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("Error retrieving log: " + ex.getMessage()));
            return null;
        }
    }
}

