/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.parser;

import fish.payara.maven.plugins.server.utils.JavaUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class JDKVersion {
    private int major;
    private Integer minor;
    private Integer subminor;
    private Integer update;
    private String vendor;
    private static final int MAJOR_INDEX = 0;
    private static final int MINOR_INDEX = 1;
    private static final int SUBMINOR_INDEX = 2;
    private static final int UPDATE_INDEX = 3;
    private static final int DEFAULT_VALUE = 0;
    private static final String VERSION_MATCHER = "(\\d+(\\.\\d+)*)([_u\\-]+[\\S]+)*";

    public JDKVersion(int major, Integer minor, Integer subminor, Integer update, String vendor) {
        this.major = major;
        this.minor = minor;
        this.subminor = subminor;
        this.update = update;
        this.vendor = vendor;
    }

    public int getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getSubMinor() {
        return this.subminor;
    }

    public Integer getUpdate() {
        return this.update;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean gt(JDKVersion version) {
        if (this.major > version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.gtNumber(this.minor, version.getMinor())) {
                return true;
            }
            if (this.eq(this.minor, version.getMinor())) {
                if (this.gtNumber(this.subminor, version.getSubMinor())) {
                    return true;
                }
                if (this.eq(this.subminor, version.getSubMinor())) {
                    return this.gtNumber(this.update, version.getUpdate());
                }
            }
        }
        return false;
    }

    public boolean lt(JDKVersion version) {
        if (this.major < version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.ltNumber(this.minor, version.getMinor())) {
                return true;
            }
            if (this.eq(this.minor, version.getMinor())) {
                if (this.ltNumber(this.subminor, version.getSubMinor())) {
                    return true;
                }
                if (this.eq(this.subminor, version.getSubMinor())) {
                    return this.ltNumber(this.update, version.getUpdate());
                }
            }
        }
        return false;
    }

    public boolean ge(JDKVersion version) {
        return this.gt(version) || this.equals(version);
    }

    public boolean le(JDKVersion version) {
        return this.lt(version) || this.equals(version);
    }

    private boolean gtNumber(Integer v1, Integer v2) {
        if (v1 == null) {
            v1 = 0;
        }
        if (v2 == null) {
            v2 = 0;
        }
        return v1 > v2;
    }

    private boolean ltNumber(Integer v1, Integer v2) {
        if (v1 == null) {
            v1 = 0;
        }
        if (v2 == null) {
            v2 = 0;
        }
        return v1 < v2;
    }

    private boolean eq(Integer v1, Integer v2) {
        if (v1 == null) {
            v1 = 0;
        }
        if (v2 == null) {
            v2 = 0;
        }
        return v1.equals(v2);
    }

    public boolean equals(JDKVersion other) {
        if (other == null) {
            return false;
        }
        return this.major == other.getMajor() && this.eq(this.minor, other.getMinor()) && this.eq(this.subminor, other.getSubMinor()) && this.eq(this.update, other.getUpdate());
    }

    public String toString() {
        StringBuilder value = new StringBuilder(Integer.toString(this.major));
        if (this.minor != null) {
            value.append(this.minor);
        }
        if (this.subminor != null) {
            value.append(this.subminor);
        }
        if (this.update != null) {
            value.append(this.update);
        }
        return value.toString();
    }

    public static JDKVersion toValue(String version, String vendor) {
        if (version != null && !version.isEmpty()) {
            int[] versions = JDKVersion.parseVersions(version);
            int major = versions[0];
            Integer minor = versions[1];
            Integer subminor = versions[2];
            Integer update = versions[3];
            return new JDKVersion(major, minor, subminor, update, vendor);
        }
        return null;
    }

    public static int[] parseVersions(String javaVersion) {
        String[] javaVersionSplit;
        String[] split;
        int[] versions = new int[]{1, 0, 0, 0};
        if (javaVersion != null && !javaVersion.isEmpty() && (split = (javaVersionSplit = javaVersion.split("-"))[0].split("\\.")).length > 0) {
            versions[0] = Integer.parseInt(split[0]);
            if (split.length > 1) {
                versions[1] = Integer.parseInt(split[1]);
            }
            if (split.length > 2) {
                String[] subSplit = split[2].split("[_u]+");
                versions[2] = Integer.parseInt(subSplit[0]);
                if (subSplit.length > 1) {
                    versions[3] = Integer.parseInt(subSplit[1]);
                }
            }
        }
        return versions;
    }

    public static String getDefaultJDKHome() {
        String javaHome = System.getenv("JDK_HOME");
        if (javaHome == null) {
            javaHome = System.getenv("JAVA_HOME");
        }
        return javaHome;
    }

    public static JDKVersion getJDKVersion(String javaHome) throws IOException {
        String line;
        String javaVersion = "";
        String implementor = null;
        String javaVmExe = JavaUtils.javaVmExecutableFullPath(javaHome);
        if (!new File(javaVmExe).exists()) {
            throw new IOException("Java VM executable not found at: " + javaVmExe);
        }
        Process process = new ProcessBuilder(javaVmExe, "-XshowSettings:properties", "-version").redirectErrorStream(true).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (line.contains("java.version =")) {
                javaVersion = JDKVersion.extractValue(line);
                continue;
            }
            if (!line.contains("java.vendor =")) continue;
            implementor = JDKVersion.extractValue(line);
        }
        reader.close();
        if (!javaVersion.isEmpty()) {
            return JDKVersion.toValue(javaVersion, implementor);
        }
        return null;
    }

    private static String extractValue(String line) {
        String[] keyValue = line.split("=");
        if (keyValue.length == 2) {
            return keyValue[1].trim();
        }
        return "";
    }

    public static boolean isCorrectJDK(JDKVersion jdkVersion, String vendor, JDKVersion minVersion, JDKVersion maxVersion) {
        String jdkVendor;
        boolean correctJDK = true;
        if (vendor != null && (jdkVendor = jdkVersion.getVendor()) != null && !jdkVendor.contains(vendor)) {
            correctJDK = false;
        }
        if (correctJDK && minVersion != null) {
            correctJDK = jdkVersion.ge(minVersion);
        }
        if (correctJDK && maxVersion != null) {
            correctJDK = jdkVersion.le(maxVersion);
        }
        return correctJDK;
    }
}

