/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.parser;

import fish.payara.maven.plugins.server.parser.JvmOption;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JvmConfigReader {
    private final String serverName;
    private final List<JvmOption> jvmOptions = new ArrayList<JvmOption>();
    private final Map<String, String> propMap = new HashMap<String, String>();
    private boolean monitoringEnabled = false;
    private String serverConfigName = "";
    private boolean readConfig = false;

    public JvmConfigReader(String domainXmlPath, String serverName) {
        this.serverName = serverName;
        this.parseDomainXML(domainXmlPath);
    }

    private void parseDomainXML(String domainXmlPath) {
        try {
            int i;
            File xmlFile = new File(domainXmlPath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList servers = doc.getElementsByTagName("server");
            NodeList configs = doc.getElementsByTagName("config");
            for (i = 0; i < servers.getLength(); ++i) {
                Element serverElement;
                Node serverNode = servers.item(i);
                if (serverNode.getNodeType() != 1 || !this.serverName.equals((serverElement = (Element)serverNode).getAttribute("name"))) continue;
                this.serverConfigName = serverElement.getAttribute("config-ref");
                break;
            }
            for (i = 0; i < configs.getLength(); ++i) {
                Element configElement;
                Node configNode = configs.item(i);
                if (configNode.getNodeType() != 1 || !this.serverConfigName.equals((configElement = (Element)configNode).getAttribute("name"))) continue;
                NodeList javaConfigList = configElement.getElementsByTagName("java-config");
                if (javaConfigList.getLength() > 0) {
                    Element javaConfig = (Element)javaConfigList.item(0);
                    NodeList jvmOptionsList = javaConfig.getElementsByTagName("jvm-options");
                    for (int j = 0; j < jvmOptionsList.getLength(); ++j) {
                        Node jvmOptionNode = jvmOptionsList.item(j);
                        if (jvmOptionNode.getNodeType() != 1) continue;
                        String value = jvmOptionNode.getTextContent().trim();
                        this.jvmOptions.add(new JvmOption(value));
                    }
                    NamedNodeMap attributes = javaConfig.getAttributes();
                    for (int k = 0; k < attributes.getLength(); ++k) {
                        Node attribute = attributes.item(k);
                        this.propMap.put(attribute.getNodeName(), attribute.getNodeValue());
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse file " + domainXmlPath + " : " + e.getMessage(), e);
        }
    }

    public List<JvmOption> getJvmOptions() {
        return this.jvmOptions;
    }

    public Map<String, String> getPropMap() {
        return this.propMap;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }
}

