/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.parser;

import fish.payara.maven.plugins.server.parser.JDKVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JvmOption {
    private static final String PATTERN = "^\\[(.*)\\|(.*)\\](.*)";
    private String option;
    private String vendor;
    private JDKVersion minVersion;
    private JDKVersion maxVersion;

    public JvmOption(String option) {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(option);
        if (matcher.matches() && matcher.groupCount() == 3) {
            String vendorString = matcher.group(1);
            if (vendorString.contains("-") && vendorString.matches(".*[a-zA-Z].*")) {
                String[] parts = vendorString.split("-");
                this.vendor = parts[0];
                this.minVersion = JDKVersion.toValue(parts[1], null);
            } else {
                this.vendor = null;
                this.minVersion = JDKVersion.toValue(vendorString, null);
            }
            this.maxVersion = JDKVersion.toValue(matcher.group(2), null);
            this.option = matcher.group(3);
        } else {
            this.option = option;
        }
    }

    public String getOption() {
        return this.option;
    }

    public String getVendor() {
        return this.vendor;
    }

    public JDKVersion getMinVersion() {
        return this.minVersion;
    }

    public JDKVersion getMaxVersion() {
        return this.maxVersion;
    }

    public String toString() {
        return "JvmOption{option='" + this.option + "', vendor='" + this.vendor + "', minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + "}";
    }
}

