/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.parser;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PortReader {
    private String serverName;
    private int httpPort = -1;
    private int httpsPort = -1;
    private int adminPort = -1;
    private String serverConfigName = "";

    public PortReader(String domainXmlPath, String serverName) {
        this.serverName = serverName;
        this.parseDomainXML(domainXmlPath);
    }

    private void parseDomainXML(String domainXmlPath) {
        try {
            int i;
            File file = new File(domainXmlPath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            document.getDocumentElement().normalize();
            NodeList servers = document.getElementsByTagName("server");
            NodeList configs = document.getElementsByTagName("config");
            for (i = 0; i < servers.getLength(); ++i) {
                Element serverElement;
                String name;
                Node serverNode = servers.item(i);
                if (serverNode.getNodeType() != 1 || !(name = (serverElement = (Element)serverNode).getAttribute("name")).equals(this.serverName)) continue;
                this.serverConfigName = serverElement.getAttribute("config-ref");
            }
            for (i = 0; i < configs.getLength(); ++i) {
                Element configElement;
                String configName;
                Node configNode = configs.item(i);
                if (configNode.getNodeType() != 1 || !(configName = (configElement = (Element)configNode).getAttribute("name")).equals(this.serverConfigName)) continue;
                NodeList networkListeners = configElement.getElementsByTagName("network-listener");
                for (int j = 0; j < networkListeners.getLength(); ++j) {
                    Node networkListenerNode = networkListeners.item(j);
                    if (networkListenerNode.getNodeType() != 1) continue;
                    Element networkListenerElement = (Element)networkListenerNode;
                    String name = networkListenerElement.getAttribute("name");
                    int port = Integer.parseInt(networkListenerElement.getAttribute("port"));
                    if (name.equals("http-listener-1")) {
                        this.httpPort = port;
                        continue;
                    }
                    if (name.equals("http-listener-2")) {
                        this.httpsPort = port;
                        continue;
                    }
                    if (!name.equals("admin-listener")) continue;
                    this.adminPort = port;
                }
            }
        }
        catch (IOException | NumberFormatException | ParserConfigurationException | SAXException ex) {
            throw new IllegalStateException("Unable to parse domain.xml: " + ex.getMessage());
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public static void main(String[] args) {
        try {
            PortReader reader = new PortReader("path/to/domain.xml", "server-name");
            System.out.println("HTTP Port: " + reader.getHttpPort());
            System.out.println("HTTPS Port: " + reader.getHttpsPort());
            System.out.println("Admin Port: " + reader.getAdminPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

