/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.response;

import fish.payara.maven.plugins.server.response.Response;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class JsonResponse
implements Response {
    private final JSONObject body;
    private final Map<String, List<String>> headerFields;
    private final int code;

    public JsonResponse(String jsonString, int code, Map<String, List<String>> headerFields) {
        this.body = new JSONObject(jsonString);
        this.headerFields = headerFields;
        this.code = code;
    }

    @Override
    public boolean isExitCodeSuccess() {
        return "SUCCESS".equalsIgnoreCase(this.body.getString("exit_code"));
    }

    public String toString() {
        return this.body.getString("name") != null ? this.body.getString("name") : this.body.toString();
    }

    public JSONObject getJsonBody() {
        return this.body;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public int getCode() {
        return this.code;
    }
}

