/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class JavaUtils {
    private static final String JAVA_BIN_DIR = "bin";
    private static final String JAVA_VM_EXE = "java";
    private static final String JAVA_PROCESS_EXE = "jps";
    public static final String VM_CLASSPATH_OPTION = "-cp";
    private static final String VM_SYS_PROP_OPT = "-D";
    private static final String VM_SYS_PROP_QUOTE = "\"";
    private static final String VM_SYS_PROP_ASSIGN = "=";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final boolean IS_WIN = System.getProperty("os.name").toLowerCase().contains("win");

    public static String systemProperty(String name, String value) {
        return "-D\"" + name + VM_SYS_PROP_ASSIGN + value + VM_SYS_PROP_QUOTE;
    }

    public static String javaVmExecutableFullPath(String javaHome) {
        return JavaUtils.javaExecutableFullPath(javaHome, JAVA_VM_EXE);
    }

    public static String javaProcessExecutableFullPath(String javaHome) {
        return JavaUtils.javaExecutableFullPath(javaHome, JAVA_PROCESS_EXE);
    }

    private static String javaExecutableFullPath(String javaHome, String type) {
        Path javaHomePath = Paths.get(javaHome, new String[0]);
        Object javaExecStr = javaHomePath.toString();
        if (!((String)javaExecStr).endsWith(System.getProperty("file.separator"))) {
            javaExecStr = (String)javaExecStr + System.getProperty("file.separator");
        }
        javaExecStr = (String)javaExecStr + JAVA_BIN_DIR + System.getProperty("file.separator") + type;
        if (IS_WIN) {
            javaExecStr = (String)javaExecStr + ".exe";
        }
        return javaExecStr;
    }

    public static List<String> parseParameters(String args) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        int state = NULL;
        int slength = args.length();
        for (int i = 0; i < slength; ++i) {
            char c = args.charAt(i);
            if (Character.isWhitespace(c)) {
                if (state == NULL) {
                    if (buff.length() <= 0) continue;
                    params.add(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                if (state == STICK) {
                    params.add(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\\');
                    params.add(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    state = INPARAM;
                    buff.append('\\').append(c);
                    continue;
                }
                buff.append(c);
                continue;
            }
            if (c == '\\') {
                if (state == NULL) {
                    if (++i < slength) {
                        char cc = args.charAt(i);
                        if (cc == '\"' || cc == '\\') {
                            buff.append(cc);
                            continue;
                        }
                        if (Character.isWhitespace(cc)) {
                            buff.append(c);
                            --i;
                            continue;
                        }
                        buff.append(c).append(cc);
                        continue;
                    }
                    buff.append('\\');
                    break;
                }
                if (state == INPARAM) {
                    state = INPARAMPENDING;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                    continue;
                }
                if (state == STICK) {
                    state = STICKPENDING;
                    continue;
                }
                if (state != STICKPENDING) continue;
                buff.append('\\');
                state = STICK;
                continue;
            }
            if (c == '\"') {
                if (state == NULL) {
                    state = INPARAM;
                    continue;
                }
                if (state == INPARAM) {
                    state = STICK;
                    continue;
                }
                if (state == STICK) {
                    state = INPARAM;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\"');
                    state = STICK;
                    continue;
                }
                buff.append('\"');
                state = INPARAM;
                continue;
            }
            if (state == INPARAMPENDING) {
                buff.append('\\');
                state = INPARAM;
            } else if (state == STICKPENDING) {
                buff.append('\\');
                state = STICK;
            }
            buff.append(c);
        }
        if (state == INPARAM) {
            params.add(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.add(buff.toString());
        } else if (buff.length() > 0) {
            params.add(buff.toString());
        }
        return params;
    }

    public static void main(String[] args) {
        String javaHome = "/path/to/java/home";
        System.out.println("Java VM Full Path: " + JavaUtils.javaVmExecutableFullPath(javaHome));
        System.out.println("Java Process Full Path: " + JavaUtils.javaProcessExecutableFullPath(javaHome));
        System.out.println("System Property: " + JavaUtils.systemProperty("my.property", "value"));
        String commandLineArgs = "\"C:\\Program Files\\Java\\jdk1.8.0_171\\bin\\java\" -Dproperty=value -Xmx128m";
        List<String> parsedArgs = JavaUtils.parseParameters(commandLineArgs);
        for (String arg : parsedArgs) {
            System.out.println("Parsed Arg: " + arg);
        }
    }
}

