/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.utils;

import jakarta.xml.bind.DatatypeConverter;
import java.io.File;

public class ServerUtils {
    public static final String PF_JAVA_ROOT_PROPERTY = "com.sun.aas.javaRoot";
    public static final String PF_HOME_PROPERTY = "com.sun.aas.installRoot";
    public static final String PF_DOMAIN_ROOT_PROPERTY = "com.sun.aas.instanceRoot";
    public static final String PF_DERBY_ROOT_PROPERTY = "com.sun.aas.derbyRoot";
    public static final String PF_DOMAIN_ARG = "--domain";
    public static final String ASADMIN = "asadmin";
    public static final String STOP_DOMAIN = "stop-domain";
    public static final String PF_DOMAIN_DIR_ARG = "--domaindir";
    public static final String PF_MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "";
    public static final String MASTER_PASSWORD = "changeit";
    public static final int DEFAULT_ADMIN_PORT = 4848;
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DAS_NAME = "server";
    public static final int DEFAULT_RETRY_COUNT = 30;
    public static final int DEFAULT_WAIT = 3000;
    private static final String AUTH_BASIC_FIELD_SEPARATPR = ":";

    public static String cmdLineArgument(String name, String value) {
        return name + " " + value;
    }

    public static boolean isValidServerPath(String serverPath) {
        File asadminInGlassfish = new File(serverPath + "/glassfish/bin/asadmin");
        File asadminInBin = new File(serverPath + "/bin/asadmin");
        return asadminInGlassfish.exists() && asadminInBin.exists();
    }

    public static String basicAuthCredentials(String user, String password) {
        StringBuilder sb = new StringBuilder(user.length() + AUTH_BASIC_FIELD_SEPARATPR.length() + password.length());
        sb.append(user);
        sb.append(AUTH_BASIC_FIELD_SEPARATPR);
        sb.append(password);
        return DatatypeConverter.printBase64Binary((byte[])sb.toString().getBytes());
    }
}

