/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String PATTERN = "\\$\\{([^}]+)\\}";

    public static String quote(String path) {
        return path.indexOf(32) == -1 ? path : "\"" + path + "\"";
    }

    public static String doSub(String input, Map<String, String> varMap) {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String varName = matcher.group(1);
            String replacement = varMap.getOrDefault(varName, System.getProperty(varName, ""));
            input = input.replace("${" + varName + "}", StringUtils.escapePath(replacement));
        }
        return input;
    }

    public static String escapePath(String path) {
        return path.replace("\\", "\\\\").replace("$", "\\$");
    }
}

