/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.server.utils;

import java.io.File;

public class TempDirectoryResolver {
    public static File resolvePayaraTempDir(String payaraServerVersion) {
        File[] baseCandidates;
        for (File base : baseCandidates = new File[]{new File(System.getProperty("java.io.tmpdir")), new File(System.getProperty("user.home"), ".payara-tmp"), TempDirectoryResolver.getGlobalTempFallback()}) {
            File versioned = TempDirectoryResolver.tryCreateVersionedDir(base, "payara-server-" + payaraServerVersion);
            if (versioned == null) continue;
            return versioned;
        }
        throw new RuntimeException("No writable temp directory could be created.");
    }

    private static File tryCreateVersionedDir(File baseDir, String versionedName) {
        System.out.println("base dir " + baseDir);
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            return null;
        }
        if (baseDir.canWrite()) {
            File versionedDir = new File(baseDir, versionedName);
            if (!versionedDir.exists() && !versionedDir.mkdirs()) {
                return null;
            }
            return versionedDir;
        }
        return null;
    }

    private static File getGlobalTempFallback() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String winTmp = System.getenv("TEMP");
            if (winTmp != null && !winTmp.isEmpty()) {
                return new File(winTmp, "payara-global-tmp");
            }
            return new File("C:\\Temp\\payara-global-tmp");
        }
        return new File("/tmp/payara-global-tmp");
    }
}

