/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.collect;

import fish.payara.monitoring.collect.MonitoringDataCollector;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public final class MonitoringDataCollection {
    private static final Map<Class<?>, BiConsumer<MonitoringDataCollector, ?>> MAPPED_TYPES = new ConcurrentHashMap();

    private MonitoringDataCollection() {
        throw new UnsupportedOperationException("util");
    }

    public static <T> void register(Class<T> type, BiConsumer<MonitoringDataCollector, T> collectWith) {
        MAPPED_TYPES.putIfAbsent(type, collectWith);
    }

    public static void collectObject(MonitoringDataCollector collector, Object obj) {
        for (Method getter : obj.getClass().getMethods()) {
            if (!MonitoringDataCollection.isGetter(getter)) continue;
            try {
                Object value = getter.invoke(obj, new Object[0]);
                Class<?> returnType = getter.getReturnType();
                if (MAPPED_TYPES.containsKey(returnType)) {
                    MonitoringDataCollection.collectMapped(collector, returnType, value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                collector.collect((CharSequence)MonitoringDataCollection.name(getter), (Number)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isGetter(Method method) {
        return method.getParameterCount() == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is"));
    }

    private static String name(Method method) {
        String name = method.getName();
        return name.startsWith("get") ? name.substring(3) : name.substring(2);
    }

    private static <T> void collectMapped(MonitoringDataCollector collector, Class<T> type, Object value) {
        collector.collectObject(value, MAPPED_TYPES.get(type));
    }
}

