/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.internal.util;

import fish.payara.monitoring.adapt.MonitoringConsoleRuntime;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JobHandle {
    protected static final Logger LOGGER = Logger.getLogger(JobHandle.class.getName());
    private final AtomicReference<ScheduledFuture<?>> job = new AtomicReference();
    private final String description;

    public JobHandle(String description) {
        this.description = description;
    }

    public void start(MonitoringConsoleRuntime executor, int time, TimeUnit unit, Runnable work) {
        ScheduledFuture task;
        if (this.job.get() == null && !this.job.compareAndSet(null, task = executor.scheduleAtFixedRate(work, 0L, (long)time, unit))) {
            JobHandle.cancelTask(task, this.description);
        }
    }

    public void stop() {
        JobHandle.cancelTask(this.job.getAndUpdate(job -> null), this.description);
    }

    private static void cancelTask(ScheduledFuture<?> task, String description) {
        if (task != null) {
            LOGGER.info("Stopping " + description + ".");
            try {
                task.cancel(false);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to cancel " + description + ".", e);
            }
        }
    }

    public String toString() {
        return JobHandle.class.getSimpleName() + " for " + this.description;
    }
}

