/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.AggregateDataset;
import fish.payara.monitoring.model.HoursDataset;
import fish.payara.monitoring.model.SeriesDataset;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;

public final class MinutesDataset
extends AggregateDataset<MinutesDataset> {
    private static final int MINUTES_PER_HOUR = 60;
    private static final long MILLIS_IN_ONE_MINUTE = Duration.ofMinutes(1L).toMillis();
    public static final MinutesDataset EMPTY = new MinutesDataset();
    private final HoursDataset recentHours;

    private MinutesDataset() {
        this.recentHours = HoursDataset.EMPTY;
    }

    private MinutesDataset(MinutesDataset predecessor, SeriesDataset minute) {
        super(60, predecessor, MinutesDataset.atStartOfMinute(minute.lastTime()));
        this.aggregate(minute);
        this.recentHours = predecessor.recentHours.add(this);
    }

    private static long atStartOfMinute(long time) {
        return Instant.ofEpochMilli(time).atOffset(ZoneOffset.UTC).withNano(0).withSecond(0).toInstant().toEpochMilli();
    }

    public HoursDataset getRecentHours() {
        return this.recentHours;
    }

    public MinutesDataset add(SeriesDataset minute) {
        if (!minute.endsWithLastSecondOfMinute()) {
            return this;
        }
        return new MinutesDataset(this, minute);
    }

    private void aggregate(SeriesDataset minute) {
        long[] points = minute.points();
        int numberOfPointsInAggregate = points.length / 2;
        long min = points[1];
        long max = points[1];
        BigInteger avg = BigInteger.valueOf(points[1]);
        for (int i = 3; i < points.length; i += 2) {
            long val = points[i];
            min = Math.min(min, val);
            max = Math.max(max, val);
            avg = avg.add(BigInteger.valueOf(val));
        }
        this.setEntry(numberOfPointsInAggregate, min, max, new BigDecimal(avg).divide(BigDecimal.valueOf(numberOfPointsInAggregate), 1).doubleValue());
    }

    public boolean endsWithLastMinuteOfHour() {
        return this.isEmpty() ? false : Instant.ofEpochMilli(this.lastTime()).atOffset(ZoneOffset.UTC).getMinute() == 59;
    }

    @Override
    public long getIntervalLength() {
        return MILLIS_IN_ONE_MINUTE;
    }
}

