/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.AggregateDataset;
import fish.payara.monitoring.model.HoursDataset;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;

public final class DaysDataset
extends AggregateDataset<DaysDataset> {
    private static final int DAYS_PER_MONTH = 31;
    private static final long MILLIS_IN_ONE_DAY = Duration.ofDays(1L).toMillis();
    public static final DaysDataset EMPTY = new DaysDataset();

    private DaysDataset() {
    }

    private DaysDataset(DaysDataset predecessor, HoursDataset day) {
        super(31, predecessor, DaysDataset.atStartOfDay(day.lastTime()));
        this.aggregate(day);
    }

    public static long atStartOfDay(long time) {
        return Instant.ofEpochMilli(time).atOffset(ZoneOffset.UTC).withNano(0).withSecond(0).withMinute(0).withHour(0).toInstant().toEpochMilli();
    }

    public DaysDataset add(HoursDataset day) {
        if (!day.endsWithLastHourOfDay()) {
            return this;
        }
        return new DaysDataset(this, day);
    }

    private void aggregate(HoursDataset day) {
        int numberOfHoursInAggregate = day.size();
        int firstHourOfDay = day.offset;
        int lastHourOfDay = Math.min(23, firstHourOfDay + numberOfHoursInAggregate);
        int points = day.getNumberOfPoints(firstHourOfDay);
        long min = day.getMinimum(firstHourOfDay);
        long max = day.getMaximum(firstHourOfDay);
        BigDecimal avg = BigDecimal.valueOf(day.getAverage(firstHourOfDay));
        for (int i = firstHourOfDay + 1; i <= lastHourOfDay; ++i) {
            points += day.getNumberOfPoints(i);
            min = Math.min(min, day.getMinimum(i));
            max = Math.max(max, day.getMaximum(i));
            avg = avg.add(BigDecimal.valueOf(day.getAverage(i)));
        }
        this.setEntry(points, min, max, avg.divide(BigDecimal.valueOf(numberOfHoursInAggregate), 1).doubleValue());
    }

    public boolean endsWithLastDayOfMonth() {
        if (this.isEmpty()) {
            return false;
        }
        OffsetDateTime time = Instant.ofEpochMilli(this.getTime(this.lastIndex())).atOffset(ZoneOffset.UTC);
        return time.getDayOfMonth() == time.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
    }

    @Override
    public long getIntervalLength() {
        return MILLIS_IN_ONE_DAY;
    }
}

