/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.SeriesAnnotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class SeriesAnnotations
implements Iterable<SeriesAnnotation> {
    private final int capacity;
    private final Queue<SeriesAnnotation> annotations = new ConcurrentLinkedQueue<SeriesAnnotation>();

    public SeriesAnnotations(int capacity) {
        this.capacity = capacity;
    }

    public void add(SeriesAnnotation annotation) {
        if (annotation.isKeyed()) {
            this.annotations.removeIf(a -> Objects.equals(a.getKeyAttribute(), annotation.getKeyAttribute()));
        }
        this.annotations.add(annotation);
        if (this.annotations.size() > this.capacity) {
            SeriesAnnotation removed = this.annotations.poll();
            for (int attempts = 1; attempts < this.capacity && removed != null && removed.isPermanent(); ++attempts) {
                this.annotations.add(removed);
                removed = this.annotations.poll();
            }
        }
    }

    @Override
    public Iterator<SeriesAnnotation> iterator() {
        return this.annotations.iterator();
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    public Stream<SeriesAnnotation> stream() {
        return StreamSupport.stream(this.annotations.spliterator(), false);
    }

    public List<SeriesAnnotation> toList() {
        return new ArrayList<SeriesAnnotation>(this.annotations);
    }

    public boolean equals(Object obj) {
        return obj instanceof SeriesAnnotations && this.annotations.equals(((SeriesAnnotations)obj).annotations);
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    public String toString() {
        return this.annotations.toString();
    }

    public int size() {
        return this.annotations.size();
    }
}

