/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.web;

import fish.payara.monitoring.adapt.GroupData;
import fish.payara.monitoring.adapt.GroupDataRepository;
import fish.payara.monitoring.adapt.MonitoringConsole;
import fish.payara.monitoring.adapt.MonitoringConsoleFactory;
import fish.payara.monitoring.adapt.MonitoringConsolePageConfig;
import fish.payara.monitoring.alert.Alert;
import fish.payara.monitoring.alert.AlertService;
import fish.payara.monitoring.alert.Circumstance;
import fish.payara.monitoring.alert.Condition;
import fish.payara.monitoring.alert.Watch;
import fish.payara.monitoring.data.SeriesRepository;
import fish.payara.monitoring.model.Metric;
import fish.payara.monitoring.model.Series;
import fish.payara.monitoring.web.ApiRequests;
import fish.payara.monitoring.web.ApiResponses;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
@Produces(value={"application/json"})
@RequestScoped
public class MonitoringConsoleResource {
    private static final Logger LOGGER = Logger.getLogger(MonitoringConsoleResource.class.getName());
    private SeriesRepository dataRepository;
    private AlertService alertService;
    private GroupDataRepository groupDataRepository;
    private MonitoringConsolePageConfig pageConfig;

    @PostConstruct
    private void init() {
        MonitoringConsoleFactory facory;
        Iterator<MonitoringConsoleFactory> iter = ServiceLoader.load(MonitoringConsoleFactory.class, Thread.currentThread().getContextClassLoader()).iterator();
        MonitoringConsoleFactory monitoringConsoleFactory = facory = iter.hasNext() ? iter.next() : null;
        if (facory != null) {
            MonitoringConsole console = facory.getCreatedConsole();
            this.dataRepository = (SeriesRepository)console.getService(SeriesRepository.class);
            this.alertService = (AlertService)console.getService(AlertService.class);
            this.groupDataRepository = (GroupDataRepository)console.getService(GroupDataRepository.class);
            this.pageConfig = (MonitoringConsolePageConfig)console.getService(MonitoringConsolePageConfig.class);
        } else {
            LOGGER.log(Level.WARNING, "No MonitoringConsoleFactory defined using ServiceLoader mechanism.");
        }
    }

    private static Series seriesOrNull(String series) {
        try {
            return new Series(series);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.FINE, "Failed to parse series", e);
            return null;
        }
    }

    @GET
    @Path(value="/pages/")
    public String[] getPageNames() {
        return (String[])StreamSupport.stream(this.pageConfig.listPages().spliterator(), false).sorted().toArray(String[]::new);
    }

    @GET
    @Path(value="/pages/data/")
    public JsonObject getPageData() {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        for (String name : this.pageConfig.listPages()) {
            String page = this.pageConfig.getPage(name);
            if (page == null || page.isEmpty()) continue;
            JsonParser parser = Json.createParser((Reader)new StringReader(page));
            Throwable throwable = null;
            try {
                if (!parser.hasNext()) continue;
                parser.next();
                obj.add(name, (JsonValue)parser.getObject());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (parser == null) continue;
                if (throwable != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                parser.close();
            }
        }
        return obj.build();
    }

    @GET
    @Path(value="/pages/data/{name}/")
    public String getPageData(@PathParam(value="name") String name) {
        return this.pageConfig.getPage(name);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/pages/data/{name}/")
    public Response updatePage(@PathParam(value="name") String name, String json) {
        if (name == null || name.isEmpty()) {
            return MonitoringConsoleResource.badRequest((String)"Name missing");
        }
        if (json == null || json.isEmpty() || "{}".equals(json)) {
            return this.deletePage(name);
        }
        this.pageConfig.putPage(name, json);
        return MonitoringConsoleResource.noContent();
    }

    @DELETE
    @Path(value="/pages/data/{name}/")
    public Response deletePage(@PathParam(value="name") String name) {
        if (this.pageConfig.existsPage(name)) {
            this.pageConfig.removePage(name);
        }
        return MonitoringConsoleResource.noContent();
    }

    @GET
    @Path(value="/annotations/data/{series}/")
    public List<ApiResponses.AnnotationData> getAnnotationsData(@PathParam(value="series") String series) {
        Series key = MonitoringConsoleResource.seriesOrNull((String)series);
        return key == null ? Collections.emptyList() : this.dataRepository.selectAnnotations(key, new String[0]).stream().map(ApiResponses.AnnotationData::new).collect(Collectors.toList());
    }

    @GET
    @Path(value="/series/data/{series}/")
    public ApiResponses.SeriesResponse getSeriesData(@PathParam(value="series") String series) {
        return this.getSeriesData(new ApiRequests.SeriesRequest(series));
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/series/data/")
    public ApiResponses.SeriesResponse getSeriesData(ApiRequests.SeriesRequest request) {
        ArrayList<ApiResponses.SeriesMatch> matches = new ArrayList<ApiResponses.SeriesMatch>(request.queries.length);
        for (ApiRequests.SeriesQuery query : request.queries) {
            Series key = MonitoringConsoleResource.seriesOrNull((String)query.series);
            List queryData = key == null || query.excludes(ApiRequests.DataType.POINTS) ? Collections.emptyList() : this.dataRepository.selectSeries(key, query.instances);
            List queryAnnotations = key == null || query.excludes(ApiRequests.DataType.ANNOTATIONS) ? Collections.emptyList() : this.dataRepository.selectAnnotations(key, query.instances);
            List queryWatches = key == null || query.excludes(ApiRequests.DataType.WATCHES) ? Collections.emptyList() : this.alertService.wachtesFor(key);
            List queryAlerts = key == null || query.excludes(ApiRequests.DataType.ALERTS) ? Collections.emptyList() : this.alertService.alertsFor(key);
            matches.add(new ApiResponses.SeriesMatch(query, query.series, queryData, queryAnnotations, queryWatches, queryAlerts));
        }
        if (request.groupBySeries) {
            return this.getGroupedSeriesData(matches);
        }
        return new ApiResponses.SeriesResponse(matches, this.alertService.getAlertStatistics());
    }

    private ApiResponses.SeriesResponse getGroupedSeriesData(List<ApiResponses.SeriesMatch> matches) {
        HashMap<String, List> dataBySeries = new HashMap<String, List>();
        HashMap annotationsBySeries = new HashMap();
        HashMap watchesBySeries = new HashMap();
        HashMap alertsBySeries = new HashMap();
        for (ApiResponses.SeriesMatch match : matches) {
            for (ApiResponses.SeriesData data : match.data) {
                dataBySeries.computeIfAbsent(data.series, key -> new ArrayList()).add(data);
            }
            for (ApiResponses.AnnotationData annotation : match.annotations) {
                annotationsBySeries.computeIfAbsent(annotation.series, key -> new ArrayList()).add(annotation);
            }
            for (ApiResponses.WatchData watch : match.watches) {
                watchesBySeries.computeIfAbsent(watch.series, key -> new ArrayList()).add(watch);
            }
            for (ApiResponses.AlertData alert : match.alerts) {
                alertsBySeries.computeIfAbsent(alert.series, key -> new ArrayList()).add(alert);
            }
        }
        ArrayList<ApiResponses.SeriesMatch> matchesBySeries = new ArrayList<ApiResponses.SeriesMatch>();
        for (Map.Entry e : dataBySeries.entrySet()) {
            String series = (String)e.getKey();
            matchesBySeries.add(new ApiResponses.SeriesMatch(series, (List)e.getValue(), annotationsBySeries.getOrDefault(series, Collections.emptyList()), watchesBySeries.getOrDefault(series, Collections.emptyList()), alertsBySeries.getOrDefault(series, Collections.emptyList())));
        }
        return new ApiResponses.SeriesResponse(matchesBySeries, this.alertService.getAlertStatistics());
    }

    @GET
    @Path(value="/series/")
    public String[] getSeriesNames() {
        return (String[])StreamSupport.stream(this.dataRepository.selectAllSeries().spliterator(), false).map(dataset -> dataset.getSeries().toString()).sorted().toArray(String[]::new);
    }

    @GET
    @Path(value="/instances/")
    public String[] getInstanceNames() {
        return this.dataRepository.instances().toArray(new String[0]);
    }

    @GET
    @Path(value="/trace/data/{series}/")
    public List<ApiResponses.RequestTraceResponse> getTraceData(@PathParam(value="series") String series) {
        String group = series.split(" ")[1].substring(2);
        ArrayList<ApiResponses.RequestTraceResponse> response = new ArrayList<ApiResponses.RequestTraceResponse>();
        for (GroupData trace : this.groupDataRepository.selectAll("requesttracing", group)) {
            response.add(new ApiResponses.RequestTraceResponse(trace));
        }
        return response;
    }

    @GET
    @Path(value="/alerts/data/")
    public ApiResponses.AlertsResponse getAlertsData() {
        return new ApiResponses.AlertsResponse(this.alertService.alerts());
    }

    @GET
    @Path(value="/alerts/data/{series}/")
    public ApiResponses.AlertsResponse getAlertsData(@PathParam(value="series") String seriesOrSerial) {
        if (seriesOrSerial.matches("\\d+")) {
            Alert alert = this.alertService.alertBySerial(Integer.parseInt(seriesOrSerial));
            return new ApiResponses.AlertsResponse(alert == null ? Collections.emptyList() : Collections.singletonList(alert));
        }
        return new ApiResponses.AlertsResponse(this.alertService.alertsFor(MonitoringConsoleResource.seriesOrNull((String)seriesOrSerial)));
    }

    @POST
    @Path(value="/alerts/ack/{serial}")
    public void acknowledgeAlert(@PathParam(value="serial") int serial) {
        Alert alert = this.alertService.alertBySerial(serial);
        if (alert != null) {
            alert.acknowledge();
        }
    }

    @GET
    @Path(value="/watches/data/")
    public ApiResponses.WatchesResponse getWatchesData() {
        return new ApiResponses.WatchesResponse(this.alertService.watches());
    }

    @DELETE
    @Path(value="/watches/data/{name}/")
    public Response deleteWatch(@PathParam(value="name") String name) {
        Watch watch = this.alertService.watchByName(name);
        if (watch != null) {
            this.alertService.removeWatch(watch);
        }
        return MonitoringConsoleResource.noContent();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/watches/data/")
    public Response createWatch(ApiResponses.WatchData data) {
        if (data.name == null || data.name.isEmpty()) {
            return MonitoringConsoleResource.badRequest((String)"Name missing");
        }
        Circumstance red = MonitoringConsoleResource.createCircumstance((ApiResponses.CircumstanceData)data.red);
        Circumstance amber = MonitoringConsoleResource.createCircumstance((ApiResponses.CircumstanceData)data.amber);
        Circumstance green = MonitoringConsoleResource.createCircumstance((ApiResponses.CircumstanceData)data.green);
        if (red.start.isNone() && amber.start.isNone()) {
            return MonitoringConsoleResource.badRequest((String)"A start condition for red or amber must be given");
        }
        Metric metric = Metric.parse((String)data.series, (String)data.unit);
        Watch watch = new Watch(data.name, metric, false, red, amber, green, new Metric[0]);
        this.alertService.addWatch(watch);
        return MonitoringConsoleResource.noContent();
    }

    @PATCH
    @Path(value="/watches/data/{name}/")
    public Response patchWatch(@PathParam(value="name") String name, @QueryParam(value="disable") boolean disable) {
        return this.alertService.toggleWatch(name, disable) ? MonitoringConsoleResource.noContent() : MonitoringConsoleResource.notFound();
    }

    private static Circumstance createCircumstance(ApiResponses.CircumstanceData data) {
        if (data == null) {
            return Circumstance.UNSPECIFIED;
        }
        Circumstance res = new Circumstance(Alert.Level.parse((String)data.level), MonitoringConsoleResource.createCondition((ApiResponses.ConditionData)data.start), MonitoringConsoleResource.createCondition((ApiResponses.ConditionData)data.stop));
        if (data.suppress != null) {
            res = res.suppressedWhen(Metric.parse((String)data.surpressingSeries, (String)data.surpressingUnit), MonitoringConsoleResource.createCondition((ApiResponses.ConditionData)data.suppress));
        }
        return res;
    }

    private static Condition createCondition(ApiResponses.ConditionData data) {
        if (data == null) {
            return Condition.NONE;
        }
        Condition res = new Condition(Condition.Operator.parse((String)data.operator), data.threshold);
        if (data.forMillis != null) {
            res = res.forLastMillis(data.forMillis.longValue());
        }
        if (data.forTimes != null) {
            res = res.forLastTimes(data.forTimes.intValue());
        }
        if (data.onAverage) {
            res = res.onAverage();
        }
        return res;
    }

    private static Response badRequest(String reason) {
        return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)reason).build();
    }

    private static Response noContent() {
        return Response.noContent().build();
    }

    private static Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

