/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.jakarta.JakartaTransformer;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class TransformMojo
extends AbstractMojo {
    private static final String OUTPUT_PREFIX = "output_";
    private static final String TARGET_AS_ORIGIN = "transformed";
    private static final String SELECTED_SOURCE = "selectedSource";
    private static final String SELECTED_TARGET = "selectedTarget";
    private static final Logger log = Logger.getLogger(TransformMojo.class.getName());
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="transformer-plugin.invert", required=true)
    private Boolean invert;
    @Parameter(defaultValue="true", property="transformer-plugin.overwrite", required=true)
    private Boolean overwrite;
    @Parameter(defaultValue="true", property="transformer-plugin.mainSource", required=true)
    private Boolean mainSource;
    @Parameter(defaultValue="true", property="transformer-plugin.testSource", required=true)
    private Boolean testSource;
    @Parameter(property="transformer-plugin.renames", defaultValue="")
    private String rulesRenamesUri;
    @Parameter(property="transformer-plugin.versions", defaultValue="")
    private String rulesVersionUri;
    @Parameter(property="transformer-plugin.bundles", defaultValue="")
    private String rulesBundlesUri;
    @Parameter(property="transformer-plugin.direct", defaultValue="")
    private String rulesDirectUri;
    @Parameter(property="transformer-plugin.per-class-constant", defaultValue="")
    private String rulesPerClassConstantUri;
    @Parameter(property="transformer-plugin.selectedSource", defaultValue="")
    private String selectedSource;
    @Parameter(property="transformer-plugin.selectedTarget", defaultValue="")
    private String selectedTarget;
    @Parameter(property="transformer-plugin.xml", defaultValue="")
    private String rulesXmlsUri;
    @Parameter(defaultValue="transformed")
    private String classifier;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoFailureException {
        Transformer transformer = this.getTransformer();
        if (this.mainSource.booleanValue()) {
            Artifact[] sourceArtifacts;
            for (Artifact sourceArtifact : sourceArtifacts = this.getSourceArtifacts()) {
                this.transform(transformer, sourceArtifact);
            }
        }
        if (this.testSource.booleanValue()) {
            File testDirectory = this.getTestDirectory();
            if (testDirectory.exists()) {
                this.transform(transformer, testDirectory);
            }
            this.transform(transformer, Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]).toFile());
        }
    }

    public void transform(Transformer transformer, Artifact sourceArtifact) throws MojoFailureException {
        String sourceClassifier = sourceArtifact.getClassifier();
        String targetClassifier = sourceClassifier == null || sourceClassifier.length() == 0 ? this.classifier : sourceClassifier + "-" + this.classifier;
        File targetFile = new File(this.outputDirectory, sourceArtifact.getArtifactId() + "-" + targetClassifier + "-" + sourceArtifact.getVersion() + "." + sourceArtifact.getType());
        log.info("Processing custom parameters for source and target file");
        List<String> args = this.processCustomParameters(sourceArtifact.getFile().getAbsolutePath(), targetFile.getAbsolutePath());
        transformer.setArgs(args.toArray(new String[0]));
        log.info("configured Args:" + args);
        int rc = transformer.run();
        if (rc != 0) {
            throw new MojoFailureException("Transformer failed with an error: " + Transformer.RC_DESCRIPTIONS[rc]);
        }
        if (TARGET_AS_ORIGIN.equals(this.classifier) && !this.isSourceAndTargetAvailable()) {
            try {
                if (sourceArtifact.getFile().isDirectory()) {
                    FileUtils.deleteDirectory((File)sourceArtifact.getFile());
                } else {
                    targetFile.delete();
                }
                targetFile.renameTo(sourceArtifact.getFile());
            }
            catch (IOException ex) {
                throw new MojoFailureException("Transformer failed", (Throwable)ex);
            }
        } else {
            this.projectHelper.attachArtifact(this.project, sourceArtifact.getType(), targetClassifier, targetFile);
        }
    }

    private List<String> processCustomParameters(String sourcePath, String targetPath) {
        Properties properties = System.getProperties();
        ArrayList<String> args = new ArrayList<String>();
        this.selectedSource = properties.getProperty(SELECTED_SOURCE);
        if (this.selectedSource != null && !this.selectedSource.isEmpty()) {
            log.info("setting custom source file:" + this.selectedSource);
            args.add(this.selectedSource);
            this.selectedTarget = properties.getProperty(SELECTED_TARGET);
            if (this.selectedTarget != null && !this.selectedTarget.isEmpty()) {
                log.info("setting custom target file:" + this.selectedTarget);
                if (!Files.isDirectory(Paths.get(this.selectedSource, new String[0]), new LinkOption[0]) && Files.isDirectory(Paths.get(this.selectedTarget, new String[0]), new LinkOption[0])) {
                    String fileName = Paths.get(this.selectedSource, new String[0]).getFileName().toString();
                    String newFileName = this.selectedTarget + FileSystems.getDefault().getSeparator() + OUTPUT_PREFIX + fileName;
                    args.add(newFileName);
                } else {
                    args.add(this.selectedTarget);
                }
            }
            if (this.overwrite.booleanValue()) {
                args.add("-o");
            }
            if (this.invert.booleanValue()) {
                args.add("-i");
            }
        } else {
            args.add(sourcePath);
            args.add(targetPath);
            if (this.overwrite.booleanValue()) {
                args.add("-o");
            }
            if (this.invert.booleanValue()) {
                args.add("-i");
            }
        }
        return args;
    }

    public void transform(Transformer transformer, File source) throws MojoFailureException {
        String targetClassifier = this.classifier;
        File targetDirectory = new File(source + "-" + targetClassifier);
        log.info("Processing custom parameters for source and target file");
        List<String> args = this.processCustomParameters(source.getAbsolutePath(), targetDirectory.getAbsolutePath());
        transformer.setArgs(args.toArray(new String[0]));
        int rc = transformer.run();
        if (TARGET_AS_ORIGIN.equals(this.classifier) && !this.isSourceAndTargetAvailable()) {
            try {
                if (source.isDirectory()) {
                    FileUtils.deleteDirectory((File)source);
                } else {
                    source.delete();
                }
                targetDirectory.renameTo(source);
            }
            catch (IOException ex) {
                throw new MojoFailureException("Transformer failed", (Throwable)ex);
            }
        }
        if (rc != 0) {
            throw new MojoFailureException("Transformer failed with an error: " + Transformer.RC_DESCRIPTIONS[rc]);
        }
    }

    private boolean isSourceAndTargetAvailable() {
        Properties properties = System.getProperties();
        String selectedSource = properties.getProperty(SELECTED_SOURCE);
        String selectedTarget = properties.getProperty(SELECTED_TARGET);
        return selectedSource != null && selectedTarget != null;
    }

    public Transformer getTransformer() {
        Transformer transformer = new Transformer(System.out, System.err);
        transformer.setOptionDefaults(JakartaTransformer.class, this.getOptionDefaults());
        return transformer;
    }

    public Artifact[] getSourceArtifacts() {
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null) {
            artifactList.add(this.project.getArtifact());
        }
        for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
            if (attachedArtifact.getFile() == null) continue;
            artifactList.add(attachedArtifact);
        }
        return artifactList.toArray(new Artifact[0]);
    }

    public File getTestDirectory() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    private Map<Transformer.AppOption, String> getOptionDefaults() {
        HashMap<Transformer.AppOption, String> optionDefaults = new HashMap<Transformer.AppOption, String>();
        optionDefaults.put(Transformer.AppOption.RULES_RENAMES, this.isEmpty(this.rulesRenamesUri) ? "jakarta-renames.properties" : this.rulesRenamesUri);
        optionDefaults.put(Transformer.AppOption.RULES_VERSIONS, this.isEmpty(this.rulesVersionUri) ? "jakarta-versions.properties" : this.rulesVersionUri);
        optionDefaults.put(Transformer.AppOption.RULES_BUNDLES, this.isEmpty(this.rulesBundlesUri) ? "jakarta-bundles.properties" : this.rulesBundlesUri);
        optionDefaults.put(Transformer.AppOption.RULES_DIRECT, this.isEmpty(this.rulesDirectUri) ? "jakarta-direct.properties" : this.rulesDirectUri);
        optionDefaults.put(Transformer.AppOption.RULES_MASTER_TEXT, this.isEmpty(this.rulesXmlsUri) ? "jakarta-text-master.properties" : this.rulesXmlsUri);
        optionDefaults.put(Transformer.AppOption.RULES_PER_CLASS_CONSTANT, this.isEmpty(this.rulesPerClassConstantUri) ? "jakarta-per-class-constant-master.properties" : this.rulesPerClassConstantUri);
        return optionDefaults;
    }

    private boolean isEmpty(String input) {
        return input == null || input.trim().length() == 0;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setInvert(Boolean invert) {
        this.invert = invert;
    }

    void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setSelectedSource(String selectedSource) {
        this.selectedSource = selectedSource;
    }

    public void setSelectedTarget(String selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public String getSelectedSource() {
        return this.selectedSource;
    }

    public String getSelectedTarget() {
        return this.selectedTarget;
    }

    public void setMainSource(Boolean mainSource) {
        this.mainSource = mainSource;
    }

    public Boolean getMainSource() {
        return this.mainSource;
    }

    public Boolean getTestSource() {
        return this.testSource;
    }

    public void setTestSource(Boolean testSource) {
        this.testSource = testSource;
    }
}

