/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferInputStream;
import aQute.lib.io.ByteBufferOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlActionImpl
extends ActionImpl {
    static final boolean XML_AS_PLAIN_TEXT;
    private static final SAXParserFactory parserFactory;

    public XmlActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public String getName() {
        return "XML Action";
    }

    @Override
    public ActionType getActionType() {
        return null;
    }

    @Override
    public String getAcceptExtension() {
        return ".xml";
    }

    @Override
    public boolean accept(String resourceName, File resourceFile) {
        return resourceName.toLowerCase().endsWith(this.getAcceptExtension()) && this.signatureRule.getTextSubstitutions(resourceName) != null;
    }

    @Override
    public ByteData apply(String inputName, byte[] inputBytes, int inputCount) throws TransformException {
        if (XML_AS_PLAIN_TEXT) {
            return this.applyAsPlainText(inputName, inputBytes, inputCount);
        }
        this.setResourceNames(inputName, inputName);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBytes, 0, inputCount);
        ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputCount);
        this.transformUsingSaxParser(inputName, inputStream, outputStream);
        if (!this.hasNonResourceNameChanges()) {
            return null;
        }
        byte[] outputBytes = outputStream.toByteArray();
        return new ByteData(inputName, outputBytes, 0, outputBytes.length);
    }

    public ByteData applyAsPlainText(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        String outputName = inputName;
        this.setResourceNames(inputName, outputName);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBytes, 0, inputLength);
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(inputReader);
        ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputBytes.length);
        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        BufferedWriter writer = new BufferedWriter(outputWriter);
        try {
            this.transformAsPlainText(inputName, reader, writer);
        }
        catch (IOException e) {
            this.error("Failed to transform [ {} ]", e, inputName);
            return null;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            this.error("Failed to flush [ {} ]", e, inputName);
            return null;
        }
        if (!this.hasNonResourceNameChanges()) {
            return null;
        }
        byte[] outputBytes = outputStream.toByteArray();
        return new ByteData(inputName, outputBytes, 0, outputBytes.length);
    }

    public static SAXParserFactory getParserFactory() {
        return parserFactory;
    }

    public void transform(String inputName, InputStream input, OutputStream output) throws TransformException {
        SAXParser parser;
        InputSource inputSource = new InputSource(input);
        inputSource.setEncoding(StandardCharsets.UTF_8.name());
        XMLContentHandler handler = new XMLContentHandler(inputName, inputSource, output);
        try {
            parser = XmlActionImpl.getParserFactory().newSAXParser();
        }
        catch (Exception e) {
            throw new TransformException("Failed to obtain parser for [ " + inputName + " ]", e);
        }
        try {
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new TransformException("Failed to parse [ " + inputName + " ]", e);
        }
    }

    public void transformUsingSaxParser(String inputName, InputStream input, OutputStream output) throws TransformException {
        SAXParser parser;
        InputSource inputSource = new InputSource(input);
        inputSource.setEncoding(StandardCharsets.UTF_8.name());
        XMLContentHandler handler = new XMLContentHandler(inputName, inputSource, output);
        try {
            parser = XmlActionImpl.getParserFactory().newSAXParser();
        }
        catch (Exception e) {
            throw new TransformException("Failed to obtain parser for [ " + inputName + " ]", e);
        }
        try {
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new TransformException("Failed to parse [ " + inputName + " ]", e);
        }
    }

    protected void transformAsPlainText(String inputName, BufferedReader reader, BufferedWriter writer) throws IOException {
        String inputLine;
        while ((inputLine = reader.readLine()) != null) {
            String outputLine = this.replaceText(inputName, inputLine);
            if (outputLine == null) {
                outputLine = inputLine;
            } else {
                this.addReplacement();
            }
            writer.write(outputLine);
            writer.write(10);
        }
    }

    static {
        String value = System.getProperty("XML_AS_PLAIN_TEXT", "true");
        XML_AS_PLAIN_TEXT = Boolean.valueOf(value);
        parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
    }

    public class XMLContentHandler
    extends DefaultHandler {
        private final String inputName;
        private final String publicId;
        private final String systemId;
        private Charset charset;
        private final OutputStream outputStream;
        private final StringBuilder lineBuilder;

        public XMLContentHandler(String inputName, InputSource inputSource, OutputStream outputStream) {
            this.inputName = inputName;
            this.charset = Charset.forName(inputSource.getEncoding());
            this.publicId = inputSource.getPublicId();
            this.systemId = inputSource.getSystemId();
            this.outputStream = outputStream;
            this.lineBuilder = new StringBuilder();
        }

        public String getInputName() {
            return this.inputName;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        public void write(String text) throws SAXException {
            this.write(text, this.getCharset());
        }

        public void writeUTF8(String text) throws SAXException {
            this.write(text, StandardCharsets.UTF_8);
        }

        public void write(String text, Charset useCharset) throws SAXException {
            try {
                this.outputStream.write(text.getBytes(useCharset));
            }
            catch (IOException e) {
                throw new SAXException("Failed to write [ " + text + " ]", e);
            }
        }

        protected void appendLine() {
            this.lineBuilder.append('\n');
        }

        protected void append(char c) {
            this.lineBuilder.append(c);
        }

        protected void append(char[] buffer, int start, int length) {
            for (int trav = start; trav < start + length; ++trav) {
                this.lineBuilder.append(buffer[trav]);
            }
        }

        protected void appendLine(char c) {
            this.lineBuilder.append(c);
            this.lineBuilder.append('\n');
        }

        protected void append(String text) {
            XmlActionImpl.this.debug("appending [" + text + "]", new Object[0]);
            this.lineBuilder.append(text);
        }

        protected void appendLine(String text) {
            XmlActionImpl.this.debug("appendline[" + text + "]", new Object[0]);
            this.lineBuilder.append(text);
            this.lineBuilder.append('\n');
        }

        protected void emit() throws SAXException {
            String nextLine = this.lineBuilder.toString();
            this.lineBuilder.setLength(0);
            this.write(nextLine);
        }

        protected void emitLineUTF8(String text) throws SAXException {
            String nextLine = this.lineBuilder.toString();
            this.lineBuilder.setLength(0);
            this.writeUTF8(nextLine);
        }

        @Override
        public void startDocument() throws SAXException {
            String charsetName = this.getCharset().name();
            this.emitLineUTF8("<?xml version = \"1.0\" encoding = \"" + charsetName + "\"?>\n");
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.append("<?");
            this.append(target);
            if (data != null && data.length() > 0) {
                XmlActionImpl.this.debug("processingInstruction: data[" + data + "]", new Object[0]);
                this.append(' ');
                this.append(data);
            }
            this.append("?>");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XmlActionImpl.this.debug("startElement: uri[" + uri + "] localName[" + localName + "] qName[" + qName + "] attributes[" + attributes + "]", new Object[0]);
            this.append('<' + localName);
            this.append(uri);
            if (attributes != null) {
                int numberAttributes = attributes.getLength();
                for (int i = 0; i < numberAttributes; ++i) {
                    this.append(' ');
                    this.append(attributes.getQName(i));
                    XmlActionImpl.this.debug("startElement: attributes.getQName(" + i + ")[" + attributes.getQName(i) + "]", new Object[0]);
                    this.append("=\"");
                    this.append(attributes.getValue(i));
                    XmlActionImpl.this.debug("startElement: attributes.getValue(" + i + ")[" + attributes.getValue(i) + "]", new Object[0]);
                    this.append('\"');
                }
            }
            this.appendLine('>');
            this.emit();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XmlActionImpl.this.debug("endElement: uri[" + uri + "] localName[" + localName + "] qName[" + qName + "]", new Object[0]);
            this.append("</");
            this.append(localName + '>');
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            String initialText = new String(chars, start, length);
            XmlActionImpl.this.debug("characters: initialText[" + initialText + "]", new Object[0]);
            String finalText = XmlActionImpl.this.replaceText(this.inputName, initialText);
            if (finalText == null) {
                finalText = initialText;
                XmlActionImpl.this.addReplacement();
            }
            XmlActionImpl.this.debug("characters:  finalText[" + finalText + "]", new Object[0]);
            this.append(finalText);
        }

        @Override
        public void ignorableWhitespace(char[] whitespace, int start, int length) throws SAXException {
            this.append(whitespace, start, length);
        }
    }
}

