/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.classfile.AnnotationDefaultAttribute;
import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.AnnotationsAttribute;
import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.CodeAttribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ConstantValueAttribute;
import aQute.bnd.classfile.ElementValueInfo;
import aQute.bnd.classfile.EnclosingMethodAttribute;
import aQute.bnd.classfile.ExceptionsAttribute;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.InnerClassesAttribute;
import aQute.bnd.classfile.LocalVariableTableAttribute;
import aQute.bnd.classfile.LocalVariableTypeTableAttribute;
import aQute.bnd.classfile.MemberInfo;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.ModuleAttribute;
import aQute.bnd.classfile.ModuleMainClassAttribute;
import aQute.bnd.classfile.ModulePackagesAttribute;
import aQute.bnd.classfile.NestHostAttribute;
import aQute.bnd.classfile.NestMembersAttribute;
import aQute.bnd.classfile.ParameterAnnotationInfo;
import aQute.bnd.classfile.ParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.SignatureAttribute;
import aQute.bnd.classfile.StackMapTableAttribute;
import aQute.bnd.classfile.TypeAnnotationInfo;
import aQute.bnd.classfile.TypeAnnotationsAttribute;
import aQute.bnd.classfile.builder.ClassFileBuilder;
import aQute.bnd.classfile.builder.MutableConstantPool;
import aQute.lib.io.ByteBufferDataInput;
import aQute.lib.io.ByteBufferDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.ClassChangesImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;

public class ClassActionImpl
extends ActionImpl {
    protected static final int DUMP_WIDTH = 16;

    public static String resourceNameToClassName(String resourceName) {
        String className = resourceName.substring(resourceName.length() - ".class".length());
        className = className.replace('/', '.');
        return className;
    }

    public static String classNameToResourceName(String className) {
        String resourceName = className.replace('.', '/');
        resourceName = resourceName + ".class";
        return resourceName;
    }

    public static String classNameToBinaryTypeName(String className) {
        return className.replace('.', '/');
    }

    public static String relocateClass(Logger logger, String inputPath, String inputClassName, String outputClassName) {
        String outputPath;
        String relocationCase;
        String directInputPath = ClassActionImpl.classNameToResourceName(inputClassName);
        String directOutputPath = ClassActionImpl.classNameToResourceName(outputClassName);
        if (directInputPath.equals(inputPath)) {
            return directOutputPath;
        }
        if (inputPath.endsWith(directInputPath)) {
            return inputPath.substring(0, inputPath.length() - directInputPath.length()) + directOutputPath;
        }
        if (inputPath.startsWith("WEB-INF/classes/")) {
            relocationCase = "WEB-INF/classes";
            outputPath = "WEB-INF/classes/" + directOutputPath;
        } else if (inputPath.startsWith("META-INF/versions/")) {
            int nextSlash = inputPath.indexOf(47, "META-INF/versions/".length());
            if (nextSlash == -1) {
                relocationCase = "META-INF/versions with no version number";
                outputPath = "META-INF/versions/" + directOutputPath;
            } else {
                relocationCase = "META-INF/versions";
                outputPath = inputPath.substring(0, nextSlash + 1) + directOutputPath;
            }
        } else {
            relocationCase = "Unknown location";
            outputPath = directOutputPath;
        }
        logger.log(Level.SEVERE, "Approximate relocation of class; case {}: initial class name [ {} ]; final class name [ {} ]; initial resource location [ {} ]; final resource location [ {} ].", new Object[]{relocationCase, inputClassName, outputClassName, inputPath, outputPath});
        return outputPath;
    }

    protected void debugDump(byte[] bytes, int offset, int length) {
        if (!this.getLogger().isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder outputBuilder = new StringBuilder();
        while (length > 0) {
            int nextWidth = length > 16 ? 16 : length;
            String nextLine = this.debugDumpLine(outputBuilder, bytes, offset, nextWidth);
            this.debug(nextLine, new Object[0]);
            offset += nextWidth;
            length -= nextWidth;
        }
    }

    private String debugDumpLine(StringBuilder builder, byte[] bytes, int offset, int width) {
        for (int byteNo = 0; byteNo < width; ++byteNo) {
            byte nextByte = bytes[offset + byteNo];
            builder.append(String.format("%02x ", nextByte));
        }
        String line = builder.toString();
        builder.setLength(0);
        return line;
    }

    public ClassActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public String getName() {
        return "Class Action";
    }

    @Override
    public ActionType getActionType() {
        return ActionType.CLASS;
    }

    @Override
    protected ClassChangesImpl newChanges() {
        return new ClassChangesImpl();
    }

    @Override
    public ClassChangesImpl getLastActiveChanges() {
        return (ClassChangesImpl)super.getLastActiveChanges();
    }

    @Override
    public ClassChangesImpl getActiveChanges() {
        return (ClassChangesImpl)super.getActiveChanges();
    }

    protected void setClassNames(String inputClassName, String outputClassName) {
        ClassChangesImpl useChanges = this.getActiveChanges();
        useChanges.setInputClassName(inputClassName);
        useChanges.setOutputClassName(outputClassName);
    }

    protected void setSuperClassNames(String inputSuperName, String outputSuperName) {
        ClassChangesImpl useChanges = this.getActiveChanges();
        useChanges.setInputSuperName(inputSuperName);
        useChanges.setOutputSuperName(outputSuperName);
    }

    protected void addModifiedInterface() {
        this.getActiveChanges().addModifiedInterface();
    }

    protected void addModifiedField() {
        this.getActiveChanges().addModifiedField();
    }

    protected void addModifiedMethod() {
        this.getActiveChanges().addModifiedMethod();
    }

    protected void addModifiedAttribute() {
        this.getActiveChanges().addModifiedAttribute();
    }

    protected void setModifiedConstants(int modifiedConstants) {
        this.getActiveChanges().setModifiedConstants(modifiedConstants);
    }

    @Override
    public String getAcceptExtension() {
        return ".class";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteData apply(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        ListIterator<FieldInfo> fields;
        List interfaces;
        void var8_18;
        ClassFileBuilder classBuilder;
        String inputClassName;
        String outputClassName;
        ClassFile inputClass;
        this.debug("Read [ {} ] Bytes [ {} ]", inputName, inputLength);
        this.debugDump(inputBytes, 0, inputLength);
        try {
            DataInput inputClassData = ByteBufferDataInput.wrap((byte[])inputBytes, (int)0, (int)inputLength);
            inputClass = ClassFile.parseClassFile((DataInput)inputClassData);
        }
        catch (IOException e) {
            this.error("Failed to parse raw class bytes [ {} ]", e, inputName);
            return null;
        }
        this.debug("Class [ {} ] as [ {} ] ", inputName, inputClass.this_class);
        this.debug("  Super [ {} ]", inputClass.super_class);
        if (inputClass.interfaces != null) {
            this.debug("  Interfaces [ {} ]", inputClass.interfaces.length);
            for (String string : inputClass.interfaces) {
                this.debug("    [ {} ]", string);
            }
        }
        if (inputClass.fields != null) {
            this.debug("  Fields [ {} ]", inputClass.fields.length);
            for (String string : inputClass.fields) {
                this.debug("    [ {} ] [ {} ]", ((FieldInfo)string).name, ((FieldInfo)string).descriptor);
            }
        }
        if (inputClass.methods != null) {
            this.debug("  Methods [ {} ]", inputClass.methods.length);
            for (String string : inputClass.methods) {
                this.debug("    [ {} ] [ {} ]", ((MethodInfo)string).name, ((MethodInfo)string).descriptor);
            }
        }
        if ((outputClassName = this.transformBinaryType(inputClassName = (classBuilder = new ClassFileBuilder(inputClass)).this_class())) != null) {
            classBuilder.this_class(outputClassName);
            String string = ClassActionImpl.relocateClass(this.getLogger(), inputName, inputClassName, outputClassName);
            this.verbose("Class name [ {} ] -> [ {} ]", inputName, string);
        } else {
            outputClassName = inputClassName;
            String string = inputName;
        }
        this.setClassNames(inputClassName, outputClassName);
        this.setResourceNames(inputName, (String)var8_18);
        this.debug("{}", classBuilder);
        String inputSuperName = classBuilder.super_class();
        if (inputSuperName != null) {
            String outputSuperName = this.transformBinaryType(inputSuperName);
            if (outputSuperName != null) {
                classBuilder.super_class(outputSuperName);
            } else {
                outputSuperName = inputSuperName;
            }
            this.setSuperClassNames(inputSuperName, outputSuperName);
            if (!outputSuperName.equals("java/lang/Object")) {
                this.debug("  extends {}", outputSuperName);
            }
        }
        if (!(interfaces = classBuilder.interfaces()).isEmpty()) {
            ListIterator<String> interfaceNames = interfaces.listIterator();
            while (interfaceNames.hasNext()) {
                String interfaceName = this.transformBinaryType((String)interfaceNames.next());
                if (interfaceName == null) continue;
                interfaceNames.set(interfaceName);
                this.addModifiedInterface();
            }
            this.debug("  implements {}", interfaces);
        }
        if ((fields = classBuilder.fields().listIterator()).hasNext()) {
            this.debug("  Fields:", new Object[0]);
        }
        while (fields.hasNext()) {
            FieldInfo inputField = (FieldInfo)fields.next();
            FieldInfo outputField = this.transform(inputField, FieldInfo::new, SignatureRule.SignatureType.FIELD, inputName);
            if (outputField == null) continue;
            fields.set(outputField);
            this.addModifiedField();
            this.debug("       {}    -> {}", inputField, outputField);
            this.verbose("Field {} -> {}", inputField, outputField);
        }
        ListIterator<MethodInfo> methods = classBuilder.methods().listIterator();
        if (methods.hasNext()) {
            this.debug("  Methods:", new Object[0]);
        }
        while (methods.hasNext()) {
            MethodInfo inputMethod = (MethodInfo)methods.next();
            MethodInfo outputMethod = this.transform(inputMethod, MethodInfo::new, SignatureRule.SignatureType.METHOD, inputName);
            if (outputMethod == null) continue;
            methods.set(outputMethod);
            this.addModifiedMethod();
            this.debug("       {}    -> {}", inputMethod, outputMethod);
            this.verbose("Method {} -> {}", inputMethod, outputMethod);
        }
        ListIterator<Attribute> attributes = classBuilder.attributes().listIterator();
        if (attributes.hasNext()) {
            this.debug("  Attributes:", new Object[0]);
        }
        while (attributes.hasNext()) {
            Attribute inputAttribute = (Attribute)attributes.next();
            Attribute outputAttribute = this.transform(inputAttribute, SignatureRule.SignatureType.CLASS, inputName);
            if (outputAttribute == null) continue;
            attributes.set(outputAttribute);
            this.addModifiedAttribute();
            this.debug("       {}    -> {}", inputAttribute, outputAttribute);
            this.verbose("Attribute {} -> {}", inputAttribute, outputAttribute);
        }
        MutableConstantPool constants = classBuilder.constant_pool();
        this.debug("  Constant pool: {}", constants.size());
        int modifiedConstants = this.transform(constants, inputName);
        if (modifiedConstants > 0) {
            this.setModifiedConstants(modifiedConstants);
        }
        if (!this.hasNonResourceNameChanges()) {
            this.verbose("  Class bytes: {} {}", inputName, inputLength);
            return null;
        }
        ClassFile outputClass = classBuilder.build();
        ByteBufferDataOutput outputClassData = new ByteBufferDataOutput(inputLength + 4096);
        try {
            outputClass.write((DataOutput)outputClassData);
        }
        catch (IOException e) {
            throw new TransformException("Failed to write transformed class bytes", e);
        }
        byte[] outputBytes = outputClassData.toByteArray();
        this.verbose("  Class size: {}: {} -> {}", inputName, inputLength, outputBytes.length);
        return new ByteData((String)var8_18, outputBytes, 0, outputBytes.length);
    }

    private <MEMBERINFO extends MemberInfo> MEMBERINFO transform(MEMBERINFO member, MemberInfo.Constructor<MEMBERINFO> constructor, SignatureRule.SignatureType signatureType, String inputName) {
        String inputDescriptor = member.descriptor;
        String outputDescriptor = this.transformDescriptor(inputDescriptor);
        if (outputDescriptor != null) {
            this.debug("    {}       {}    -> {}", member.name, member.descriptor, outputDescriptor);
            this.verbose("Member {}.{} > {}", member.name, member.descriptor, outputDescriptor);
        }
        Attribute[] inputAttributes = member.attributes;
        Attribute[] outputAttributes = this.transform(inputAttributes, signatureType, inputName);
        if (outputDescriptor == null && outputAttributes == null) {
            return null;
        }
        return (MEMBERINFO)constructor.init(member.access, member.name, outputDescriptor == null ? inputDescriptor : outputDescriptor, outputAttributes == null ? inputAttributes : outputAttributes);
    }

    private Attribute[] transform(Attribute[] inputAttributes, SignatureRule.SignatureType signatureType, String inputName) {
        Attribute[] outputAttributes = null;
        for (int attributeNo = 0; attributeNo < inputAttributes.length; ++attributeNo) {
            Attribute inputAttribute = inputAttributes[attributeNo];
            Attribute outputAttribute = this.transform(inputAttribute, signatureType, inputName);
            if (outputAttribute == null) continue;
            if (outputAttributes == null) {
                outputAttributes = (Attribute[])inputAttributes.clone();
            }
            outputAttributes[attributeNo] = outputAttribute;
            this.debug("       {}    -> {}", inputAttribute, outputAttribute);
            this.verbose("Attribute {} -> {}", inputAttribute, outputAttribute);
        }
        return outputAttributes;
    }

    private Attribute transform(Attribute attr, SignatureRule.SignatureType signatureType, String inputName) {
        switch (attr.name()) {
            case "Signature": {
                SignatureAttribute inputAttribute = (SignatureAttribute)attr;
                String outputSignature = this.transform(inputAttribute.signature, signatureType);
                return outputSignature == null ? null : new SignatureAttribute(outputSignature);
            }
            case "Exceptions": {
                ExceptionsAttribute inputAttribute = (ExceptionsAttribute)attr;
                String[] inputExceptions = inputAttribute.exceptions;
                String[] outputExceptions = null;
                for (int exNo = 0; exNo < inputExceptions.length; ++exNo) {
                    String exception = this.transformBinaryType(inputExceptions[exNo]);
                    if (exception == null) continue;
                    if (outputExceptions == null) {
                        outputExceptions = (String[])inputExceptions.clone();
                    }
                    outputExceptions[exNo] = exception;
                }
                return outputExceptions == null ? null : new ExceptionsAttribute(outputExceptions);
            }
            case "Code": {
                CodeAttribute attribute = (CodeAttribute)attr;
                CodeAttribute.ExceptionHandler[] inputHandlers = attribute.exception_table;
                CodeAttribute.ExceptionHandler[] outputHandlers = null;
                for (int handlerNo = 0; handlerNo < inputHandlers.length; ++handlerNo) {
                    String outputCatchType;
                    CodeAttribute.ExceptionHandler inputHandler = inputHandlers[handlerNo];
                    String inputCatchType = inputHandler.catch_type;
                    if (inputCatchType == null || (outputCatchType = this.transformBinaryType(inputCatchType)) == null) continue;
                    if (outputHandlers == null) {
                        outputHandlers = (CodeAttribute.ExceptionHandler[])inputHandlers.clone();
                    }
                    outputHandlers[handlerNo] = new CodeAttribute.ExceptionHandler(inputHandler.start_pc, inputHandler.end_pc, inputHandler.handler_pc, outputCatchType);
                }
                Attribute[] inputAttributes = attribute.attributes;
                Attribute[] outputAttributes = this.transform(inputAttributes, SignatureRule.SignatureType.METHOD, inputName);
                if (outputHandlers == null && outputAttributes == null) {
                    return null;
                }
                return new CodeAttribute(attribute.max_stack, attribute.max_locals, attribute.code, outputHandlers == null ? inputHandlers : outputHandlers, outputAttributes == null ? inputAttributes : outputAttributes);
            }
            case "EnclosingMethod": {
                EnclosingMethodAttribute attribute = (EnclosingMethodAttribute)attr;
                String inputDescriptor = attribute.method_descriptor;
                String className = this.transformBinaryType(attribute.class_name);
                if (inputDescriptor == null && className == null) {
                    return null;
                }
                String outputDescriptor = null;
                if (inputDescriptor != null) {
                    outputDescriptor = this.transformDescriptor(inputDescriptor);
                }
                if (outputDescriptor == null && className == null) {
                    return null;
                }
                return new EnclosingMethodAttribute(className == null ? attribute.class_name : className, attribute.method_name, outputDescriptor == null ? inputDescriptor : outputDescriptor);
            }
            case "StackMapTable": {
                StackMapTableAttribute inputAttribute = (StackMapTableAttribute)attr;
                StackMapTableAttribute.StackMapFrame[] inputFrames = inputAttribute.entries;
                StackMapTableAttribute.StackMapFrame[] outputFrames = null;
                block54: for (int frameNo = 0; frameNo < inputFrames.length; ++frameNo) {
                    StackMapTableAttribute.StackMapFrame inputFrame = inputFrames[frameNo];
                    switch (inputFrame.type()) {
                        case 127: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.SameLocals1StackItemFrame)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo stack = this.transform(frame.stack);
                            if (stack == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.SameLocals1StackItemFrame(frame.tag, stack);
                            continue block54;
                        }
                        case 247: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.SameLocals1StackItemFrameExtended)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo stack = this.transform(frame.stack);
                            if (stack == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.SameLocals1StackItemFrameExtended(frame.tag, frame.delta, stack);
                            continue block54;
                        }
                        case 254: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.AppendFrame)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo[] locals = this.transform(frame.locals);
                            if (locals == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.AppendFrame(frame.tag, frame.delta, locals);
                            continue block54;
                        }
                        case 255: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.FullFrame)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo[] locals = this.transform(frame.locals);
                            StackMapTableAttribute.VerificationTypeInfo[] stack = this.transform(frame.stack);
                            if (locals == null && stack == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.FullFrame(frame.tag, frame.delta, locals == null ? frame.locals : locals, stack == null ? frame.stack : stack);
                            continue block54;
                        }
                    }
                }
                if (outputFrames == null) {
                    return null;
                }
                return new StackMapTableAttribute(outputFrames);
            }
            case "InnerClasses": {
                InnerClassesAttribute inputAttribute = (InnerClassesAttribute)attr;
                InnerClassesAttribute.InnerClass[] inputClasses = inputAttribute.classes;
                InnerClassesAttribute.InnerClass[] outputClasses = null;
                for (int classNo = 0; classNo < inputClasses.length; ++classNo) {
                    String outputOuterClass;
                    InnerClassesAttribute.InnerClass inputClass = inputClasses[classNo];
                    String inputInnerClass = inputClass.inner_class;
                    String outputInnerClass = inputInnerClass == null ? null : this.transformBinaryType(inputInnerClass);
                    String inputOuterClass = inputClass.outer_class;
                    String string = outputOuterClass = inputOuterClass == null ? null : this.transformBinaryType(inputOuterClass);
                    if (outputInnerClass == null && outputOuterClass == null) continue;
                    if (outputClasses == null) {
                        outputClasses = (InnerClassesAttribute.InnerClass[])inputClasses.clone();
                    }
                    outputClasses[classNo] = new InnerClassesAttribute.InnerClass(outputInnerClass == null ? inputInnerClass : outputInnerClass, outputOuterClass == null ? inputOuterClass : outputOuterClass, inputClass.inner_name, inputClass.inner_access);
                }
                if (outputClasses == null) {
                    return null;
                }
                return new InnerClassesAttribute(outputClasses);
            }
            case "LocalVariableTable": {
                LocalVariableTableAttribute inputAttribute = (LocalVariableTableAttribute)attr;
                LocalVariableTableAttribute.LocalVariable[] inputVariables = inputAttribute.local_variable_table;
                LocalVariableTableAttribute.LocalVariable[] outputVariables = null;
                for (int varNo = 0; varNo < inputVariables.length; ++varNo) {
                    LocalVariableTableAttribute.LocalVariable inputVariable = inputVariables[varNo];
                    String outputDescriptor = this.transformDescriptor(inputVariable.descriptor);
                    if (outputDescriptor == null) continue;
                    if (outputVariables == null) {
                        outputVariables = (LocalVariableTableAttribute.LocalVariable[])inputVariables.clone();
                    }
                    outputVariables[varNo] = new LocalVariableTableAttribute.LocalVariable(inputVariable.start_pc, inputVariable.length, inputVariable.name, outputDescriptor, inputVariable.index);
                }
                if (outputVariables == null) {
                    return null;
                }
                return new LocalVariableTableAttribute(outputVariables);
            }
            case "LocalVariableTypeTable": {
                LocalVariableTypeTableAttribute inputAttribute = (LocalVariableTypeTableAttribute)attr;
                LocalVariableTypeTableAttribute.LocalVariableType[] inputTypes = inputAttribute.local_variable_type_table;
                LocalVariableTypeTableAttribute.LocalVariableType[] outputTypes = null;
                for (int varNo = 0; varNo < inputTypes.length; ++varNo) {
                    LocalVariableTypeTableAttribute.LocalVariableType inputType = inputTypes[varNo];
                    String outputSignature = this.transform(inputType.signature, SignatureRule.SignatureType.FIELD);
                    if (outputSignature == null) continue;
                    if (outputTypes == null) {
                        outputTypes = (LocalVariableTypeTableAttribute.LocalVariableType[])inputTypes.clone();
                    }
                    outputTypes[varNo] = new LocalVariableTypeTableAttribute.LocalVariableType(inputType.start_pc, inputType.length, inputType.name, outputSignature, inputType.index);
                }
                if (outputTypes == null) {
                    return null;
                }
                return new LocalVariableTypeTableAttribute(outputTypes);
            }
            case "RuntimeVisibleAnnotations": {
                RuntimeVisibleAnnotationsAttribute inputAttribute = (RuntimeVisibleAnnotationsAttribute)attr;
                RuntimeVisibleAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeVisibleAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeInvisibleAnnotations": {
                RuntimeInvisibleAnnotationsAttribute inputAttribute = (RuntimeInvisibleAnnotationsAttribute)attr;
                RuntimeInvisibleAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeInvisibleAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeVisibleParameterAnnotations": {
                RuntimeVisibleParameterAnnotationsAttribute inputAttribute = (RuntimeVisibleParameterAnnotationsAttribute)attr;
                RuntimeVisibleParameterAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeVisibleParameterAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeInvisibleParameterAnnotations": {
                RuntimeInvisibleParameterAnnotationsAttribute inputAttribute = (RuntimeInvisibleParameterAnnotationsAttribute)attr;
                RuntimeInvisibleParameterAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeInvisibleParameterAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeVisibleTypeAnnotations": {
                RuntimeVisibleTypeAnnotationsAttribute inputAttribute = (RuntimeVisibleTypeAnnotationsAttribute)attr;
                RuntimeVisibleTypeAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeVisibleTypeAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeInvisibleTypeAnnotations": {
                RuntimeInvisibleTypeAnnotationsAttribute inputAttribute = (RuntimeInvisibleTypeAnnotationsAttribute)attr;
                RuntimeInvisibleTypeAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeInvisibleTypeAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "AnnotationDefault": {
                AnnotationDefaultAttribute inputAttribute = (AnnotationDefaultAttribute)attr;
                Object outputValue = this.transformElementValue(inputAttribute.value, inputName);
                return outputValue == null ? null : new AnnotationDefaultAttribute(outputValue);
            }
            case "Module": {
                ModuleAttribute inputAttribute = (ModuleAttribute)attr;
                ModuleAttribute.Export[] inputExports = inputAttribute.exports;
                ModuleAttribute.Export[] outputExports = null;
                for (int i = 0; i < inputExports.length; ++i) {
                    ModuleAttribute.Export inputExport = inputExports[i];
                    String outputExport = this.replaceBinaryPackage(inputExport.exports);
                    if (outputExport == null) continue;
                    if (outputExports == null) {
                        outputExports = (ModuleAttribute.Export[])inputExports.clone();
                    }
                    outputExports[i] = new ModuleAttribute.Export(outputExport, inputExport.exports_flags, inputExport.exports_to);
                }
                ModuleAttribute.Open[] inputOpens = inputAttribute.opens;
                ModuleAttribute.Open[] outputOpens = null;
                for (int i = 0; i < inputOpens.length; ++i) {
                    ModuleAttribute.Open inputOpen = inputOpens[i];
                    String outputOpen = this.replaceBinaryPackage(inputOpen.opens);
                    if (outputOpen == null) continue;
                    if (outputOpens == null) {
                        outputOpens = (ModuleAttribute.Open[])inputOpens.clone();
                    }
                    outputOpens[i] = new ModuleAttribute.Open(outputOpen, inputOpen.opens_flags, inputOpen.opens_to);
                }
                String[] inputUses = inputAttribute.uses;
                String[] outputUses = null;
                for (int i = 0; i < inputUses.length; ++i) {
                    String outputUse = this.transformBinaryType(inputUses[i]);
                    if (outputUse == null) continue;
                    if (outputUses == null) {
                        outputUses = (String[])inputUses.clone();
                    }
                    outputUses[i] = outputUse;
                }
                ModuleAttribute.Provide[] inputProvides = inputAttribute.provides;
                ModuleAttribute.Provide[] outputProvides = null;
                for (int i = 0; i < inputProvides.length; ++i) {
                    ModuleAttribute.Provide inputProvide = inputProvides[i];
                    String outputProvide = this.transformBinaryType(inputProvide.provides);
                    String[] inputProvideWiths = inputProvide.provides_with;
                    String[] outputProvideWiths = null;
                    for (int j = 0; j < inputProvideWiths.length; ++j) {
                        String outputProvideWith = this.transformBinaryType(inputProvideWiths[j]);
                        if (outputProvideWith == null) continue;
                        if (outputProvideWiths == null) {
                            outputProvideWiths = (String[])inputProvideWiths.clone();
                        }
                        outputProvideWiths[j] = outputProvideWith;
                    }
                    if (outputProvide == null && outputProvideWiths == null) continue;
                    if (outputProvide == null) {
                        outputProvide = inputProvide.provides;
                    }
                    if (outputProvideWiths == null) {
                        outputProvideWiths = inputProvideWiths;
                    }
                    if (outputProvides == null) {
                        outputProvides = (ModuleAttribute.Provide[])inputProvides.clone();
                    }
                    outputProvides[i] = new ModuleAttribute.Provide(outputProvide, outputProvideWiths);
                }
                if (outputExports == null && outputOpens == null && outputUses == null && outputProvides == null) {
                    return null;
                }
                if (outputExports == null) {
                    outputExports = inputExports;
                }
                if (outputOpens == null) {
                    outputOpens = inputOpens;
                }
                if (outputUses == null) {
                    outputUses = inputUses;
                }
                if (outputProvides == null) {
                    outputProvides = inputProvides;
                }
                return new ModuleAttribute(inputAttribute.module_name, inputAttribute.module_flags, inputAttribute.module_version, inputAttribute.requires, outputExports, outputOpens, outputUses, outputProvides);
            }
            case "ModuleMainClass": {
                ModuleMainClassAttribute inputAttribute = (ModuleMainClassAttribute)attr;
                String inputMainClass = inputAttribute.main_class;
                String outputMainClass = this.transformBinaryType(inputMainClass);
                return outputMainClass == null ? null : new ModuleMainClassAttribute(outputMainClass);
            }
            case "ModulePackages": {
                ModulePackagesAttribute inputAttribute = (ModulePackagesAttribute)attr;
                String[] inputPackages = inputAttribute.packages;
                String[] outputPackages = null;
                for (int i = 0; i < inputPackages.length; ++i) {
                    String outputPackage = this.replaceBinaryPackage(inputPackages[i]);
                    if (outputPackage == null) continue;
                    if (outputPackages == null) {
                        outputPackages = (String[])inputPackages.clone();
                    }
                    outputPackages[i] = outputPackage;
                }
                return outputPackages == null ? null : new ModulePackagesAttribute(outputPackages);
            }
            case "NestHost": {
                NestHostAttribute inputAttribute = (NestHostAttribute)attr;
                String inputHostClass = inputAttribute.host_class;
                String outputHostClass = this.transformBinaryType(inputHostClass);
                return outputHostClass == null ? null : new NestHostAttribute(outputHostClass);
            }
            case "NestMembers": {
                NestMembersAttribute inputAttribute = (NestMembersAttribute)attr;
                String[] inputClasses = inputAttribute.classes;
                String[] outputClasses = null;
                for (int i = 0; i < inputClasses.length; ++i) {
                    String outputClass = this.transformBinaryType(inputClasses[i]);
                    if (outputClass == null) continue;
                    if (outputClasses == null) {
                        outputClasses = (String[])inputClasses.clone();
                    }
                    outputClasses[i] = outputClass;
                }
                return outputClasses == null ? null : new NestMembersAttribute(outputClasses);
            }
            case "ConstantValue": {
                ConstantValueAttribute inputAttribute = (ConstantValueAttribute)attr;
                Object inputValue = inputAttribute.value;
                Object outputValue = this.transformConstantValue(inputValue, inputName);
                return outputValue == null ? null : new ConstantValueAttribute(outputValue);
            }
        }
        return null;
    }

    private Object transformConstantValue(Object inputValue, String inputName) {
        if (inputValue instanceof String) {
            String inputString = (String)inputValue;
            String transformCase = "constant";
            String outputString = this.transformConstantAsDescriptor(inputString, true);
            if (outputString == null) {
                transformCase = "resource";
                outputString = this.transformConstantAsBinaryType(inputString, true);
                if (outputString == null) {
                    transformCase = "direct";
                    outputString = this.transformDirectString(inputString);
                    if (outputString == null) {
                        transformCase = "direct per class";
                        outputString = this.transformConstantString(inputString, inputName);
                    }
                }
            }
            if (outputString == null) {
                this.debug("    String ConstantValue: {} (unchanged)", inputValue);
            } else {
                this.debug("    String ConstantValue: {}                       -> {} ({})", inputValue, outputString, transformCase);
                this.verbose("String ConstantValue: {} -> {} ({})", inputValue, outputString, transformCase);
            }
            return outputString;
        }
        this.debug("    Non-String ConstantValue: {} (unchanged)", inputValue);
        return null;
    }

    private <ANNOTATIONSATTRIBUTE extends AnnotationsAttribute> ANNOTATIONSATTRIBUTE transform(ANNOTATIONSATTRIBUTE inputAttribute, AnnotationsAttribute.Constructor<ANNOTATIONSATTRIBUTE> constructor, String inputName) {
        AnnotationInfo[] outputAnnotations = this.transform(inputAttribute.annotations, inputName);
        return (ANNOTATIONSATTRIBUTE)(outputAnnotations == null ? null : constructor.init(outputAnnotations));
    }

    private AnnotationInfo[] transform(AnnotationInfo[] inputAnnotations, String inputName) {
        AnnotationInfo[] outputAnnotations = null;
        for (int annoNo = 0; annoNo < inputAnnotations.length; ++annoNo) {
            AnnotationInfo inputAnnotation = inputAnnotations[annoNo];
            AnnotationInfo outputAnnotation = this.transform(inputAnnotation, AnnotationInfo::new, inputName);
            if (outputAnnotation == null) continue;
            if (outputAnnotations == null) {
                outputAnnotations = (AnnotationInfo[])inputAnnotations.clone();
            }
            outputAnnotations[annoNo] = outputAnnotation;
        }
        return outputAnnotations;
    }

    private <PARAMETERANNOTATIONSATTRIBUTE extends ParameterAnnotationsAttribute> PARAMETERANNOTATIONSATTRIBUTE transform(PARAMETERANNOTATIONSATTRIBUTE attribute, ParameterAnnotationsAttribute.Constructor<PARAMETERANNOTATIONSATTRIBUTE> constructor, String inputName) {
        ParameterAnnotationInfo[] outputParmAnnotations = this.transform(attribute.parameter_annotations, inputName);
        if (outputParmAnnotations == null) {
            return null;
        }
        return (PARAMETERANNOTATIONSATTRIBUTE)constructor.init(outputParmAnnotations);
    }

    private ParameterAnnotationInfo[] transform(ParameterAnnotationInfo[] inputParmAnnotations, String inputName) {
        ParameterAnnotationInfo[] outputParmAnnotations = null;
        for (int parmNo = 0; parmNo < inputParmAnnotations.length; ++parmNo) {
            ParameterAnnotationInfo inputParmAnnotation = inputParmAnnotations[parmNo];
            AnnotationInfo[] outputAnnotations = this.transform(inputParmAnnotation.annotations, inputName);
            if (outputAnnotations == null) continue;
            if (outputParmAnnotations == null) {
                outputParmAnnotations = (ParameterAnnotationInfo[])inputParmAnnotations.clone();
            }
            outputParmAnnotations[parmNo] = new ParameterAnnotationInfo(inputParmAnnotation.parameter, outputAnnotations);
        }
        return outputParmAnnotations;
    }

    private <TYPEANNOTATIONSATTRIBUTE extends TypeAnnotationsAttribute> TYPEANNOTATIONSATTRIBUTE transform(TYPEANNOTATIONSATTRIBUTE inputAttribute, TypeAnnotationsAttribute.Constructor<TYPEANNOTATIONSATTRIBUTE> constructor, String inputName) {
        TypeAnnotationInfo[] outputAnnotations = this.transform(inputAttribute.type_annotations, inputName);
        if (outputAnnotations == null) {
            return null;
        }
        return (TYPEANNOTATIONSATTRIBUTE)constructor.init(outputAnnotations);
    }

    private TypeAnnotationInfo[] transform(TypeAnnotationInfo[] inputAnnotations, String inputName) {
        TypeAnnotationInfo[] outputAnnotations = null;
        for (int annoNo = 0; annoNo < inputAnnotations.length; ++annoNo) {
            TypeAnnotationInfo inputAnnotation = inputAnnotations[annoNo];
            TypeAnnotationInfo outputAnnotation = this.transform(inputAnnotation, (type, values) -> new TypeAnnotationInfo(inputAnnotation.target_type, inputAnnotation.target_info, inputAnnotation.target_index, inputAnnotation.type_path, type, values), inputName);
            if (outputAnnotation == null) continue;
            if (outputAnnotations == null) {
                outputAnnotations = (TypeAnnotationInfo[])inputAnnotations.clone();
            }
            outputAnnotations[annoNo] = outputAnnotation;
        }
        return outputAnnotations;
    }

    private <ANNOTATIONINFO extends AnnotationInfo> ANNOTATIONINFO transform(ANNOTATIONINFO inputAnnotation, AnnotationInfo.Constructor<ANNOTATIONINFO> constructor, String inputName) {
        String inputType = inputAnnotation.type;
        String outputType = this.transformDescriptor(inputType);
        ElementValueInfo[] inputValues = inputAnnotation.values;
        ElementValueInfo[] outputValues = this.transform(inputValues, inputName);
        if (outputType == null && outputValues == null) {
            return null;
        }
        return (ANNOTATIONINFO)constructor.init(outputType == null ? inputType : outputType, outputValues == null ? inputValues : outputValues);
    }

    private ElementValueInfo[] transform(ElementValueInfo[] inputElementValues, String inputName) {
        ElementValueInfo[] outputElementValues = null;
        for (int valueNo = 0; valueNo < inputElementValues.length; ++valueNo) {
            ElementValueInfo inputElementValue = inputElementValues[valueNo];
            Object outputValue = this.transformElementValue(inputElementValue.value, inputName);
            if (outputValue == null) continue;
            if (outputElementValues == null) {
                outputElementValues = (ElementValueInfo[])inputElementValues.clone();
            }
            outputElementValues[valueNo] = new ElementValueInfo(inputElementValue.name, outputValue);
        }
        return outputElementValues;
    }

    private Object transformElementValue(Object inputValue, String inputName) {
        if (inputValue instanceof ElementValueInfo.EnumConst) {
            ElementValueInfo.EnumConst enumValue = (ElementValueInfo.EnumConst)inputValue;
            String inputType = enumValue.type;
            String outputType = this.transformDescriptor(inputType);
            if (outputType == null) {
                return null;
            }
            return new ElementValueInfo.EnumConst(outputType, enumValue.name);
        }
        if (inputValue instanceof ElementValueInfo.ResultConst) {
            ElementValueInfo.ResultConst resultValue = (ElementValueInfo.ResultConst)inputValue;
            String inputDescriptor = resultValue.descriptor;
            String outputDescriptor = this.transformDescriptor(inputDescriptor);
            if (outputDescriptor == null) {
                return null;
            }
            return new ElementValueInfo.ResultConst(outputDescriptor);
        }
        if (inputValue instanceof AnnotationInfo) {
            AnnotationInfo annotationValue = (AnnotationInfo)inputValue;
            return this.transform(annotationValue, AnnotationInfo::new, inputName);
        }
        if (inputValue instanceof String) {
            String inputString = (String)inputValue;
            String outputString = this.transformDirectString(inputString);
            if (outputString == null) {
                outputString = this.transformConstantString(inputString, inputName);
            }
            return outputString;
        }
        if (inputValue instanceof Object[]) {
            Object[] inputElementValues = (Object[])inputValue;
            Object[] outputElementValues = null;
            for (int valueNo = 0; valueNo < inputElementValues.length; ++valueNo) {
                Object outputElementValue = this.transformElementValue(inputElementValues[valueNo], inputName);
                if (outputElementValue == null) continue;
                if (outputElementValues == null) {
                    outputElementValues = (Object[])inputElementValues.clone();
                }
                outputElementValues[valueNo] = outputElementValue;
            }
            return outputElementValues;
        }
        return null;
    }

    private StackMapTableAttribute.VerificationTypeInfo[] transform(StackMapTableAttribute.VerificationTypeInfo[] inputVtis) {
        StackMapTableAttribute.VerificationTypeInfo[] outputVtis = null;
        for (int vtiNo = 0; vtiNo < inputVtis.length; ++vtiNo) {
            StackMapTableAttribute.VerificationTypeInfo inputVti = inputVtis[vtiNo];
            StackMapTableAttribute.VerificationTypeInfo outputVti = this.transform(inputVti);
            if (outputVti == null) continue;
            if (outputVtis == null) {
                outputVtis = (StackMapTableAttribute.VerificationTypeInfo[])inputVtis.clone();
            }
            outputVtis[vtiNo] = outputVti;
        }
        return outputVtis;
    }

    private StackMapTableAttribute.VerificationTypeInfo transform(StackMapTableAttribute.VerificationTypeInfo vti) {
        if (!(vti instanceof StackMapTableAttribute.ObjectVariableInfo)) {
            return null;
        }
        StackMapTableAttribute.ObjectVariableInfo inputOvi = (StackMapTableAttribute.ObjectVariableInfo)vti;
        String inputType = inputOvi.type;
        if (inputType == null) {
            return null;
        }
        String outputType = this.transformBinaryType(inputType);
        if (outputType == null) {
            return null;
        }
        return new StackMapTableAttribute.ObjectVariableInfo(inputOvi.tag, outputType);
    }

    private int transform(MutableConstantPool constants, String inputName) throws TransformException {
        int modifiedConstants = 0;
        int numConstants = constants.size();
        block9: for (int constantNo = 1; constantNo < numConstants; ++constantNo) {
            this.debug(String.format("Constant [ %3s ] [ %16s ] [ %s ]", constantNo, constants.tag(constantNo), constants.entry(constantNo)), new Object[0]);
            switch (constants.tag(constantNo)) {
                case 7: {
                    ConstantPool.ClassInfo info = (ConstantPool.ClassInfo)constants.entry(constantNo);
                    String inputClassName = (String)constants.entry(info.class_index);
                    String outputClassName = this.transformBinaryType(inputClassName);
                    if (outputClassName != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.ClassInfo(constants.utf8Info(outputClassName)));
                        ++modifiedConstants;
                        this.debug("    Class: {}        -> {}", inputClassName, outputClassName);
                        this.verbose("Class Reference: {} -> {}", inputClassName, outputClassName);
                        continue block9;
                    }
                    this.debug("Skip class {} (unchanged)", inputClassName);
                    continue block9;
                }
                case 12: {
                    ConstantPool.ClassInfo info = (ConstantPool.NameAndTypeInfo)constants.entry(constantNo);
                    String inputDescriptor = constants.utf8(info.descriptor_index);
                    String outputDescriptor = this.transformDescriptor(inputDescriptor);
                    if (outputDescriptor != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.NameAndTypeInfo(info.name_index, constants.utf8Info(outputDescriptor)));
                        ++modifiedConstants;
                        this.debug("    NameAndType: {}              -> {}", inputDescriptor, outputDescriptor);
                        this.verbose("NameAndType: {} -> {}", inputDescriptor, outputDescriptor);
                        continue block9;
                    }
                    this.debug("Skip name-and-type {} (unchanged)", inputDescriptor);
                    continue block9;
                }
                case 16: {
                    ConstantPool.ClassInfo info = (ConstantPool.MethodTypeInfo)constants.entry(constantNo);
                    String inputDescriptor = constants.utf8(info.descriptor_index);
                    String outputDescriptor = this.transformDescriptor(inputDescriptor);
                    if (outputDescriptor != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.MethodTypeInfo(constants.utf8Info(outputDescriptor)));
                        ++modifiedConstants;
                        this.debug("    MethodType: {} -> {}", inputDescriptor, outputDescriptor);
                        this.verbose("MethodType: {} -> {}", inputDescriptor, outputDescriptor);
                        continue block9;
                    }
                    this.debug("Skip method-type {} (unchanged)", inputDescriptor);
                    continue block9;
                }
                case 1: {
                    String outputUtf8;
                    String transformCase;
                    String inputUtf8 = (String)constants.entry(constantNo);
                    if (inputUtf8 == null || inputUtf8.isEmpty()) {
                        transformCase = null;
                        outputUtf8 = null;
                    } else {
                        transformCase = "constant";
                        outputUtf8 = this.transformConstantAsDescriptor(inputUtf8, true);
                        if (outputUtf8 == null) {
                            transformCase = "resource";
                            outputUtf8 = this.transformConstantAsBinaryType(inputUtf8, true);
                            if (outputUtf8 == null) {
                                transformCase = "Direct";
                                outputUtf8 = this.transformDirectString(inputUtf8);
                                if (outputUtf8 == null) {
                                    transformCase = "Direct per class";
                                    outputUtf8 = this.transformConstantString(inputUtf8, inputName);
                                }
                            }
                        }
                    }
                    if (outputUtf8 != null) {
                        constants.entry(constantNo, (Object)outputUtf8);
                        ++modifiedConstants;
                        this.debug("    UTF8: {} -> {} ({})", inputUtf8, outputUtf8, transformCase);
                        this.verbose("UTF8: {} -> {} ({})", inputUtf8, outputUtf8, transformCase);
                        continue block9;
                    }
                    this.debug("Skip UTF8 {} (unchanged)", inputUtf8);
                    continue block9;
                }
                case 8: {
                    ConstantPool.StringInfo stringInfo = (ConstantPool.StringInfo)constants.entry(constantNo);
                    String inputString = constants.utf8(stringInfo.string_index);
                    String transformCase = "constant";
                    String outputString = this.transformConstantAsDescriptor(inputString, true);
                    if (outputString == null) {
                        transformCase = "String";
                        outputString = this.transformConstantAsBinaryType(inputString, true);
                        if (outputString == null) {
                            transformCase = "Direct";
                            outputString = this.transformDirectString(inputString);
                            if (outputString == null) {
                                transformCase = "Direct per class";
                                outputString = this.transformConstantString(inputString, inputName);
                            }
                        }
                    }
                    if (outputString != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.StringInfo(constants.utf8Info(outputString)));
                        ++modifiedConstants;
                        this.debug("    String: {} -> {}", inputString, outputString);
                        this.verbose("String: {} -> {}", inputString, outputString);
                        continue block9;
                    }
                    this.debug("Skip string {} (unchanged)", inputString);
                    continue block9;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    this.debug("Skip other (ignored)", new Object[0]);
                    continue block9;
                }
                case 5: 
                case 6: {
                    this.debug("Skip floating point value +1 (ignored)", new Object[0]);
                    ++constantNo;
                    continue block9;
                }
                default: {
                    throw new TransformException("Unrecognized constant pool entry [ " + constantNo + " ]: [ " + constants.entry(constantNo) + " ]");
                }
            }
        }
        return modifiedConstants;
    }
}

