/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ContainerChanges;
import org.eclipse.transformer.action.impl.ChangesImpl;

public class ContainerChangesImpl
extends ChangesImpl
implements ContainerChanges {
    private final Map<String, int[]> changedByAction = new HashMap<String, int[]>();
    private final Map<String, int[]> unchangedByAction = new HashMap<String, int[]>();
    private int allUnchanged = 0;
    private int allChanged = 0;
    private int allSelected = 0;
    private int allUnselected = 0;
    private int allResources = 0;
    private ContainerChangesImpl allNestedChanges = null;
    private static final String DASH_LINE = "================================================================================";
    private static final String SMALL_DASH_LINE = "--------------------------------------------------------------------------------";
    private static final String DATA_LINE = "[ %22s ] [ %6s ] %10s [ %6s ] %8s [ %6s ]%s";

    protected ContainerChangesImpl() {
    }

    @Override
    public boolean hasNonResourceNameChanges() {
        return this.allChanged > 0;
    }

    @Override
    public void clearChanges() {
        this.changedByAction.clear();
        this.unchangedByAction.clear();
        this.allChanged = 0;
        this.allUnchanged = 0;
        this.allSelected = 0;
        this.allUnselected = 0;
        this.allResources = 0;
        this.allNestedChanges = null;
        super.clearChanges();
    }

    @Override
    public Set<String> getActionNames() {
        Set<String> changedNames = this.changedByAction.keySet();
        Set<String> unchangedNames = this.unchangedByAction.keySet();
        HashSet<String> allNames = new HashSet<String>(changedNames.size() + unchangedNames.size());
        allNames.addAll(changedNames);
        allNames.addAll(unchangedNames);
        return allNames;
    }

    @Override
    public Map<String, int[]> getChangedByAction() {
        return Collections.unmodifiableMap(this.changedByAction);
    }

    @Override
    public Map<String, int[]> getUnchangedByAction() {
        return Collections.unmodifiableMap(this.unchangedByAction);
    }

    @Override
    public int getAllResources() {
        return this.allResources;
    }

    @Override
    public int getAllUnselected() {
        return this.allUnselected;
    }

    @Override
    public int getAllSelected() {
        return this.allSelected;
    }

    @Override
    public int getAllUnchanged() {
        return this.allUnchanged;
    }

    @Override
    public int getAllChanged() {
        return this.allChanged;
    }

    @Override
    public int getChanged(Action action) {
        return this.getChanged(action.getName());
    }

    @Override
    public int getChanged(String name) {
        int[] changes = this.changedByAction.get(name);
        return changes == null ? 0 : changes[0];
    }

    @Override
    public int getUnchanged(Action action) {
        return this.getUnchanged(action.getName());
    }

    @Override
    public int getUnchanged(String name) {
        int[] changes = this.unchangedByAction.get(name);
        return changes == null ? 0 : changes[0];
    }

    @Override
    public void record(Action action) {
        this.record(action.getName(), action.hadChanges());
        action.getLastActiveChanges().addNestedInto(this);
    }

    @Override
    public void record(Action action, boolean hasChanges) {
        this.record(action.getName(), hasChanges);
    }

    @Override
    public void record(String name, boolean hasChanges) {
        Map<String, int[]> target;
        ++this.allResources;
        ++this.allSelected;
        if (hasChanges) {
            ++this.allChanged;
            target = this.changedByAction;
        } else {
            ++this.allUnchanged;
            target = this.unchangedByAction;
        }
        int[] changes = target.get(name);
        if (changes == null) {
            changes = new int[]{1};
            target.put(name, changes);
        } else {
            changes[0] = changes[0] + 1;
        }
    }

    @Override
    public void record() {
        ++this.allResources;
        ++this.allUnselected;
    }

    @Override
    public void addNestedInto(ContainerChanges containerChanges) {
        containerChanges.addNested(this);
    }

    @Override
    public boolean hasNestedChanges() {
        return this.allNestedChanges != null;
    }

    @Override
    public ContainerChangesImpl getNestedChanges() {
        return this.allNestedChanges;
    }

    @Override
    public void addNested(ContainerChanges otherChanges) {
        if (this.allNestedChanges == null) {
            this.allNestedChanges = new ContainerChangesImpl();
        }
        this.allNestedChanges.add(otherChanges);
        ContainerChanges otherNestedChanges = otherChanges.getNestedChanges();
        if (otherNestedChanges != null) {
            this.allNestedChanges.add(otherNestedChanges);
        }
    }

    @Override
    public void add(ContainerChanges otherChanges) {
        this.addChangeMap(this.changedByAction, otherChanges.getChangedByAction());
        this.addChangeMap(this.unchangedByAction, otherChanges.getUnchangedByAction());
        this.allChanged += otherChanges.getAllChanged();
        this.allUnchanged += otherChanges.getAllUnchanged();
        this.allSelected += otherChanges.getAllSelected();
        this.allUnselected += otherChanges.getAllUnselected();
        this.allResources += otherChanges.getAllResources();
    }

    private void addChangeMap(Map<String, int[]> thisChangeMap, Map<String, int[]> otherChangeMap) {
        int[] nextChanges = new int[1];
        for (Map.Entry<String, int[]> mapEntry : otherChangeMap.entrySet()) {
            int[] thisChanges = thisChangeMap.putIfAbsent(mapEntry.getKey(), nextChanges);
            if (thisChanges == null) {
                thisChanges = nextChanges;
                nextChanges = new int[1];
            }
            thisChanges[0] = thisChanges[0] + mapEntry.getValue()[0];
        }
    }

    private String formatData(Object ... parms) {
        return String.format(DATA_LINE, parms);
    }

    protected void displayChanges(PrintStream stream) {
        stream.print(this.formatData("All Resources", this.getAllResources(), "Unselected", this.getAllUnselected(), "Selected", this.getAllSelected(), "\n"));
        stream.print(SMALL_DASH_LINE);
        stream.print("\n");
        stream.print(this.formatData("All Actions", this.getAllSelected(), "Unchanged", this.getAllUnchanged(), "Changed", this.getAllChanged(), "\n"));
        for (String actionName : this.getActionNames()) {
            int useUnchangedByAction = this.getUnchanged(actionName);
            int useChangedByAction = this.getChanged(actionName);
            stream.print(this.formatData(actionName, useUnchangedByAction + useChangedByAction, "Unchanged", useUnchangedByAction, "Changed", useChangedByAction, "\n"));
        }
    }

    protected void displayChanges(Logger logger) {
        logger.info(this.formatData("All Resources", this.getAllResources(), "Unselected", this.getAllUnselected(), "Selected", this.getAllSelected(), ""));
        logger.info(SMALL_DASH_LINE);
        logger.info(this.formatData("All Actions", this.getAllSelected(), "Unchanged", this.getAllUnchanged(), "Changed", this.getAllChanged(), ""));
        for (String actionName : this.getActionNames()) {
            int useUnchangedByAction = this.getUnchanged(actionName);
            int useChangedByAction = this.getChanged(actionName);
            logger.info(this.formatData(actionName, useUnchangedByAction + useChangedByAction, "Unchanged", useUnchangedByAction, "Changed", useChangedByAction, ""));
        }
    }

    @Override
    public void displayVerbose(PrintStream stream, String inputPath, String outputPath) {
        stream.print(DASH_LINE);
        stream.print("\n");
        stream.printf("[ Input  ] [ %s ]\n           [ %s ]\n", this.getInputResourceName(), inputPath);
        stream.printf("[ Output ] [ %s ]\n           [ %s ]\n", this.getOutputResourceName(), outputPath);
        stream.print(DASH_LINE);
        stream.print("\n");
        stream.printf("[ Immediate changes: ]\n", new Object[0]);
        stream.print(SMALL_DASH_LINE);
        stream.print("\n");
        this.displayChanges(stream);
        stream.print(DASH_LINE);
        stream.print("\n");
        if (this.allNestedChanges != null) {
            stream.printf("[ Nested changes: ]\n", new Object[0]);
            stream.printf(SMALL_DASH_LINE, new Object[0]);
            stream.print("\n");
            this.allNestedChanges.displayChanges(stream);
            stream.printf(DASH_LINE, new Object[0]);
            stream.print("\n");
        }
    }

    @Override
    public void displayVerbose(Logger logger, String inputPath, String outputPath) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        logger.info(DASH_LINE);
        logger.log(Level.INFO, "[ Input  ] [ {} ]", this.getInputResourceName());
        logger.log(Level.INFO, "           [ {} ]", inputPath);
        logger.log(Level.INFO, "[ Output ] [ {} ]", this.getOutputResourceName());
        logger.log(Level.INFO, "           [ {} ]", outputPath);
        logger.info(DASH_LINE);
        logger.info("[ Immediate changes: ]");
        logger.info(SMALL_DASH_LINE);
        this.displayChanges(logger);
        logger.info(DASH_LINE);
        if (this.allNestedChanges != null) {
            logger.info("[ Nested changes: ]");
            logger.info(SMALL_DASH_LINE);
            this.allNestedChanges.displayChanges(logger);
            logger.info(DASH_LINE);
        }
    }

    @Override
    public void displayTerse(PrintStream stream, String inputPath, String outputPath) {
        if (!inputPath.equals(outputPath)) {
            stream.printf("Input [ %s ] as [ %s ]: %s\n", inputPath, outputPath, this.getChangeTag());
        } else {
            stream.printf("Input [ %s ]: %s\n", inputPath, this.getChangeTag());
        }
        stream.print(this.formatData("All Resources", this.getAllResources(), "Unselected", this.getAllUnselected(), "Selected", this.getAllSelected(), "\n"));
        stream.print(this.formatData("All Actions", this.getAllSelected(), "Unchanged", this.getAllUnchanged(), "Changed", this.getAllChanged(), "\n"));
        if (this.allNestedChanges != null) {
            stream.print(this.formatData("Nested Resources", this.allNestedChanges.getAllResources(), "Unselected", this.allNestedChanges.getAllUnselected(), "Selected", this.allNestedChanges.getAllSelected(), "\n"));
            stream.print(this.formatData("Nested Actions", this.allNestedChanges.getAllSelected(), "Unchanged", this.allNestedChanges.getAllUnchanged(), "Changed", this.allNestedChanges.getAllChanged(), "\n"));
        }
    }

    @Override
    public void displayTerse(Logger logger, String inputPath, String outputPath) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        if (!inputPath.equals(outputPath)) {
            if (!inputPath.equals(outputPath)) {
                logger.log(Level.INFO, "Input [ {} ] as [ {} ]: {}", new Object[]{inputPath, outputPath, this.getChangeTag()});
            } else {
                logger.log(Level.INFO, "Input [ {} ]: {}", new Object[]{inputPath, this.getChangeTag()});
            }
        }
        logger.info(this.formatData("All Resources", this.getAllResources(), "Unselected", this.getAllUnselected(), "Selected", this.getAllSelected(), ""));
        logger.info(this.formatData("All Actions", this.getAllSelected(), "Unchanged", this.getAllUnchanged(), "Changed", this.getAllChanged(), ""));
        if (this.allNestedChanges != null) {
            logger.info(this.formatData("Nested Resources", this.allNestedChanges.getAllResources(), "Unselected", this.allNestedChanges.getAllUnselected(), "Selected", this.allNestedChanges.getAllSelected(), ""));
            logger.info(this.formatData("Nested Actions", this.allNestedChanges.getAllSelected(), "Unchanged", this.allNestedChanges.getAllUnchanged(), "Changed", this.allNestedChanges.getAllChanged(), ""));
        }
    }
}

