/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.lib.io.ByteBufferOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;
import org.eclipse.transformer.util.ManifestWriter;

public class ManifestActionImpl
extends ActionImpl {
    public static final String META_INF = "META-INF/";
    public static final String MANIFEST_MF = "MANIFEST.MF";
    public static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    public static final boolean IS_MANIFEST = true;
    public static final boolean IS_FEATURE = false;
    private final boolean isManifest;
    private static final Set<String> SELECT_ATTRIBUTES;
    public static final String SYMBOLIC_NAME_PROPERTY_NAME = "Bundle-SymbolicName";
    public static final String VERSION_PROPERTY_NAME = "Bundle-Version";
    public static final String NAME_PROPERTY_NAME = "Bundle-Name";
    public static final String DESCRIPTION_PROPERTY_NAME = "Bundle-Description";

    public static ManifestActionImpl newManifestAction(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        return new ManifestActionImpl(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule, true);
    }

    public static ManifestActionImpl newFeatureAction(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        return new ManifestActionImpl(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule, false);
    }

    public ManifestActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule, boolean isManifest) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
        this.isManifest = isManifest;
    }

    @Override
    public String getName() {
        return this.getIsManifest() ? "Manifest Action" : "Feature Action";
    }

    @Override
    public ActionType getActionType() {
        return this.getIsManifest() ? ActionType.MANIFEST : ActionType.FEATURE;
    }

    public boolean getIsManifest() {
        return this.isManifest;
    }

    public boolean getIsFeature() {
        return !this.isManifest;
    }

    @Override
    public String getAcceptExtension() {
        return this.getIsManifest() ? "manifest.mf" : ".mf";
    }

    @Override
    public ByteData apply(String initialName, byte[] initialBytes, int initialCount) throws TransformException {
        Manifest initialManifest;
        String className = this.getClass().getSimpleName();
        String methodName = "apply";
        this.debug("[ {}.{} ]: [ {} ] Initial bytes [ {} ]", className, methodName, initialName, initialCount);
        this.setResourceNames(initialName, initialName);
        ByteData initialData = new ByteData(initialName, initialBytes, 0, initialCount);
        try {
            initialManifest = new Manifest(initialData.asStream());
        }
        catch (IOException e) {
            this.error("Failed to parse manifest [ {} ]", e, initialName);
            return null;
        }
        Manifest finalManifest = new Manifest();
        this.transform(initialName, initialManifest, finalManifest);
        if (!this.hasNonResourceNameChanges()) {
            this.debug("[ {}.{} ]: [ {} ] Null transform", className, methodName, initialName);
            return null;
        }
        ByteBufferOutputStream outputStream = new ByteBufferOutputStream(initialCount);
        try {
            this.write(finalManifest, (OutputStream)outputStream);
        }
        catch (IOException e) {
            this.error("Failed to write manifest [ {} ]", e, initialName);
            return null;
        }
        byte[] finalBytes = outputStream.toByteArray();
        this.debug("[ {}.{} ]: [ {} ] Active transform; final bytes [ {} ]", className, methodName, initialName, finalBytes.length);
        return new ByteData(initialName, finalBytes);
    }

    protected void transform(String inputName, Manifest initialManifest, Manifest finalManifest) {
        Attributes initialMainAttributes = initialManifest.getMainAttributes();
        Attributes finalMainAttributes = finalManifest.getMainAttributes();
        this.addReplacements(this.transformPackages(inputName, "main", initialMainAttributes, finalMainAttributes));
        if (this.transformBundleIdentity(inputName, initialMainAttributes, finalMainAttributes)) {
            this.addReplacement();
        }
        Map<String, Attributes> initialEntries = initialManifest.getEntries();
        Map<String, Attributes> finalEntries = finalManifest.getEntries();
        for (Map.Entry<String, Attributes> entry : initialEntries.entrySet()) {
            String entryKey = entry.getKey();
            Attributes initialEntryAttributes = entry.getValue();
            Attributes finalAttributes = new Attributes(initialEntryAttributes.size());
            finalEntries.put(entryKey, finalAttributes);
            this.addReplacements(this.transformPackages(inputName, entryKey, initialEntryAttributes, finalAttributes));
        }
    }

    protected boolean selectAttribute(String name) {
        return SELECT_ATTRIBUTES.contains(name);
    }

    protected int transformPackages(String inputName, String entryName, Attributes initialAttributes, Attributes finalAttributes) {
        this.debug("Transforming [ {} ]: [ {} ] Attributes [ {} ]", inputName, entryName, initialAttributes.size());
        int replacements = 0;
        for (Map.Entry<Object, Object> entries : initialAttributes.entrySet()) {
            Object untypedName = entries.getKey();
            String typedName = untypedName.toString();
            String initialValue = (String)entries.getValue();
            String finalValue = null;
            if (this.selectAttribute(typedName)) {
                finalValue = this.replacePackages(initialValue);
            }
            if (finalValue == null) {
                finalValue = initialValue;
            } else {
                ++replacements;
            }
            finalAttributes.put(untypedName, finalValue);
        }
        this.debug("Transformed [ {} ]: [ {} ] Attributes [ {} ] Replacements [ {} ]", inputName, entryName, finalAttributes.size(), replacements);
        return replacements;
    }

    protected void write(Manifest manifest, OutputStream outputStream) throws IOException {
        if (this.getIsManifest()) {
            this.writeAsManifest(manifest, outputStream);
        } else {
            this.writeAsFeature(manifest, outputStream);
        }
    }

    protected void writeAsManifest(Manifest manifest, OutputStream outputStream) throws IOException {
        ManifestWriter.write(manifest, outputStream);
    }

    protected void writeAsFeature(Manifest manifest, OutputStream outputStream) throws IOException {
        PrintWriter writer = new PrintWriter(outputStream);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> mainEntry : manifest.getMainAttributes().entrySet()) {
            writer.append(mainEntry.getKey().toString());
            writer.append(": ");
            String value = (String)mainEntry.getValue();
            if (value.indexOf(44) == -1) {
                writer.append(value);
            } else {
                Parameters parms = OSGiHeader.parseHeader((String)value);
                boolean continuedLine = false;
                for (Map.Entry parmEntry : parms.entrySet()) {
                    String parmName;
                    int index;
                    if (continuedLine) {
                        writer.append(",\r ");
                    }
                    if ((index = (parmName = (String)parmEntry.getKey()).indexOf(126)) != -1) {
                        parmName = parmName.substring(0, index);
                    }
                    writer.append(parmName);
                    Attrs parmAttrs = (Attrs)parmEntry.getValue();
                    for (Map.Entry parmAttrEntry : parmAttrs.entrySet()) {
                        String parmAttrName = (String)parmAttrEntry.getKey();
                        String parmAttrValue = this.quote(builder, (String)parmAttrEntry.getValue());
                        writer.append("; ");
                        writer.append(parmAttrName);
                        writer.append('=');
                        writer.append(parmAttrValue);
                    }
                    continuedLine = true;
                }
            }
            writer.append("\r");
        }
        writer.flush();
    }

    public String quote(StringBuilder sb, String value) {
        boolean isClean = OSGiHeader.quote((StringBuilder)sb, (String)value);
        String quotedValue = sb.toString();
        sb.setLength(0);
        return quotedValue;
    }

    protected String replacePackages(String text) {
        String initialText = text;
        for (Map.Entry<String, String> renameEntry : this.getPackageRenames().entrySet()) {
            int matchStart;
            String key = renameEntry.getKey();
            int keyLen = key.length();
            boolean matchSubpackages = SignatureRuleImpl.containsWildcard(key);
            if (matchSubpackages) {
                key = SignatureRuleImpl.stripWildcard(key);
            }
            int textLimit = text.length() - keyLen;
            int lastMatchEnd = 0;
            while (lastMatchEnd <= textLimit && (matchStart = text.indexOf(key, lastMatchEnd)) != -1) {
                if (!SignatureRuleImpl.isTruePackageMatch(text, matchStart, keyLen, matchSubpackages)) {
                    lastMatchEnd = matchStart + keyLen;
                    continue;
                }
                String value = renameEntry.getValue();
                int valueLen = value.length();
                String head = text.substring(0, matchStart);
                String tail = text.substring(matchStart + keyLen);
                int tailLenBeforeReplaceVersion = tail.length();
                String newVersion = this.getPackageVersions().get(value);
                if (newVersion != null) {
                    tail = this.replacePackageVersion(tail, newVersion);
                } else {
                    this.debug("replacePackages [ {} ]: [ {} -> {} ]; leaving version", initialText, key, value);
                }
                text = head + value + tail;
                int tailLenAfterReplaceVersion = tail.length();
                lastMatchEnd = matchStart + valueLen;
                textLimit += valueLen - keyLen;
                textLimit += tailLenAfterReplaceVersion - tailLenBeforeReplaceVersion;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    protected String replacePackageVersion(String text, String newVersion) {
        String packageText = this.getPackageAttributeText(text);
        if (packageText == null) {
            return text;
        }
        if (packageText.isEmpty()) {
            return text;
        }
        String VERSION = "version";
        int VERSION_LEN = 7;
        int QUOTE_MARK = 34;
        int versionIndex = packageText.indexOf("version");
        if (versionIndex == -1) {
            return text;
        }
        boolean foundEquals = false;
        boolean foundQuotationMark = false;
        int versionBeginIndex = -1;
        int versionEndIndex = -1;
        for (int i = versionIndex + 7; i < packageText.length(); ++i) {
            char ch = packageText.charAt(i);
            if (!foundEquals) {
                if (ch == '=') {
                    foundEquals = true;
                    continue;
                }
                if (Character.isWhitespace(ch)) continue;
                this.error("Syntax error found non-white-space character before equals sign in version [{}]", packageText);
                return text;
            }
            if (Character.isWhitespace(ch) || foundQuotationMark) continue;
            if (ch == '\"') {
                versionBeginIndex = i + 1;
                versionEndIndex = packageText.indexOf(34, i + 1);
                if (versionEndIndex == -1) {
                    this.error("Syntax error, package version does not have closing quotation mark", new Object[0]);
                    return text;
                }
                --versionEndIndex;
                foundQuotationMark = true;
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            this.error("Syntax error found non-white-space character after equals sign  in version [{}]", packageText);
            return text;
        }
        String head = text.substring(0, versionBeginIndex);
        String tail = text.substring(versionEndIndex + 1);
        String newText = head + newVersion + tail;
        return newText;
    }

    protected String getPackageAttributeText(String text) {
        if (text == null) {
            return null;
        }
        if (!this.firstCharIsSemicolon(text)) {
            return "";
        }
        int commaIndex = text.indexOf(44);
        this.debug("Comma index: [{}]", commaIndex);
        if (commaIndex == -1) {
            return text;
        }
        String packageText = text.substring(0, commaIndex + 1);
        this.debug("packageText [ {} ]", packageText);
        while (!this.isPackageDelimitingComma(text, packageText, commaIndex)) {
            commaIndex = text.indexOf(44, packageText.length());
            if (commaIndex == -1) {
                packageText = text;
                break;
            }
            packageText = text.substring(0, commaIndex + 1);
            if (this.hasEvenNumberOfOccurrencesOfChar(text, '\"')) continue;
        }
        this.debug("getPackageAttributeText returning: [ {} ]", packageText);
        return packageText;
    }

    protected boolean firstCharIsSemicolon(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.charAt(i) == ';';
        }
        return false;
    }

    protected int indexOfNextNonWhiteSpaceChar(String s, int currentIndex) {
        for (int i = currentIndex; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean isPackageDelimitingComma(String testString, String packageText, int indexOfComma) {
        int indexOfNextNonWhiteSpaceCharAfterComma = this.indexOfNextNonWhiteSpaceChar(testString, indexOfComma + 1);
        char characterAfterComma = testString.charAt(indexOfNextNonWhiteSpaceCharAfterComma);
        if (Character.isAlphabetic(characterAfterComma)) {
            return this.hasEvenNumberOfOccurrencesOfChar(packageText, '\"');
        }
        return false;
    }

    private boolean hasEvenNumberOfOccurrencesOfChar(String testString, char testChar) {
        long occurrences = testString.chars().filter(ch -> ch == 34).count();
        return occurrences % 2L == 0L;
    }

    public boolean transformBundleIdentity(String inputName, Attributes initialMainAttributes, Attributes finalMainAttributes) {
        String finalDescription;
        String initialDescription;
        String finalName;
        String initialName;
        String finalVersion;
        String initialVersion;
        int wildcardOffset;
        String matchCase;
        boolean isWildcard;
        boolean matched;
        BundleData bundleUpdate;
        String initialSymbolicName = initialMainAttributes.getValue(SYMBOLIC_NAME_PROPERTY_NAME);
        if (initialSymbolicName == null) {
            this.debug("Input [ {} ] has no bundle symbolic name", inputName);
            return false;
        }
        int indexOfSemiColon = initialSymbolicName.indexOf(59);
        String symbolicNamesAttributes = null;
        if (indexOfSemiColon != -1) {
            symbolicNamesAttributes = initialSymbolicName.substring(indexOfSemiColon);
            initialSymbolicName = initialSymbolicName.substring(0, indexOfSemiColon);
        }
        if ((bundleUpdate = this.getBundleUpdate(initialSymbolicName)) == null) {
            bundleUpdate = this.getBundleUpdate("*");
            if (bundleUpdate != null) {
                matched = true;
                isWildcard = true;
                matchCase = "a wildcard identity update";
            } else {
                matched = false;
                isWildcard = false;
                matchCase = "no identity update";
            }
        } else {
            matched = true;
            isWildcard = false;
            matchCase = "identity update";
        }
        this.debug("Input [ {} ] symbolic name [ {} ] has {}", inputName, initialSymbolicName, matchCase);
        if (!matched) {
            return false;
        }
        String finalSymbolicName = bundleUpdate.getSymbolicName();
        if (isWildcard && (wildcardOffset = finalSymbolicName.indexOf(42)) != -1) {
            finalSymbolicName = finalSymbolicName.substring(0, wildcardOffset) + initialSymbolicName + finalSymbolicName.substring(wildcardOffset + 1);
        }
        if (symbolicNamesAttributes != null) {
            finalSymbolicName = finalSymbolicName + symbolicNamesAttributes;
        }
        finalMainAttributes.putValue(SYMBOLIC_NAME_PROPERTY_NAME, finalSymbolicName);
        this.verbose("Bundle symbolic name: {} --> {}", initialSymbolicName, finalSymbolicName);
        if (!isWildcard && (initialVersion = initialMainAttributes.getValue(VERSION_PROPERTY_NAME)) != null && (finalVersion = bundleUpdate.getVersion()) != null && !finalVersion.isEmpty()) {
            finalMainAttributes.putValue(VERSION_PROPERTY_NAME, finalVersion);
            this.verbose("Bundle version: {} --> {}", initialVersion, finalVersion);
        }
        if ((initialName = initialMainAttributes.getValue(NAME_PROPERTY_NAME)) != null && (finalName = bundleUpdate.updateName(initialName)) != null && !finalName.isEmpty()) {
            finalMainAttributes.putValue(NAME_PROPERTY_NAME, finalName);
            this.verbose("Bundle name: {} --> {}", initialName, finalName);
        }
        if ((initialDescription = initialMainAttributes.getValue(DESCRIPTION_PROPERTY_NAME)) != null && (finalDescription = bundleUpdate.updateDescription(initialDescription)) != null && !finalDescription.isEmpty()) {
            finalMainAttributes.putValue(DESCRIPTION_PROPERTY_NAME, finalDescription);
            this.verbose("Bundle description: {} --> {}", initialDescription, finalDescription);
        }
        return true;
    }

    static {
        HashSet<String> useNames = new HashSet<String>();
        useNames.add("DynamicImport-Package");
        useNames.add("Export-Package");
        useNames.add("Import-Package");
        useNames.add("Subsystem-Content");
        useNames.add("IBM-API-Package");
        useNames.add("Provide-Capability");
        useNames.add("Require-Capability");
        SELECT_ATTRIBUTES = useNames;
    }
}

