/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

import aQute.lib.utf8properties.UTF8Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.impl.BundleDataImpl;

public class TransformProperties {
    public static final char PACKAGE_RENAME_ASSIGNMENT = '=';
    public static final char RESOURCE_EXCLUSION_PREFIX = '!';
    public static final char RESOURCE_WILDCARD = '*';

    public static void setSelections(Set<String> included, Set<String> excluded, UTF8Properties selections) {
        for (Map.Entry selectionEntry : selections.entrySet()) {
            String selection = (String)selectionEntry.getKey();
            if (selection.charAt(0) == '!') {
                excluded.add(selection.substring(1));
                continue;
            }
            included.add(selection);
        }
    }

    public static void processSelections(Set<String> selections, Set<String> selectionsExact, Set<String> selectionsHead, Set<String> selectionsTail, Set<String> selectionsAny) {
        for (String selection : selections) {
            boolean matchTail;
            boolean matchHead;
            int selectionLength = (selection = selection.trim()).length();
            if (selectionLength == 0) continue;
            boolean bl = matchHead = selection.charAt(0) == '*';
            if (selectionLength == 1) {
                selections.clear();
                selectionsExact.clear();
                selectionsHead.clear();
                selectionsTail.clear();
                selectionsAny.clear();
                return;
            }
            boolean bl2 = matchTail = selection.charAt(selectionLength - 1) == '*';
            if (matchHead) {
                if (matchTail) {
                    selectionsAny.add(selection.substring(1, selectionLength - 1));
                    continue;
                }
                selectionsHead.add(selection.substring(1));
                continue;
            }
            if (matchTail) {
                selectionsTail.add(selection.substring(0, selectionLength - 1));
                continue;
            }
            selectionsExact.add(selection);
        }
    }

    public static Map<String, String> getPackageRenames(UTF8Properties renameProperties) {
        HashMap<String, String> packageRenames = new HashMap<String, String>(renameProperties.size());
        for (Map.Entry renameEntry : renameProperties.entrySet()) {
            packageRenames.put((String)renameEntry.getKey(), (String)renameEntry.getValue());
        }
        return packageRenames;
    }

    public static Map<String, String> getDirectStrings(UTF8Properties directProperties) {
        HashMap<String, String> directStrings = new HashMap<String, String>(directProperties.size());
        for (Map.Entry directEntry : directProperties.entrySet()) {
            directStrings.put((String)directEntry.getKey(), (String)directEntry.getValue());
        }
        return directStrings;
    }

    public static Map<String, String> invert(Map<String, String> properties) {
        HashMap<String, String> inverseProperties = new HashMap<String, String>(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            inverseProperties.put(entry.getValue(), entry.getKey());
        }
        return inverseProperties;
    }

    public static Map<String, String> getPackageVersions(UTF8Properties versionProperties) {
        HashMap<String, String> packageVersions = new HashMap<String, String>(versionProperties.size());
        for (Map.Entry versionEntry : versionProperties.entrySet()) {
            packageVersions.put((String)versionEntry.getKey(), (String)versionEntry.getValue());
        }
        return packageVersions;
    }

    public static Map<String, BundleData> getBundleUpdates(UTF8Properties updateProperties) {
        HashMap<String, BundleData> bundleUpdates = new HashMap<String, BundleData>(updateProperties.size());
        for (Map.Entry updateEntry : updateProperties.entrySet()) {
            bundleUpdates.put((String)updateEntry.getKey(), new BundleDataImpl((String)updateEntry.getValue()));
        }
        return bundleUpdates;
    }

    public static Map<String, String> convertPropertiesToMap(UTF8Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Map.Entry fileEntry : properties.entrySet()) {
            map.put((String)fileEntry.getKey(), (String)fileEntry.getValue());
        }
        return map;
    }

    public static boolean isFeatureManifest(String manifestPath, File manifestFile) throws TransformException {
        FileReader manifestReader;
        try {
            manifestReader = new FileReader(manifestFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to open [ " + manifestPath + " ]", e);
        }
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(manifestReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() <= 72) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new TransformException("Failed to read  [ " + manifestPath + " ]", e);
        }
        finally {
            try {
                manifestReader.close();
            }
            catch (IOException e) {
                throw new TransformException("Failed to close  [ " + manifestPath + " ]", e);
            }
        }
    }
}

