package flux;

import java.io.Serializable;

/**
 * RabbitMQTrigger that consumes message from AMQP channel.
 *
 * @author arul@fluxcorp.com
 */
public interface RabbitMQTrigger extends RabbitMQ, Trigger {

  /**
   * Sets the delay that occurs between message polling. Defaults to +5s, five seconds.
   *
   * @param timeExpression the delay that occurs between message polling.
   */
  public void setPollingDelay(String timeExpression);

  /**
   * RabbitMQTrigger result
   */
  public class RabbitMQTriggerResult implements Serializable, Cloneable {
    /**
     * Message consumed by this trigger.
     */
    public String message;

    public Object clone() throws CloneNotSupportedException {
      return super.clone();
    } // clone()

    public String toString() {
      return super.toString();
    } // toString()
  }
}
