package flux;

import flux.dev.AdapterFactory;
import fluximpl.RabbitMQTriggerImpl;
import fluximpl.FlowChartImpl;

/**
 * Factory for creating RabbitMQTrigger.
 *
 * @author arul@fluxcorp.com
 */
public class RabbitMQTriggerFactory implements AdapterFactory {

  private FlowChartImpl flowChart;

  public void init(FlowChartImpl flowChart) {
    this.flowChart = flowChart;
  } // init

  public RabbitMQTrigger makeRabbitMQTrigger(String name) {
    return new RabbitMQTriggerImpl(flowChart, name);
  } // makeRabbitMQTrigger()
} // class RabbitMQTriggerFactory