package fluximpl;

import java.awt.*;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Vector;

/**
 * BeanInfo for RabbitMQTrigger.
 *
 * @author arul@fluxcorp.com
 */
public class RabbitMQTriggerImplBeanInfo extends ActionImplBeanInfo {
  /**
   * A small image for this custom action to be displayed in the Flux GUI.
   */
  private Image smallImage;

  /**
   * A large image for this custom action to be displayed in the Flux GUI.
   */
  private Image bigImage;

  protected BeanDescriptor bd = new BeanDescriptor(RabbitMQTriggerImpl.class);

  public RabbitMQTriggerImplBeanInfo(BeanDescriptor bd) {
    super();
    this.bd = bd;
    setCategory(bd, ActionImplBeanInfo.MESSAGING);
  }

  public RabbitMQTriggerImplBeanInfo() {
    super();
    bd.setDisplayName("RabbitMQ Trigger");
    bd.setShortDescription("Fires when a message is available for consumption in the RabbitMQ queue.");
    setCategory(bd, ActionImplBeanInfo.MESSAGING);
  }


  public Image getIcon(int type) {
    if (type == BeanInfo.ICON_COLOR_16x16) {
      return getSmallImage();
    } // if
    if (type == BeanInfo.ICON_COLOR_32x32) {
      return getBigImage();
    } // if
    return null;
  } // getIcon()

  /**
   * Returns a small image that represents this JavaBean.
   *
   * @return A small image that represents this JavaBean.
   */
  private Image getSmallImage() {
    if (smallImage == null) {
      smallImage = loadImage("/RabbitMQTriggerImpl_small.png");
    } // if
    return smallImage;
  } // getSmallImage()

  /**
   * Returns a large image that represents this JavaBean.
   *
   * @return A large image that represents this JavaBean.
   */
  private Image getBigImage() {
    if (bigImage == null) {
      bigImage = loadImage("/RabbitMQTriggerImpl_big.png");
    } // if
    return bigImage;
  } // getBigImage()


  public BeanDescriptor getBeanDescriptor() {
    return bd;
  }

  public PropertyDescriptor[] getPropertyDescriptors() {
    Vector<PropertyDescriptor> descriptors = new Vector<PropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
    try {
      int order = 10;
      descriptors.add(makePropertyDescriptor("host", "Hostname", RabbitMQTriggerImpl.class.getName(), "getHost", true, null, order++, false, false, false, false));
      descriptors.add(makePropertyDescriptor("password", "Password", RabbitMQTriggerImpl.class.getName(), "getPassword", true, null, order++, false, false, false, true));
      descriptors.add(makePropertyDescriptor("port", "Port", RabbitMQTriggerImpl.class.getName(), "getPort", true, null, order++, false, false, false, false));
      descriptors.add(makePropertyDescriptor("queueName", "Queue Name", RabbitMQTriggerImpl.class.getName(), "getQueueName", true, null, order++, false, false, false, false));
      descriptors.add(makePropertyDescriptor("pollingDelay", "Polling Delay", RabbitMQTriggerImpl.class.getName(), "getPollingDelay", false, null, order++, false, false, false, false));
      descriptors.add(makePropertyDescriptor("username", "Username", RabbitMQTriggerImpl.class.getName(), "getUsername", true, null, order++, false, false, false, false));
      descriptors.add(makePropertyDescriptor("virtualHost", "Virtual Host", RabbitMQTriggerImpl.class.getName(), "getVirtualHost", false, null, order, false, false, false, false));
    } catch (Exception e) {
      e.printStackTrace();
      throw new IllegalStateException("Could not create property descriptor.");
    } // catch

    return descriptors.toArray(new PropertyDescriptor[descriptors.size()]);
  }

  public void setCategory(BeanDescriptor beanDescriptor, String category) {
    beanDescriptor.setValue("category", category);
  }

}