/*
 * Decompiled with CFR 0.152.
 */
package fluximpl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import flux.EngineException;
import flux.EngineHelper;
import flux.Factory;
import flux.FlowContext;
import flux.RabbitMQTrigger;
import flux.dev.NotTriggeredException;
import flux.logging.Logger;
import fluximpl.FlowChartImpl;
import fluximpl.Password;
import fluximpl.RabbitMQActionImpl;
import fluximpl.RabbitMQTriggerVariable;
import fluximpl.StringUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Set;

public class RabbitMQTriggerImpl
extends RabbitMQActionImpl
implements RabbitMQTrigger {
    private static final String TRIGGER_VARIABLE = "RABBITMQ_TRIGGER_VARIABLE";
    private static final String EXCLUSIVE_TYPE = "EXCLUSIVE";

    public RabbitMQTriggerImpl() {
        super(new FlowChartImpl(), "RabbitMQ Trigger");
    }

    public RabbitMQTriggerImpl(FlowChartImpl fc, String name) {
        super(fc, name);
    }

    public Set<String> getHiddenVariableNames() {
        Set set = super.getHiddenVariableNames();
        set.add(TRIGGER_VARIABLE);
        return set;
    }

    public String getHost() {
        return this.getVariable().host;
    }

    public void setHost(String host) {
        RabbitMQTriggerVariable var = this.getVariable();
        var.host = host;
        this.putVariable(var);
    }

    public int getPort() {
        return this.getVariable().port;
    }

    public void setPort(int port) {
        RabbitMQTriggerVariable var = this.getVariable();
        var.port = port;
        this.putVariable(var);
    }

    public String getVirtualHost() {
        return this.getVariable().virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        RabbitMQTriggerVariable var = this.getVariable();
        var.virtualHost = virtualHost;
        this.putVariable(var);
    }

    public String getPollingDelay() {
        return this.getVariable().timeExpression;
    }

    @Override
    public void setPollingDelay(String timeExpression) {
        RabbitMQTriggerVariable var = this.getVariable();
        var.timeExpression = timeExpression;
        this.putVariable(var);
    }

    public String getUsername() {
        return this.getVariable().username;
    }

    public void setUsername(String username) {
        RabbitMQTriggerVariable var = this.getVariable();
        var.username = username;
        this.putVariable(var);
    }

    public String getPassword() {
        Password password = this.getVariable().password;
        if (password != null) {
            return password.getEncryptedPassword();
        }
        return null;
    }

    public void setPassword(String password) {
        RabbitMQTriggerVariable var = this.getVariable();
        if (password != null) {
            var.password = Password.makePassword((String)password);
        }
        this.putVariable(var);
    }

    public String getQueueName() {
        return this.getVariable().queueName;
    }

    public void setQueueName(String queueName) {
        RabbitMQTriggerVariable var = this.getVariable();
        var.queueName = queueName;
        this.putVariable(var);
    }

    public Date getNextPollingDate() {
        try {
            Factory fluxFactory = Factory.makeInstance();
            EngineHelper engineHelper = fluxFactory.makeEngineHelper();
            return engineHelper.applyTimeExpression(this.getPollingDelay(), null, null);
        }
        catch (EngineException engineException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(FlowContext flowContext) throws Exception {
        Logger log = flowContext.getLogger();
        RabbitMQTrigger.RabbitMQTriggerResult result = new RabbitMQTrigger.RabbitMQTriggerResult();
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(this.getHost());
        factory.setPort(this.getPort());
        if (!StringUtil.isNullOrEmpty((String)this.getVirtualHost())) {
            factory.setVirtualHost(this.getVirtualHost());
        }
        factory.setUsername(this.getUsername());
        factory.setPassword(this.getPassword());
        Connection conn = null;
        Channel channel = null;
        try {
            conn = factory.newConnection();
            channel = conn.createChannel();
            boolean autoAck = false;
            QueueingConsumer consumer = new QueueingConsumer(channel);
            log.info("Consuming message.");
            channel.basicConsume(this.getQueueName(), autoAck, (Consumer)consumer);
            String message = null;
            QueueingConsumer.Delivery delivery = null;
            try {
                delivery = consumer.nextDelivery();
                message = new String(delivery.getBody());
                log.info("Message " + message + " consumed successfully.");
            }
            catch (InterruptedException exception) {
                log.severe("Exception during consumption. Reason : " + exception.getMessage());
            }
            log.info("Acknowledging receipt.");
            if (delivery != null) {
                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
            }
            if (StringUtil.isNullOrEmpty((String)message)) {
                throw new NotTriggeredException();
            }
            result.message = message;
        }
        catch (IOException exception) {
            log.severe("Exception during consume. Reason : " + exception.getMessage());
        }
        finally {
            if (channel != null) {
                channel.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return result;
    }

    public void verify() throws EngineException {
        this.verifyCommonProperties();
        if (StringUtil.isNullOrEmpty((String)this.getPollingDelay())) {
            throw new EngineException("Expected \"Time Expression\" to be non-null or non-empty, but it was null or empty.");
        }
    }

    private RabbitMQTriggerVariable getVariable() {
        if (!this.getVariableManager().contains(TRIGGER_VARIABLE)) {
            this.getVariableManager().put(TRIGGER_VARIABLE, (Object)new RabbitMQTriggerVariable());
        }
        return (RabbitMQTriggerVariable)this.getVariableManager().get(TRIGGER_VARIABLE);
    }

    private void putVariable(RabbitMQTriggerVariable variable) {
        this.getVariableManager().put(TRIGGER_VARIABLE, (Object)variable);
    }
}

