/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpEncodingStreamingContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@Beta
@NotThreadSafe
public class MultipartFormDataContent
extends MultipartContent {
    protected static final String DEFAULT_BOUNDARY = "__0xKhTmLbOuNdArY__";
    private static final String TWO_DASHES = "--";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_TRANSFER_ENCODING = "content-transfer-encoding";
    private static final String DISPOSITION_STRING = "form-data; name=\"%s\"";
    private static final String DISPOSITION_STRING_EXT = "form-data; name=\"%1$s\"; filename=\"%2$s\"";

    protected static final HttpMediaType getMultipartFormDataMediaType() {
        return new HttpMediaType("multipart/form-data");
    }

    public MultipartFormDataContent() {
        HttpMediaType mediaType = MultipartFormDataContent.getMultipartFormDataMediaType();
        this.setMediaType(mediaType.setParameter("boundary", DEFAULT_BOUNDARY));
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.getCharset());
        String boundary = this.getBoundary();
        Collection parts = this.getParts();
        for (MultipartContent.Part part : parts) {
            HttpHeaders headers = new HttpHeaders().setAcceptEncoding(null);
            HttpHeaders partHeaders = part.headers;
            HttpContent content = part.content;
            String contentType = content != null ? content.getType() : null;
            String contentDisposition = null;
            if (contentType != null && contentType.contains("multipart") && partHeaders != null) {
                headers.fromHttpHeaders(partHeaders);
            } else {
                headers.setContentEncoding(null).setUserAgent(null).setContentType(null).setContentLength(null).set(CONTENT_TRANSFER_ENCODING, null);
                if (partHeaders != null) {
                    contentDisposition = partHeaders.getFirstHeaderStringValue(CONTENT_DISPOSITION);
                }
                headers.set(CONTENT_DISPOSITION, (Object)contentDisposition);
            }
            Object streamingContent = null;
            if (content != null) {
                headers.setContentType(contentType);
                headers.set(CONTENT_TRANSFER_ENCODING, (Object)"binary");
                HttpEncoding encoding = part.encoding;
                streamingContent = encoding == null ? content : new HttpEncodingStreamingContent((StreamingContent)content, encoding);
            }
            writer.write(TWO_DASHES);
            writer.write(boundary);
            writer.write("\r\n");
            HttpHeaders.serializeHeadersForMultipartRequests((HttpHeaders)headers, null, null, (Writer)writer);
            if (streamingContent == null) continue;
            writer.write("\r\n");
            writer.flush();
            streamingContent.writeTo(out);
            writer.write("\r\n");
        }
        writer.write(TWO_DASHES);
        writer.write(boundary);
        writer.write(TWO_DASHES);
        writer.flush();
    }

    public MultipartFormDataContent addPart(@Nonnull MultipartContent.Part part, @Nonnull String dispositionName, @Nullable String dispositionFilename) {
        Preconditions.checkNotNull((Object)dispositionName);
        String value = null;
        value = dispositionFilename == null ? String.format(Locale.US, DISPOSITION_STRING, dispositionName) : String.format(Locale.US, DISPOSITION_STRING_EXT, dispositionName, dispositionFilename);
        if (part.headers == null) {
            part.headers = new HttpHeaders().setAcceptEncoding(null);
        }
        part.headers.set(CONTENT_DISPOSITION, (Object)value);
        return (MultipartFormDataContent)super.addPart(part);
    }

    public MultipartFormDataContent addPart(@Nonnull MultipartContent.Part part) {
        return (MultipartFormDataContent)super.addPart(part);
    }

    public MultipartFormDataContent setParts(@Nonnull Collection<MultipartContent.Part> parts) {
        return (MultipartFormDataContent)super.setParts(parts);
    }

    public MultipartFormDataContent setContentParts(@Nonnull Collection<? extends HttpContent> contentParts) {
        return (MultipartFormDataContent)super.setContentParts(contentParts);
    }

    public final MultipartFormDataContent setMediaType(@Nullable HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public MultipartFormDataContent setBoundary(@Nonnull String boundary) {
        return (MultipartFormDataContent)super.setBoundary(boundary);
    }
}

