/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.PasswordTokenRequest;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import fm.audiobox.core.config.Configuration;
import fm.audiobox.core.config.ConfigurationException;
import fm.audiobox.core.exceptions.AudioBoxException;
import fm.audiobox.core.exceptions.AuthorizationException;
import fm.audiobox.core.exceptions.ExceptionHandler;
import fm.audiobox.core.exceptions.FileAlreadyUploaded;
import fm.audiobox.core.exceptions.ForbiddenException;
import fm.audiobox.core.exceptions.RemoteMessageException;
import fm.audiobox.core.exceptions.ResourceNotFoundException;
import fm.audiobox.core.exceptions.SystemOverloadedException;
import fm.audiobox.core.exceptions.ValidationException;
import fm.audiobox.core.models.Notifications;
import fm.audiobox.core.models.Playlist;
import fm.audiobox.core.models.PlaylistWrapper;
import fm.audiobox.core.models.Playlists;
import fm.audiobox.core.models.User;
import fm.audiobox.core.models.UserWrapper;
import fm.audiobox.core.net.NetworkProgressListener;
import fm.audiobox.core.net.Upload;
import fm.audiobox.core.store.CredentialDataStore;
import fm.audiobox.core.utils.Io;
import fm.audiobox.core.utils.ModelUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Client {
    private Configuration conf;
    private CredentialDataStore userDb;
    public static final String ACCOUNT_TOKENS = "_audiobox_account_tokens";
    private CredentialRefreshListener refreshListener;
    private JsonObjectParser jsonObjectParser;
    private HttpHeaders defaultHeaders;

    public Client(Configuration conf) throws ConfigurationException, IOException {
        conf.checkConfiguration();
        this.conf = conf;
        this.userDb = conf.getCredentialDataStore();
        this.refreshListener = conf.getRefreshListener();
        this.jsonObjectParser = new JsonObjectParser(this.getConf().getJsonFactory());
        this.defaultHeaders = new HttpHeaders();
        this.defaultHeaders.setUserAgent(this.getConf().getUserAgent());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public HttpHeaders getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public TokenResponse authorize(String username, String password) throws IOException {
        return this.authorize(username, password, false);
    }

    public TokenResponse authorize(String username, String password, boolean relaunchExceptions) throws IOException {
        try {
            PasswordTokenRequest ptr = new PasswordTokenRequest(this.getConf().getHttpTransport(), this.getConf().getJsonFactory(), this.getConf().getEnvTokenUrl(), username, password);
            ptr.setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication(this.getConf().getApiKey(), this.getConf().getApiSecret()));
            ptr.setRequestInitializer(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) throws IOException {
                    request.setSuppressUserAgentSuffix(true);
                    request.setHeaders(Client.this.defaultHeaders);
                }
            });
            TokenResponse response = ptr.execute();
            this.userDb.saveCredentials(ACCOUNT_TOKENS, (Credential)this.createCredentialWithRefreshToken(response));
            return response;
        }
        catch (TokenResponseException e) {
            AudioBoxException up = this.handleException(new AuthorizationException(e));
            if (relaunchExceptions) {
                throw up;
            }
            return null;
        }
    }

    public boolean isDaemonRunning() throws IOException {
        return StringUtils.isNotBlank((CharSequence)this.remoteDaemonIp());
    }

    public String remoteDaemonIp() throws IOException {
        HttpResponse rsp = this.doRequestToChannel("GET", "/daemon/keepalive", null, null, Configuration.Channels.daemon, null);
        return rsp.isSuccessStatusCode() ? Io.contentToString(rsp.getContent()) : "";
    }

    public User getUser() throws IOException {
        HttpResponse rsp = this.doGET(UserWrapper.getPath());
        return rsp.isSuccessStatusCode() ? ((UserWrapper)rsp.parseAs(UserWrapper.class)).getUser() : null;
    }

    public List<Playlist> getPlaylists() throws IOException {
        HttpResponse rsp = this.doGET(Playlists.getPath());
        return rsp.isSuccessStatusCode() ? ((Playlists)rsp.parseAs(Playlists.class)).getPlaylists() : null;
    }

    public Playlist getPlaylist(String token) throws IOException {
        HttpResponse rsp = this.doGET(ModelUtil.interpolate(Playlist.getPath(), token));
        return rsp.isSuccessStatusCode() ? ((PlaylistWrapper)rsp.parseAs(PlaylistWrapper.class)).getPlaylist() : null;
    }

    public Notifications getNotifications() throws IOException {
        HttpResponse rsp = this.doGET(Notifications.getPath());
        return rsp.isSuccessStatusCode() ? (Notifications)rsp.parseAs(Notifications.class) : null;
    }

    public Upload newUpload(File file) {
        return this.newUpload(file, null);
    }

    public Upload newUpload(File file, NetworkProgressListener listener) {
        return new Upload(this, file, listener);
    }

    public HttpResponse doGET(String path) throws IOException {
        return this.doGET(path, null, null);
    }

    public HttpResponse doGET(String path, JsonObjectParser parser, HttpHeaders headers) throws IOException {
        return this.doRequest("GET", path, null, parser, headers);
    }

    public HttpResponse doPUT(String path, HttpContent data) throws IOException {
        return this.doPUT(path, data, null, null);
    }

    public HttpResponse doPUT(String path, HttpContent data, JsonObjectParser parser, HttpHeaders headers) throws IOException {
        return this.doRequest("PUT", path, data, parser, headers);
    }

    public HttpResponse doDELETE(String path) throws IOException {
        return this.doDELETE(path, null, null);
    }

    public HttpResponse doDELETE(String path, JsonObjectParser parser, HttpHeaders headers) throws IOException {
        return this.doRequest("DELETE", path, null, parser, headers);
    }

    public HttpResponse doPOST(String path) throws IOException {
        return this.doPOST(path, null, null, null);
    }

    public HttpResponse doPOST(String path, HttpContent data) throws IOException {
        return this.doPOST(path, data, null, null);
    }

    public HttpResponse doPOST(String path, HttpContent data, JsonObjectParser parser, HttpHeaders headers) throws IOException {
        return this.doRequest("POST", path, data, parser, headers);
    }

    public HttpResponse doRequest(String method, String path, HttpContent data, JsonObjectParser parser, HttpHeaders headers) throws IOException {
        return this.doRequestToChannel(method, path, data, parser, null, headers);
    }

    public HttpResponse doRequestToChannel(String method, String path, HttpContent data, JsonObjectParser parser, Configuration.Channels channel, HttpHeaders headers) throws IOException {
        if (channel == null) {
            channel = Configuration.Channels.api;
        }
        HttpResponse response = this.getRequestFactory(parser, headers).buildRequest(method, new GenericUrl(this.getConf().getBaseUrl(channel) + path), data).execute();
        this.validateResponse(response);
        return response;
    }

    private HttpRequestFactory getRequestFactory(final JsonObjectParser parser, final HttpHeaders headers) {
        return this.getConf().getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                HttpRequestInitializer c = Client.this.createCredentialWithRefreshToken();
                c.initialize(request);
                request.setParser((ObjectParser)(parser == null ? Client.this.jsonObjectParser : parser));
                request.setThrowExceptionOnExecuteError(false);
                request.setSuppressUserAgentSuffix(true);
                HttpHeaders head = Client.this.getDefaultHeaders();
                if (headers != null) {
                    if (head != null) {
                        headers.fromHttpHeaders(head);
                    }
                    head = headers;
                }
                request.setHeaders(head);
            }
        });
    }

    private Credential buildNotSignedCredential() {
        return new Credential.Builder(BearerToken.authorizationHeaderAccessMethod()).setTransport(this.getConf().getHttpTransport()).setJsonFactory(this.getConf().getJsonFactory()).setTokenServerUrl(this.getConf().getEnvTokenUrl()).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication(this.getConf().getApiKey(), this.getConf().getApiSecret())).addRefreshListener(this.refreshListener).build();
    }

    private HttpRequestInitializer createCredentialWithRefreshToken() throws IOException {
        return this.createCredentialWithRefreshToken(this.getStoredCredential());
    }

    private HttpRequestInitializer createCredentialWithRefreshToken(TokenResponse tokenResponse) {
        return this.buildNotSignedCredential().setFromTokenResponse(tokenResponse);
    }

    private HttpRequestInitializer createCredentialWithRefreshToken(StoredCredential storedCredential) {
        return this.buildNotSignedCredential().setAccessToken(storedCredential.getAccessToken()).setExpiresInSeconds(storedCredential.getExpirationTimeMilliseconds()).setRefreshToken(storedCredential.getRefreshToken());
    }

    private StoredCredential getStoredCredential() throws IOException {
        return this.userDb.getCredentials(ACCOUNT_TOKENS);
    }

    private void validateResponse(HttpResponse response) throws IOException {
        try {
            switch (response.getStatusCode()) {
                case 400: 
                case 401: {
                    throw new AuthorizationException(response);
                }
                case 402: 
                case 403: {
                    throw new ForbiddenException(response);
                }
                case 404: {
                    throw new ResourceNotFoundException(response);
                }
                case 409: {
                    throw new FileAlreadyUploaded(response);
                }
                case 422: {
                    throw new ValidationException(response);
                }
                case 500: {
                    throw new RemoteMessageException(response);
                }
                case 503: {
                    throw new SystemOverloadedException(response);
                }
            }
        }
        catch (AudioBoxException e) {
            this.handleException(e);
        }
    }

    private AudioBoxException handleException(AudioBoxException e) throws AudioBoxException {
        ExceptionHandler eh = this.getConf().getExceptionHandler();
        if (eh != null && eh.onException(e)) {
            return e;
        }
        throw e;
    }
}

