/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.exceptions;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.LoggingByteArrayOutputStream;
import com.google.api.client.util.LoggingInputStream;
import fm.audiobox.core.exceptions.AudioBoxException;
import fm.audiobox.core.exceptions.Errors;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RemoteMessageException
extends AudioBoxException {
    private int statusCode = 401;
    private static final int NO_RESPONSE = -1;
    private Errors errors;

    public RemoteMessageException(HttpResponse response) {
        this(RemoteMessageException.parseErrors(response), response != null ? response.getStatusCode() : -1);
    }

    public RemoteMessageException(Errors errors, int statusCode) {
        super(RemoteMessageException.firstErrorToString(errors));
        this.errors = errors;
        this.statusCode = statusCode;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public int getErrorCode() {
        return this.statusCode;
    }

    public Errors getErrors() {
        if (this.errors == null) {
            this.errors = RemoteMessageException.buildEmptyErrors(this.getErrorCode());
        }
        return this.errors;
    }

    @Override
    public String toString() {
        return RemoteMessageException.errorsToString(this.getErrors());
    }

    public static String errorsToString(Errors errors) {
        String msg = errors.toString();
        if ("".equals(msg)) {
            for (Map.Entry<String, Object> entry : errors.getUnknownKeys().entrySet()) {
                msg = msg + RemoteMessageException.errorToString(entry) + "\n";
            }
        }
        return msg;
    }

    private static String errorToString(Map.Entry<String, Object> error) {
        return String.format("%1s: %2s", error.getKey(), error.getValue());
    }

    private static Errors parseErrors(HttpResponse response) {
        try {
            return (Errors)((Object)response.parseAs(Errors.class));
        }
        catch (Exception e) {
            logger.warn("Here's the 'Maytag(tm) repair man', we got something not expect, see below.");
            logger.warn(e.getMessage());
            if (response != null && response.getStatusMessage() != null) {
                try {
                    LoggingInputStream lis = (LoggingInputStream)response.getContent();
                    LoggingByteArrayOutputStream log = lis.getLogStream();
                    Errors es = new Errors();
                    es.setError(response.getStatusMessage());
                    es.setErrorDescription(log.toString());
                    return es;
                }
                catch (IOException e1) {
                    logger.error("Response message: " + response.getStatusMessage());
                    e1.printStackTrace();
                }
            }
            return RemoteMessageException.buildEmptyErrors(response == null ? -1 : response.getStatusCode());
        }
    }

    private static Errors buildEmptyErrors(int statusMessage) {
        HashMap<String, String> err = new HashMap<String, String>();
        err.put(RemoteMessageException.class.getCanonicalName(), String.format("Client got a remote error (%1d) but no message was given.", statusMessage));
        Errors errors = new Errors();
        errors.setUnknownKeys(err);
        return errors;
    }

    private static String firstErrorToString(Errors errors) {
        Iterator i$;
        if (errors == null) {
            errors = RemoteMessageException.buildEmptyErrors(0);
        }
        if ((i$ = errors.getUnknownKeys().entrySet().iterator()).hasNext()) {
            Map.Entry<String, Object> error = i$.next();
            return RemoteMessageException.errorToString(error);
        }
        return "";
    }
}

