/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.models;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.util.Key;
import fm.audiobox.core.Client;
import fm.audiobox.core.config.Configuration;
import fm.audiobox.core.models.MediaFileWrapper;
import fm.audiobox.core.models.Model;
import fm.audiobox.core.net.Download;
import fm.audiobox.core.net.NetworkProgressListener;
import fm.audiobox.core.utils.ModelUtil;
import java.io.IOException;
import java.io.OutputStream;

public class MediaFile
extends Model {
    private static final String PATH = "/api/v1/media_files/:token:.json";
    private static final String STREAM_PATH = "/api/v1/stream/:token:";
    private static final String DOWNLOAD_PATH = "/api/v1/download/:token:";
    private static final String SCROBBLE_PATH = "/api/v1/media_files/:token:/scrobble.json";
    private static final String LYRICS_PATH = "/api/v1/media_files/:token:/lyrics.json";
    private static final String LOVE_PATH = "/api/v1/media_files/:token:/love.json";
    private static final String UNLOVE_PATH = "/api/v1/media_files/:token:/unlove.json";
    private static final String TOGGLE_LOVE_PATH = "/api/v1/media_files/:token:/toggle_love.json";
    @Key
    protected String type;
    @Key
    protected String token;
    @Key
    protected String artist;
    @Key
    protected String album;
    @Key
    protected String genre;
    @Key(value="release_year")
    protected int releaseYear;
    @Key
    protected String title;
    @Key(value="len_str")
    protected String lenStr;
    @Key(value="len_int")
    protected int lenInt;
    @Key
    protected int position;
    @Key
    protected String filename;
    @Key(value="media_file_name")
    protected String mediaFileName;
    @Key
    protected boolean loved;
    @Key(value="disc_number")
    protected int discNumber;
    @Key
    protected String mime;
    @Key(value="remote_path")
    protected String remotePath;
    @Key
    protected String source;
    @Key(value="share_token")
    protected String shareToken;
    @Key
    protected String artwork;
    @Key
    protected long size;
    @Key(value="album_artist")
    protected String albumArtist;
    @Key
    protected String hash;
    @Key
    protected String composer;
    @Key
    protected String comment;
    @Key(value="video_bitrate")
    protected String videoBitrate;
    @Key(value="video_codec")
    protected String videoCodec;
    @Key(value="video_resolution")
    protected String videoResolution;
    @Key(value="video_fps")
    protected String videoFps;
    @Key(value="video_aspect")
    protected String videoAspect;
    @Key(value="video_container")
    protected String videoContainer;
    @Key(value="audio_bitrate")
    protected String audioBitrate;
    @Key(value="audio_codec")
    protected String audioCodec;
    @Key(value="audio_sample_rate")
    protected String audioSampleRate;
    @Key
    protected String lyrics;

    public static String getPath() {
        return PATH;
    }

    public String getStreamPath() {
        return ModelUtil.interpolate(STREAM_PATH, this.getFilename());
    }

    public String getStreamUrl(Client client, boolean secure) {
        return client.getConf().getBaseUrl(Configuration.Channels.api, secure) + this.getStreamPath();
    }

    public String getDownloadPath() {
        return ModelUtil.interpolate(DOWNLOAD_PATH, this.getFilename());
    }

    public String getDownloadUrl(Client client) {
        return client.getConf().getBaseUrl(Configuration.Channels.api) + this.getDownloadPath();
    }

    public static MediaFile load(Client client, String token) throws IOException {
        HttpResponse rsp = client.doGET(ModelUtil.interpolate(PATH, token));
        return rsp.isSuccessStatusCode() ? ((MediaFileWrapper)rsp.parseAs(client.getConf().getMediaFileWrapperClass())).getMediaFile() : null;
    }

    public MediaFile reload(Client client) throws IOException {
        return MediaFile.load(client, this.getToken());
    }

    public OutputStream download(Client client, OutputStream out) throws IOException {
        return this.download(client, out, null);
    }

    public OutputStream download(Client client, OutputStream out, NetworkProgressListener listener) throws IOException {
        HttpResponse rsp = client.doRequestToChannel("GET", ModelUtil.interpolate(this.getDownloadPath(), this.token), null, null, Configuration.Channels.upload, null);
        Download d = new Download(rsp.getContent(), out, listener, rsp.getHeaders().getContentLength());
        return d.start();
    }

    public MediaFile update(Client client) throws IOException {
        client.doPUT(ModelUtil.interpolate(MediaFile.getPath(), this.getToken()), (HttpContent)new JsonHttpContent(client.getConf().getJsonFactory(), (Object)this));
        return this;
    }

    public boolean destroy(Client client) throws IOException {
        HttpResponse rsp = client.doDELETE(ModelUtil.interpolate(MediaFile.getPath(), this.getToken()));
        return rsp.isSuccessStatusCode();
    }

    public MediaFile scrobble(Client client) throws IOException {
        client.doPOST(ModelUtil.interpolate(SCROBBLE_PATH, this.getToken()));
        return this;
    }

    public String getLyrics(Client client) throws IOException {
        if (this.getLyricsField() != null) {
            return this.getLyricsField();
        }
        HttpResponse rsp = client.doGET(ModelUtil.interpolate(LYRICS_PATH, this.getToken()));
        MediaFile m = rsp.isSuccessStatusCode() ? ((MediaFileWrapper)rsp.parseAs(MediaFileWrapper.class)).getMediaFile() : null;
        this.lyrics = m != null ? m.getLyricsField() : null;
        return this.lyrics;
    }

    public MediaFile love(Client client) throws IOException {
        this.setPreferred(client, LOVE_PATH);
        this.loved = true;
        return this;
    }

    public MediaFile unlove(Client client) throws IOException {
        this.setPreferred(client, UNLOVE_PATH);
        this.loved = false;
        return this;
    }

    public MediaFile toggleLove(Client client) throws IOException {
        this.setPreferred(client, TOGGLE_LOVE_PATH);
        this.loved = !this.loved;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public int getReleaseYear() {
        return this.releaseYear;
    }

    public void setReleaseYear(int releaseYear) {
        this.releaseYear = releaseYear;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLenStr() {
        return this.lenStr;
    }

    public int getLenInt() {
        return this.lenInt;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getFilename() {
        return this.filename == null ? this.mediaFileName : this.filename;
    }

    public boolean isLoved() {
        return this.loved;
    }

    public void setLoved(boolean loved) {
        this.loved = loved;
    }

    public int getDiscNumber() {
        return this.discNumber;
    }

    public void setDiscNumber(int discNumber) {
        this.discNumber = discNumber;
    }

    public String getMime() {
        return this.mime;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public String getSource() {
        return this.source;
    }

    public String getShareToken() {
        return this.shareToken;
    }

    public String getArtwork() {
        return this.artwork;
    }

    public void setArtwork(String artwork) {
        this.artwork = artwork;
    }

    public long getSize() {
        return this.size;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public void setAlbumArtist(String albumArtist) {
        this.albumArtist = albumArtist;
    }

    public String getHash() {
        return this.hash;
    }

    public String getComposer() {
        return this.composer;
    }

    public void setComposer(String composer) {
        this.composer = composer;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getVideoBitrate() {
        return this.videoBitrate;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public String getVideoResolution() {
        return this.videoResolution;
    }

    public String getVideoFps() {
        return this.videoFps;
    }

    public String getVideoAspect() {
        return this.videoAspect;
    }

    public String getVideoContainer() {
        return this.videoContainer;
    }

    public String getAudioBitrate() {
        return this.audioBitrate;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public String getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setLenStr(String lenStr) {
        this.lenStr = lenStr;
    }

    public void setLenInt(int lenInt) {
        this.lenInt = lenInt;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setMediaFileName(String mediaFileName) {
        this.mediaFileName = mediaFileName;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setShareToken(String shareToken) {
        this.shareToken = shareToken;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setVideoBitrate(String videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public void setVideoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
    }

    public void setVideoResolution(String videoResolution) {
        this.videoResolution = videoResolution;
    }

    public void setVideoFps(String videoFps) {
        this.videoFps = videoFps;
    }

    public void setVideoAspect(String videoAspect) {
        this.videoAspect = videoAspect;
    }

    public void setVideoContainer(String videoContainer) {
        this.videoContainer = videoContainer;
    }

    public void setAudioBitrate(String audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    public void setAudioSampleRate(String audioSampleRate) {
        this.audioSampleRate = audioSampleRate;
    }

    public void setLyrics(String lyrics) {
        this.lyrics = lyrics;
    }

    private String getLyricsField() {
        return this.lyrics;
    }

    private boolean setPreferred(Client client, String path) throws IOException {
        client.doPOST(ModelUtil.interpolate(path, this.getToken()));
        return true;
    }
}

