/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.models;

import com.google.api.client.util.Key;
import fm.audiobox.core.Client;
import fm.audiobox.core.models.Model;
import fm.audiobox.core.models.Playlist;
import fm.audiobox.core.utils.ModelUtil;
import java.io.IOException;
import java.util.List;

public class Playlists
extends Model {
    private static final String PATH = "/api/v1/playlists.json";
    public static final String PLAYLIST_LOCAL = "local";
    public static final String PLAYLIST_CLOUD = "cloud";
    public static final String PLAYLIST_DROPBOX = "dropbox";
    public static final String PLAYLIST_ONERIVE = "skydrive";
    public static final String PLAYLIST_BOX = "box";
    public static final String PLAYLIST_GDRIVE = "gdrive";
    public static final String PLAYLIST_YOUTUBE = "youtube";
    public static final String PLAYLIST_SOUNDCLOUD = "soundcloud";
    public static final String PLAYLIST_UBUNTU = "ubuntu";
    public static final String PLAYLIST_OFFLINE = "offline";
    @Key(value="playlists")
    private List<Playlist> playlists;

    public static String getPath() {
        return PATH;
    }

    public List<Playlist> getPlaylists() {
        return this.playlists;
    }

    public static Playlist getLocalPlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_LOCAL);
    }

    public static Playlist getCloudPlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_CLOUD);
    }

    public static Playlist getDropboxPlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_DROPBOX);
    }

    public static Playlist getOneDrivePlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_ONERIVE);
    }

    public static Playlist getBoxPlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_BOX);
    }

    public static Playlist getGdrivePlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_GDRIVE);
    }

    public static Playlist getYoutubePlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_YOUTUBE);
    }

    public static Playlist getSoundcloudPlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_SOUNDCLOUD);
    }

    public static Playlist getUbuntuPlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_UBUNTU);
    }

    public static Playlist getOfflinePlaylist(Client client) throws IOException {
        return Playlists.getPlaylistOfType(client, PLAYLIST_OFFLINE);
    }

    private static Playlist getPlaylistOfType(Client client, String type) throws IOException {
        return ModelUtil.findPlaylistByType(client.getPlaylists(), type);
    }
}

