/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.parsers;

import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.Preconditions;
import fm.audiobox.core.Client;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public class AudioBoxObjectParser
extends JsonObjectParser {
    private CustomizeJsonParser customParser;

    public AudioBoxObjectParser(Client client, CustomizeJsonParser customParser) {
        super(new JsonObjectParser.Builder(client.getConf().getJsonFactory()));
        this.customParser = customParser;
    }

    public <T> T parseAndClose(InputStream in, Charset charset, Class<T> dataClass) throws IOException {
        return (T)this.parseAndClose(in, charset, (Type)dataClass);
    }

    public Object parseAndClose(InputStream in, Charset charset, Type dataType) throws IOException {
        JsonParser parser = this.getJsonFactory().createJsonParser(in, charset);
        this.initializeParser(parser);
        return parser.parse(dataType, true, this.customParser);
    }

    public <T> T parseAndClose(Reader reader, Class<T> dataClass) throws IOException {
        return (T)this.parseAndClose(reader, (Type)dataClass);
    }

    public Object parseAndClose(Reader reader, Type dataType) throws IOException {
        JsonParser parser = this.getJsonFactory().createJsonParser(reader);
        this.initializeParser(parser);
        return parser.parse(dataType, true, this.customParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeParser(JsonParser parser) throws IOException {
        if (this.getWrapperKeys().isEmpty()) {
            return;
        }
        boolean failed = true;
        try {
            String match = parser.skipToKey(this.getWrapperKeys());
            Preconditions.checkArgument((match != null && parser.getCurrentToken() != JsonToken.END_OBJECT ? 1 : 0) != 0, (String)"wrapper key(s) not found: %s", (Object[])new Object[]{this.getWrapperKeys()});
            failed = false;
        }
        finally {
            if (failed) {
                parser.close();
            }
        }
    }
}

