/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.utils;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.util.Preconditions;
import fm.audiobox.core.net.NetworkProgressListener;
import fm.audiobox.core.utils.ProgressInputStream;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class MediaContent
extends AbstractInputStreamContent {
    private final File file;
    private ProgressInputStream pis;
    private NetworkProgressListener upl;

    public MediaContent(String type, File file) throws FileNotFoundException {
        super(type);
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.pis = new ProgressInputStream(file, file.length());
    }

    public void setUploadProgressListener(NetworkProgressListener networkProgressListener) {
        this.upl = networkProgressListener;
        this.pis.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("totalNumBytesRead".equals(evt.getPropertyName())) {
                    MediaContent.this.upl.onProgressUpdate(((ProgressInputStream)evt.getSource()).getMaxNumBytes(), (Long)evt.getNewValue());
                }
            }
        });
    }

    public long getLength() {
        return this.file.length();
    }

    public boolean retrySupported() {
        return true;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return this.pis;
    }

    public File getFile() {
        return this.file;
    }
}

