/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.utils;

import com.google.api.client.util.Preconditions;
import fm.audiobox.core.models.Playlist;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class ModelUtil {
    public static final String TOKEN_PLACEHOLDER = ":token:";
    public static final String ID_PLACEHOLDER = ":id:";
    public static final String AUDIOBOX_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static String interpolate(String url, String token) {
        return StringUtils.replace((String)url, (String)TOKEN_PLACEHOLDER, (String)token);
    }

    public static String interpolate(String url, long id) {
        return StringUtils.replace((String)url, (String)ID_PLACEHOLDER, (String)String.valueOf(id));
    }

    public static long toUnixTime(SimpleDateFormat simpleDateFormat, String audioboxDate) throws ParseException {
        simpleDateFormat.applyPattern(AUDIOBOX_DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = simpleDateFormat.parse(audioboxDate);
        return date.getTime();
    }

    public static Playlist findPlaylistByType(List<Playlist> playlists, String type) {
        Preconditions.checkNotNull(playlists);
        Preconditions.checkNotNull((Object)type);
        for (Playlist p : playlists) {
            if (!type.equals(p.getSystemName())) continue;
            return p;
        }
        return null;
    }
}

