/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.config;

import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import fm.audiobox.core.config.ConfigurationException;
import fm.audiobox.core.exceptions.ExceptionHandler;
import fm.audiobox.core.models.Albums;
import fm.audiobox.core.models.Artists;
import fm.audiobox.core.models.Genres;
import fm.audiobox.core.models.MediaFileWrapper;
import fm.audiobox.core.models.MediaFiles;
import fm.audiobox.core.store.CredentialDataStore;
import org.apache.commons.lang3.StringUtils;

public class Configuration {
    private static final String APP_NAME_PLACEHOLDER = ":appname:";
    private static final String VERSION_PLACEHOLDER = ":appversion:";
    private String apiKey;
    private String apiSecret;
    private Env environment;
    private HttpTransport httpTransport;
    private JsonFactory jsonFactory;
    private Config config;
    private Config envConfig;
    private GenericUrl tokenUrl;
    private CredentialDataStore db;
    private CredentialRefreshListener refreshListener;
    private Class<MediaFiles> mediaFilesWrapperClass;
    private Class<Albums> albumsWrapperClass;
    private Class<Genres> genresWrapperClass;
    private Class<Artists> artistsWrapperClass;
    private Class<MediaFileWrapper> mediaFileClass;
    private String userAgent;
    private String applicationName;
    private String version;
    private ExceptionHandler eh;

    public Configuration() {
        this(Env.production);
    }

    public Configuration(Env environment) {
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        this.environment = environment;
        this.config = ConfigFactory.load((String)"lib");
        this.setMediaFilesWrapperClass(MediaFiles.class);
        this.setAlbumsWrapperClass(Albums.class);
        this.setGenresWrapperClass(Genres.class);
        this.setArtistsWrapperClass(Artists.class);
        this.setMediaFileClass(MediaFileWrapper.class);
        this.setApplicationName("AudioBox-JLib");
        this.setVersion("1.0");
        this.userAgent = "AudioBox.fm (Java; " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + "; " + System.getProperty("user.language") + "; " + System.getProperty("java.runtime.version") + ") " + System.getProperty("java.vm.name") + "/" + System.getProperty("java.vm.version") + " " + APP_NAME_PLACEHOLDER + "/" + VERSION_PLACEHOLDER;
    }

    public Configuration setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public Configuration setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    public Configuration setHttpTransport(HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
        return this;
    }

    public Configuration setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
        return this;
    }

    public Configuration setCredentialDataStore(CredentialDataStore credentialDataStore) {
        this.db = credentialDataStore;
        return this;
    }

    public Configuration setCredentialRefreshListener(CredentialRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
        return this;
    }

    public Configuration setMediaFilesWrapperClass(Class<MediaFiles> klass) {
        this.mediaFilesWrapperClass = klass;
        return this;
    }

    public Configuration setAlbumsWrapperClass(Class<Albums> klass) {
        this.albumsWrapperClass = klass;
        return this;
    }

    public Configuration setGenresWrapperClass(Class<Genres> klass) {
        this.genresWrapperClass = klass;
        return this;
    }

    public Configuration setArtistsWrapperClass(Class<Artists> klass) {
        this.artistsWrapperClass = klass;
        return this;
    }

    public Configuration setMediaFileClass(Class<MediaFileWrapper> klass) {
        this.mediaFileClass = klass;
        return this;
    }

    @Deprecated
    public Configuration setEnvironment(Env environment) {
        this.environment = environment;
        return this;
    }

    public Configuration setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public Configuration setVersion(String version) {
        this.version = version;
        return this;
    }

    public synchronized void setExceptionHandler(ExceptionHandler handler) {
        this.eh = handler;
    }

    public CredentialDataStore getCredentialDataStore() {
        return this.db;
    }

    public CredentialRefreshListener getRefreshListener() {
        return this.refreshListener;
    }

    public Config getEnvironmentConfiguration(Env environment) {
        if (this.envConfig == null) {
            this.envConfig = this.config.getConfig("abx." + environment.name());
        }
        return this.envConfig;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(Channels.api);
    }

    public String getBaseUrl(Channels channel) {
        return this.getBaseUrl(channel, true);
    }

    public String getUnsecureBaseUrl(Channels channel) {
        return this.getBaseUrl(channel, false);
    }

    public String getBaseUrl(Channels channel, boolean secure) {
        Config envConf = this.getEnvironmentConfiguration(this.getEnvironment());
        String protocol = secure ? envConf.getString((Object)((Object)channel) + ".protocol") : "http";
        String host = this.getEnvHost(channel);
        String port = "";
        try {
            port = ":" + envConf.getString((Object)((Object)channel) + ".port");
        }
        catch (ConfigException.Missing e) {
            // empty catch block
        }
        return protocol + "://" + host + port;
    }

    public String getEnvHost(Channels channel) {
        Config envConf = this.getEnvironmentConfiguration(this.getEnvironment());
        return envConf.getString((Object)((Object)channel) + ".host");
    }

    public GenericUrl getEnvTokenUrl() {
        if (this.tokenUrl == null) {
            this.tokenUrl = new GenericUrl(this.getBaseUrl(Channels.api) + this.getEnvironmentConfiguration(this.getEnvironment()).getString("api.oauth.tokenPath"));
        }
        return this.tokenUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public Env getEnvironment() {
        return this.environment;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public Class<MediaFiles> getMediaFilesWrapperClass() {
        return this.mediaFilesWrapperClass;
    }

    public Class<? extends MediaFileWrapper> getMediaFileWrapperClass() {
        return this.mediaFileClass;
    }

    public Class<? extends Albums> getAlbumsWrapperClass() {
        return this.albumsWrapperClass;
    }

    public Class<? extends Genres> getGenresWrapperClass() {
        return this.genresWrapperClass;
    }

    public Class<? extends Artists> getArtistsWrapperClass() {
        return this.artistsWrapperClass;
    }

    public String getUserAgent() {
        this.userAgent = this.userAgent.replace(APP_NAME_PLACEHOLDER, this.getApplicationName()).replace(VERSION_PLACEHOLDER, this.getVersion());
        return this.userAgent;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getVersion() {
        return this.version;
    }

    public synchronized ExceptionHandler getExceptionHandler() {
        return this.eh;
    }

    public void checkConfiguration() throws ConfigurationException {
        this.config.checkValid(ConfigFactory.defaultReference(), new String[]{"abx"});
        if (StringUtils.isBlank((CharSequence)this.getApiKey())) {
            throw new ConfigurationException("API Key (secret) is missing, please provide one.");
        }
        if (StringUtils.isBlank((CharSequence)this.getApiSecret())) {
            throw new ConfigurationException("Client ID is missing, please provide one.");
        }
        if (this.getCredentialDataStore() == null) {
            throw new ConfigurationException("Credential data store must be set.");
        }
        if (this.getRefreshListener() == null) {
            throw new ConfigurationException("Credential refresh listener must be set.");
        }
        if (this.getHttpTransport() == null) {
            throw new ConfigurationException("Http transport type must be set");
        }
        if (this.getJsonFactory() == null) {
            throw new ConfigurationException("JSON factory must be set");
        }
    }

    public static enum Channels {
        api,
        daemon,
        upload;

    }

    public static enum Env {
        production,
        staging,
        development;

    }
}

