/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.models;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import fm.audiobox.core.AudioBoxClient;
import fm.audiobox.core.exceptions.AudioBoxException;
import fm.audiobox.core.exceptions.SyncException;
import fm.audiobox.core.models.Albums;
import fm.audiobox.core.models.Artists;
import fm.audiobox.core.models.Genres;
import fm.audiobox.core.models.MediaFile;
import fm.audiobox.core.models.MediaFiles;
import fm.audiobox.core.models.Model;
import fm.audiobox.core.models.PlaylistWrapper;
import fm.audiobox.core.models.Playlists;
import fm.audiobox.core.utils.ModelUtil;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Playlist
extends Model {
    private static final String PATH = "/api/v1/playlists/:token:.json";
    private static final String SYNC_PATH = "/api/v1/playlists/:token:/sync.json";
    private static final String VISIBILITY_PATH = "/api/v1/playlists/:token:/visible.json";
    private static final String MEDIA_FILES_PATH = "/api/v1/playlists/:token:/media_files.json";
    private static final String ADD_MEDIA_FILES_PATH = "/api/v1/playlists/:token:/media_files/add.json";
    private static final String REMOVE_MEDIA_FILES_PATH = "/api/v1/playlists/:token:/media_files/remove.json";
    private static final String FINGERPRINTS_PATH = "/api/v1/playlists/:token:/media_files/fingerprints.json";
    @Key
    private String token;
    @Key
    private String name;
    @Key(value="system_name")
    private String systemName;
    @Key
    private String type;
    @Key(value="media_files_count")
    private long mediaFilesCount;
    @Key
    private long position;
    @Key
    private boolean embeddable;
    @Key
    private boolean visible;
    @Key(value="last_accessed")
    private boolean lastAccessed;
    @Key(value="updated_at")
    private String updatedAt;
    @Key
    private boolean syncable;
    @Key
    private String description;

    public Playlist() {
    }

    public Playlist(String name) {
        this.name = name;
        this.setVisible(true);
    }

    public Playlist create(AudioBoxClient audioBoxClient) throws IOException {
        this.validateForRequest(false);
        HttpResponse rsp = audioBoxClient.doPOST(Playlists.getPath(), (HttpContent)new JsonHttpContent(audioBoxClient.getConf().getJsonFactory(), (Object)this));
        return rsp != null && rsp.isSuccessStatusCode() ? ((PlaylistWrapper)rsp.parseAs(PlaylistWrapper.class)).getPlaylist() : null;
    }

    public Playlist update(AudioBoxClient audioBoxClient) throws IOException {
        this.ensurePlaylistForRequest();
        audioBoxClient.doPUT(ModelUtil.interpolate(Playlist.getPath(), this.getToken()), (HttpContent)new JsonHttpContent(audioBoxClient.getConf().getJsonFactory(), (Object)this));
        return this;
    }

    public boolean destroy(AudioBoxClient audioBoxClient) throws IOException {
        this.ensurePlaylistForRequest();
        HttpResponse rsp = audioBoxClient.doDELETE(ModelUtil.interpolate(Playlist.getPath(), this.getToken()));
        return rsp != null && rsp.isSuccessStatusCode();
    }

    public boolean sync(AudioBoxClient audioBoxClient) throws IOException {
        HttpResponse rsp;
        this.ensurePlaylistForRequest();
        if (!this.isSyncable()) {
            throw new SyncException(422);
        }
        try {
            rsp = audioBoxClient.doPUT(this.getSyncPath(), (HttpContent)new JsonHttpContent(audioBoxClient.getConf().getJsonFactory(), (Object)this));
        }
        catch (AudioBoxException e) {
            throw new SyncException(e.getResponse());
        }
        return rsp != null && rsp.isSuccessStatusCode();
    }

    public boolean toggleVisibility(AudioBoxClient audioBoxClient) throws IOException {
        this.ensurePlaylistForRequest();
        audioBoxClient.doPUT(this.getVisibilityPath(), (HttpContent)new JsonHttpContent(audioBoxClient.getConf().getJsonFactory(), (Object)this));
        return true;
    }

    public List<MediaFile> getMediaFiles(AudioBoxClient audioBoxClient) throws IOException {
        return this.getMediaFiles(audioBoxClient, 0L);
    }

    public List<MediaFile> getMediaFiles(AudioBoxClient audioBoxClient, JsonObjectParser parser) throws IOException {
        return this.getMediaFiles(audioBoxClient, 0L, null, parser);
    }

    public List<MediaFile> getMediaFiles(AudioBoxClient audioBoxClient, long since) throws IOException {
        return this.getMediaFiles(audioBoxClient, since, null);
    }

    public List<MediaFile> getMediaFiles(AudioBoxClient audioBoxClient, long since, String set) throws IOException {
        return this.getMediaFiles(audioBoxClient, since, null, null);
    }

    public List<MediaFile> getMediaFiles(AudioBoxClient audioBoxClient, long since, String set, JsonObjectParser parser) throws IOException {
        HttpResponse rsp;
        this.ensurePlaylistForRequest();
        String url = this.getMediaFilesPath();
        if (since != 0L) {
            url = url + "?since=" + since;
        }
        if (set != null) {
            String setParam = "set=" + set;
            setParam = url.contains("?") ? "&" : "?" + setParam;
            url = url + setParam;
        }
        return (rsp = audioBoxClient.doGET(url, parser, null)) != null && rsp.isSuccessStatusCode() ? ((MediaFiles)rsp.parseAs(audioBoxClient.getConf().getMediaFilesWrapperClass())).getMediaFiles() : null;
    }

    public Albums getAlbums(AudioBoxClient audioBoxClient) throws IOException {
        return this.getGroupedCollection(audioBoxClient, audioBoxClient.getConf().getAlbumsWrapperClass(), Albums.getPath(this.token));
    }

    public Genres getGenres(AudioBoxClient audioBoxClient) throws IOException {
        return this.getGroupedCollection(audioBoxClient, audioBoxClient.getConf().getGenresWrapperClass(), Genres.getPath(this.token));
    }

    public Artists getArtists(AudioBoxClient audioBoxClient) throws IOException {
        return this.getGroupedCollection(audioBoxClient, audioBoxClient.getConf().getArtistsWrapperClass(), Artists.getPath(this.token));
    }

    public Playlist addMediaFiles(AudioBoxClient audioBoxClient, List<String> tokens) throws IOException {
        this.ensurePlaylistForRequest();
        GenericData d = new GenericData();
        for (String token : tokens) {
            d.put("tokens[]", (Object)token);
        }
        JsonHttpContent data = new JsonHttpContent(audioBoxClient.getConf().getJsonFactory(), (Object)d);
        audioBoxClient.doPOST(ModelUtil.interpolate(ADD_MEDIA_FILES_PATH, this.getToken()), (HttpContent)data, null, null);
        return this;
    }

    public Playlist removeMediaFiles(AudioBoxClient audioBoxClient, List<String> tokens) throws IOException {
        this.ensurePlaylistForRequest();
        String url = ModelUtil.interpolate(REMOVE_MEDIA_FILES_PATH, this.getToken()) + "?utf8=true";
        for (String tk : tokens) {
            url = url + "&tokens[]=" + tk;
        }
        audioBoxClient.doDELETE(url);
        return this;
    }

    public List<? extends MediaFile> getFingerprints(AudioBoxClient audioBoxClient) throws IOException {
        return this.getFingerprints(audioBoxClient, null);
    }

    public List<? extends MediaFile> getFingerprints(AudioBoxClient audioBoxClient, JsonObjectParser parser) throws IOException {
        HttpResponse rsp = audioBoxClient.doGET(ModelUtil.interpolate(FINGERPRINTS_PATH, this.getToken()), parser, null);
        return rsp != null && rsp.isSuccessStatusCode() ? ((MediaFiles)rsp.parseAs(audioBoxClient.getConf().getMediaFilesWrapperClass())).getMediaFiles() : null;
    }

    public static String getPath() {
        return PATH;
    }

    public String getToken() {
        return this.token;
    }

    public String getName() {
        return this.name;
    }

    public Playlist setName(String name) {
        this.name = name;
        return this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getType() {
        return this.type;
    }

    public long getMediaFilesCount() {
        return this.mediaFilesCount;
    }

    public long getPosition() {
        return this.position;
    }

    public Playlist setPosition(long position) {
        this.position = position;
        return this;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public Playlist setEmbeddable(boolean embeddable) {
        this.embeddable = embeddable;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Playlist setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isLastAccessed() {
        return this.lastAccessed;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean isSyncable() {
        return this.syncable;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMediaFilesCount(long mediaFilesCount) {
        this.mediaFilesCount = mediaFilesCount;
    }

    public void setLastAccessed(boolean lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setSyncable(boolean syncable) {
        this.syncable = syncable;
    }

    public Playlist setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCustom() {
        return "custom".equals(this.getSystemName());
    }

    public boolean isSmart() {
        return "smart".equals(this.getSystemName());
    }

    public boolean isOffline() {
        return "offline".equals(this.getSystemName());
    }

    public boolean isDrive() {
        return !this.isCustom() && !this.isSmart() && !this.isOffline();
    }

    public final boolean equals(Object other) {
        boolean eq;
        if (other == null || !(other instanceof Playlist)) {
            return false;
        }
        Playlist o = (Playlist)other;
        if (this.token != null) {
            eq = this.token.equals(o.getToken());
        } else {
            boolean bl = eq = o.getToken() == null;
        }
        eq = this.updatedAt != null ? eq && this.updatedAt.equals(o.getUpdatedAt()) : o.getUpdatedAt() == null;
        return eq;
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.token != null) {
            hashCode = hashCode * 37 + this.token.hashCode();
        }
        if (this.updatedAt != null) {
            hashCode = hashCode * 37 + this.updatedAt.hashCode();
        }
        return hashCode;
    }

    private String getSyncPath() {
        return ModelUtil.interpolate(SYNC_PATH, this.getToken());
    }

    private String getVisibilityPath() {
        return ModelUtil.interpolate(VISIBILITY_PATH, this.getToken());
    }

    private String getMediaFilesPath() {
        return ModelUtil.interpolate(MEDIA_FILES_PATH, this.getToken());
    }

    private void ensurePlaylistForRequest() {
        this.validateForRequest(true);
    }

    private void validateForRequest(boolean newRecordNotAllowed) {
        if (newRecordNotAllowed && this.isNewRecord()) {
            throw new IllegalStateException("Playlist must be remotely created before performing the requested action.");
        }
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            throw new IllegalStateException("Playlist is not ready for remote request: name not valid");
        }
    }

    private boolean isNewRecord() {
        return StringUtils.isEmpty((CharSequence)this.getToken());
    }

    private <T> T getGroupedCollection(AudioBoxClient audioBoxClient, Class<T> klass, String path) throws IOException {
        this.ensurePlaylistForRequest();
        HttpResponse rsp = audioBoxClient.doGET(path);
        return (T)(rsp != null && rsp.isSuccessStatusCode() ? rsp.parseAs(klass) : null);
    }
}

