/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.models;

import com.google.api.client.util.Key;
import fm.audiobox.core.AudioBoxClient;
import fm.audiobox.core.models.Model;
import fm.audiobox.core.models.Playlist;
import fm.audiobox.core.utils.ModelUtil;
import java.io.IOException;
import java.util.List;

public class Playlists
extends Model {
    private static final String PATH = "/api/v1/playlists.json";
    public static final String PLAYLIST_LOCAL = "local";
    public static final String PLAYLIST_CLOUD = "cloud";
    public static final String PLAYLIST_DROPBOX = "dropbox";
    public static final String PLAYLIST_ONERIVE = "skydrive";
    public static final String PLAYLIST_BOX = "box";
    public static final String PLAYLIST_GDRIVE = "gdrive";
    public static final String PLAYLIST_YOUTUBE = "youtube";
    public static final String PLAYLIST_SOUNDCLOUD = "soundcloud";
    public static final String PLAYLIST_MEGA = "mega";
    public static final String PLAYLIST_OFFLINE = "offline";
    public static final String PLAYLIST_CUSTOM = "custom";
    public static final String PLAYLIST_SMART = "smart";
    @Key(value="playlists")
    private List<Playlist> playlists;

    public static String getPath() {
        return PATH;
    }

    public List<Playlist> getPlaylists() {
        return this.playlists;
    }

    public static Playlist getLocalPlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_LOCAL);
    }

    public static Playlist getCloudPlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_CLOUD);
    }

    public static Playlist getDropboxPlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_DROPBOX);
    }

    public static Playlist getOneDrivePlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_ONERIVE);
    }

    public static Playlist getBoxPlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_BOX);
    }

    public static Playlist getGdrivePlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_GDRIVE);
    }

    public static Playlist getYoutubePlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_YOUTUBE);
    }

    public static Playlist getSoundcloudPlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_SOUNDCLOUD);
    }

    public static Playlist getMegaPlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_MEGA);
    }

    public static Playlist getOfflinePlaylist(AudioBoxClient audioBoxClient) throws IOException {
        return Playlists.getPlaylistOfType(audioBoxClient, PLAYLIST_OFFLINE);
    }

    private static Playlist getPlaylistOfType(AudioBoxClient audioBoxClient, String type) throws IOException {
        return ModelUtil.findPlaylistByType(audioBoxClient.getPlaylists(), type);
    }
}

