/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.models;

import com.google.api.client.util.Key;
import fm.audiobox.core.models.Model;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Preferences
extends Model {
    public static final String PATH = "/api/v1/preferences.json";
    public static final Map<String, String> COLORS = new HashMap<String, String>(8);
    @Key
    protected String color;
    @Key
    protected boolean repeat;
    @Key
    protected boolean shuffle;
    @Key
    protected boolean autoplay;
    @Key
    protected boolean prebuffer;
    @Key
    protected boolean js_demuxer;
    @Key
    protected String top_bar_bg;
    @Key
    protected String volume_level;
    @Key
    protected boolean accept_emails;
    @Key
    protected boolean hide_tooltips;

    public String getColor() {
        return this.color;
    }

    public String getColorValue() {
        return COLORS.get(this.getColor());
    }

    public boolean isRepeatEnabled() {
        return this.repeat;
    }

    public boolean isShuffleEnabled() {
        return this.shuffle;
    }

    public boolean isAutoplayEnabled() {
        return this.autoplay;
    }

    public boolean isPrebufferEnabled() {
        return this.prebuffer;
    }

    public boolean isJsDemuxerEnabled() {
        return this.js_demuxer;
    }

    public String getTopBarBg() {
        return this.top_bar_bg;
    }

    public String getVolumeLevel() {
        return this.volume_level;
    }

    public boolean doesAcceptsEmails() {
        return this.accept_emails;
    }

    public boolean areTooltipsHidden() {
        return this.hide_tooltips;
    }

    public void setColor(String colorName) throws IllegalArgumentException {
        if (!COLORS.containsKey(colorName)) {
            throw new IllegalArgumentException("Color must be one of " + StringUtils.join(COLORS.keySet(), (String)", "));
        }
        this.color = colorName;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
    }

    public void setPrebuffer(boolean prebuffer) {
        this.prebuffer = prebuffer;
    }

    public void setJsDemuxer(boolean js_demuxer) {
        this.js_demuxer = js_demuxer;
    }

    public void setTopBarBg(String top_bar_bg) {
        this.top_bar_bg = top_bar_bg;
    }

    public void setVolumeLevel(String volume_level) {
        this.volume_level = volume_level;
    }

    public void setAcceptEmails(boolean accept_emails) {
        this.accept_emails = accept_emails;
    }

    public void setHideTooltips(boolean hide_tooltips) {
        this.hide_tooltips = hide_tooltips;
    }

    static {
        COLORS.put("techcrunch-green", "#3cc535");
        COLORS.put("shadows-grey", "#36393D");
        COLORS.put("flock-blue", "#4096EE");
        COLORS.put("audiobox-fm-blue", "#6DA5CB");
        COLORS.put("flickr-pink", "#FF0084");
        COLORS.put("last-fm-crimson", "#D01F3C");
        COLORS.put("mozilla-red", "#FF1A00");
        COLORS.put("rss-orange", "#FF7400");
    }
}

