/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.models.collections;

import fm.audiobox.core.models.Model;
import fm.audiobox.core.models.collections.ModelEvent;
import java.util.LinkedList;

public class EventedModelList<T>
extends LinkedList<T> {
    private Model parent;

    public EventedModelList() {
    }

    public EventedModelList(Model parent) {
        this();
        this.parent = parent;
    }

    @Override
    public boolean add(T t) {
        this.trigger(1, t);
        return super.add(t);
    }

    @Override
    public void add(int index, T element) {
        this.trigger(1, element);
        super.add(index, element);
    }

    @Override
    public void addFirst(T t) {
        this.trigger(1, t);
        super.addFirst(t);
    }

    @Override
    public void addLast(T t) {
        this.trigger(1, t);
        super.addLast(t);
    }

    @Override
    public boolean remove(Object o) {
        this.trigger(-1, o);
        return super.remove(o);
    }

    @Override
    public T remove(int index) {
        return (T)this.trigger(-1, super.remove(index));
    }

    @Override
    public T remove() {
        return (T)this.trigger(-1, super.remove());
    }

    @Override
    public T removeFirst() {
        return (T)this.trigger(-1, super.removeFirst());
    }

    @Override
    public T removeLast() {
        return (T)this.trigger(-1, super.removeLast());
    }

    @Override
    public void clear() {
        this.trigger(0, null);
        super.clear();
    }

    private T trigger(int what, T item) {
        if (this.parent != null) {
            new ModelEvent<T>(what, item, this, this.parent).trigger();
        }
        return item;
    }
}

