/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.net;

import fm.audiobox.core.net.NetworkProgressListener;
import fm.audiobox.core.net.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Download {
    private static final Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final int CHUNK = 4096;
    private OutputStream outputStream;
    private InputStream inputStream;
    private NetworkProgressListener listener;
    private State state = State.ready;
    private long length;

    public Download(InputStream inputStream, OutputStream outputStream, NetworkProgressListener listener, long length) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.length = length;
        this.setDownloadProgressListener(listener);
    }

    public void setDownloadProgressListener(NetworkProgressListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream start() {
        if (this.state != State.ready) {
            throw new IllegalStateException("Download has already started or completed");
        }
        this.state = State.started;
        try {
            int read;
            byte[] bytes = new byte[4096];
            int progress = 0;
            while ((read = this.inputStream.read(bytes)) != -1) {
                this.outputStream.write(bytes, 0, read);
                if (this.listener == null) continue;
                this.listener.onProgressUpdate(this.length, progress += read);
            }
            logger.debug("Download completed");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.state = State.completed;
        }
        return this.outputStream;
    }

    private static enum State {
        ready,
        started,
        completed;

    }
}

